/*
 * Decompiled with CFR 0.152.
 */
package com.thomas7520.macrokeybinds.gui.other;

import com.google.common.collect.ImmutableList;
import com.thomas7520.macrokeybinds.gui.EditMacroScreen;
import com.thomas7520.macrokeybinds.gui.ServerMacroScreen;
import com.thomas7520.macrokeybinds.object.DelayedMacro;
import com.thomas7520.macrokeybinds.object.IMacro;
import com.thomas7520.macrokeybinds.object.RepeatMacro;
import com.thomas7520.macrokeybinds.util.ButtonImageWidget;
import com.thomas7520.macrokeybinds.util.CheckboxEdited;
import com.thomas7520.macrokeybinds.util.MacroFlow;
import com.thomas7520.macrokeybinds.util.MacroUtil;
import java.awt.Color;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_7999;
import net.minecraft.class_8000;
import net.minecraft.class_8092;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class MacroList
extends class_4265<Entry> {
    final class_437 parent;
    private List<IMacro> macroList;
    private final boolean isServer;
    int maxKeyNameLength;
    private static final class_2960 EDIT_ICON = class_2960.method_60655((String)"macrokeybinds", (String)"textures/edit_button.png");
    private static final class_2960 DELETE_ICON = class_2960.method_60655((String)"macrokeybinds", (String)"textures/delete_button.png");
    private String searchBoxInput = "";
    @Nullable
    private List<IMacro> cachedList;

    public MacroList(class_437 parent, class_310 client, List<IMacro> macros, boolean isServer) {
        super(client, parent.field_22789, parent.field_22790 - 20 - 53, 43, 20);
        this.parent = parent;
        this.macroList = macros;
        this.isServer = isServer;
        macros.sort(Comparator.comparingLong(IMacro::getCreatedTime));
        macros.stream().map(bind -> new KeyBindingEntry((IMacro)bind, parent, isServer)).forEach(x$0 -> this.method_25321((class_350.class_351)x$0));
    }

    public void update(Supplier<String> p_101677_, boolean update) {
        if (!update && (this.searchBoxInput.equalsIgnoreCase(p_101677_.get()) || this.searchBoxInput.isEmpty() && p_101677_.get().isEmpty())) {
            return;
        }
        this.searchBoxInput = p_101677_.get();
        this.method_25339();
        this.method_44382(0.0);
        if (this.cachedList == null) {
            this.cachedList = this.macroList;
            this.macroList.sort(Comparator.comparingLong(IMacro::getCreatedTime));
        }
        if (!this.cachedList.isEmpty()) {
            String s = p_101677_.get().toLowerCase(Locale.ROOT);
            for (IMacro macro : this.cachedList) {
                if (!macro.getName().toLowerCase(Locale.ROOT).contains(s) && !macro.getName().toLowerCase(Locale.ROOT).contains(s)) continue;
                this.method_25321((class_350.class_351)new KeyBindingEntry(macro, this.parent, this.isServer));
            }
        }
    }

    public int method_25322() {
        return super.method_25322() + 15;
    }

    public void updateList(List<IMacro> list) {
        this.macroList = list;
        this.cachedList = null;
        this.method_25339();
        this.macroList.sort(Comparator.comparingLong(IMacro::getCreatedTime));
        this.macroList.forEach(p_97451_ -> this.method_25321((class_350.class_351)new KeyBindingEntry((IMacro)p_97451_, this.parent, this.isServer)));
    }

    protected int method_65507() {
        return super.method_65507() + 15 + 20;
    }

    protected class_8000 createPositioner(boolean hovered, boolean focused, class_339 focus) {
        if (!hovered && focused && class_310.method_1551().method_48186().method_48183()) {
            return new class_7999(focus.method_48202());
        }
        return new class_8092(focus.method_48202());
    }

    @Environment(value=EnvType.CLIENT)
    public class KeyBindingEntry
    extends Entry {
        private final IMacro macro;
        private final ButtonImageWidget editButton;
        private final CheckboxEdited stateButton;
        private final ButtonImageWidget deleteButton;

        public KeyBindingEntry(IMacro bind, class_437 parent, boolean isMacroServer) {
            this.macro = bind;
            this.editButton = ButtonImageWidget.builder((class_2561)class_2561.method_43473(), button -> MacroList.this.field_22740.method_1507((class_437)new EditMacroScreen(MacroList.this.parent, this.macro, parent instanceof ServerMacroScreen))).dimensions(0, 0, 20, 20).icon(EDIT_ICON).build();
            this.stateButton = CheckboxEdited.builder((class_2561)class_2561.method_43473(), ((MacroList)MacroList.this).field_22740.field_1772).pos(0, 0).callback((checkbox, checked) -> {
                Object directory = isMacroServer ? "/servers-macros/" + MacroUtil.getServerIP() + "/" : "/global-macros/";
                this.macro.setEnable(checked);
                MacroFlow.writeMacro(this.macro, new File(String.valueOf(FabricLoader.getInstance().getGameDir().resolve(FabricLoader.getInstance().getConfigDir())) + (String)directory).getPath());
            }).checked(this.macro.isEnable()).build();
            this.deleteButton = ButtonImageWidget.builder((class_2561)class_2561.method_43473(), button -> MacroList.this.field_22740.method_1507((class_437)new class_410(p_170322_ -> {
                if (p_170322_) {
                    if (isMacroServer) {
                        MacroUtil.getServerKeybinds().remove(this.macro.getUUID());
                    } else {
                        MacroUtil.getGlobalKeybindsMap().remove(this.macro.getUUID());
                    }
                    Object directory = isMacroServer ? "/servers-macros/" + MacroUtil.getServerIP() + "/" : "/global-macros/";
                    new File(String.valueOf(FabricLoader.getInstance().getGameDir().resolve(FabricLoader.getInstance().getConfigDir())) + (String)directory + "/" + this.macro.getUUID().toString() + ".json").delete();
                }
                MacroList.this.field_22740.method_1507(parent);
            }, (class_2561)class_2561.method_43471((String)"text.macro.deleteQuestion"), (class_2561)class_2561.method_43471((String)"text.macro.deleteWarning"), (class_2561)class_2561.method_43471((String)"text.macro.deleteButton"), class_5244.field_24335))).dimensions(20, 0, 20, 20).icon(DELETE_ICON).build();
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            RepeatMacro repeatMacro;
            DelayedMacro delayedMacro;
            float f = x - MacroList.this.maxKeyNameLength;
            context.method_27535(((MacroList)MacroList.this).field_22740.field_1772, (class_2561)class_2561.method_43470((String)this.macro.getName()), (int)f, y + 6, -1);
            this.deleteButton.method_46421(x + 190 + 20);
            this.deleteButton.method_46419(y);
            this.editButton.method_46421(x + 190);
            this.editButton.method_46419(y);
            this.stateButton.method_46421(x + 170);
            this.stateButton.method_46419(y);
            this.editButton.method_25394(context, mouseX, mouseY, tickDelta);
            this.stateButton.method_25394(context, mouseX, mouseY, tickDelta);
            this.deleteButton.method_25394(context, mouseX, mouseY, tickDelta);
            if (this.stateButton.method_49606()) {
                context.method_25294(this.stateButton.method_46426(), this.stateButton.method_46427(), this.stateButton.method_46426() + 20, this.stateButton.method_46427() + 1, Color.WHITE.getRGB());
                context.method_25294(this.stateButton.method_46426(), this.stateButton.method_46427() + 19, this.stateButton.method_46426() + 20, this.stateButton.method_46427() + 20, Color.WHITE.getRGB());
                context.method_25294(this.stateButton.method_46426(), this.stateButton.method_46427() + 20, this.stateButton.method_46426() + 1, this.stateButton.method_46427(), Color.WHITE.getRGB());
                context.method_25294(this.stateButton.method_46426() + 19, this.stateButton.method_46427(), this.stateButton.method_46426() + 20, this.stateButton.method_46427() + 20, Color.WHITE.getRGB());
                context.method_71274(((MacroList)MacroList.this).field_22740.field_1772.method_1728((class_5348)class_2561.method_43471((String)"text.tooltip.editmacro.state"), 150), mouseX, mouseY);
            }
            if (this.editButton.method_49606()) {
                context.method_71274(((MacroList)MacroList.this).field_22740.field_1772.method_1728((class_5348)class_2561.method_43471((String)"text.tooltip.editmacro.edit"), 150), mouseX, mouseY);
            }
            if (this.deleteButton.method_49606()) {
                context.method_71274(((MacroList)MacroList.this).field_22740.field_1772.method_1728((class_5348)class_2561.method_43471((String)"text.tooltip.editmacro.delete"), 150), mouseX, mouseY);
            }
            boolean running = false;
            IMacro iMacro = this.macro;
            if (iMacro instanceof DelayedMacro && (delayedMacro = (DelayedMacro)iMacro).isStart()) {
                running = true;
            }
            if ((iMacro = this.macro) instanceof RepeatMacro && (repeatMacro = (RepeatMacro)iMacro).isRepeat()) {
                running = true;
            }
            if (running) {
                if (mouseX >= x - 20 && mouseX <= x - 5 && mouseY >= y + 3 && mouseY < y + 12) {
                    context.method_51438(((MacroList)MacroList.this).field_22740.field_1772, (class_2561)class_2561.method_43471((String)"text.tooltip.running"), mouseX, mouseY);
                }
                context.method_51439(((MacroList)MacroList.this).field_22740.field_1772, (class_2561)class_2561.method_43471((String)"text.running"), x - 16, y + 6, Color.GREEN.getRGB(), true);
            }
        }

        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)((Object)this.editButton), (Object)((Object)this.deleteButton), (Object)((Object)this.stateButton));
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)((Object)this.editButton), (Object)((Object)this.deleteButton), (Object)((Object)this.stateButton));
        }

        @Override
        protected void update() {
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static abstract class Entry
    extends class_4265.class_4266<Entry> {
        abstract void update();
    }
}

