/*
 * Decompiled with CFR 0.152.
 */
package com.thomas7520.macrokeybinds;

import com.thomas7520.macrokeybinds.event.MacroEvent;
import com.thomas7520.macrokeybinds.object.IMacro;
import com.thomas7520.macrokeybinds.util.MacroFlow;
import com.thomas7520.macrokeybinds.util.MacroUtil;
import java.io.File;
import java.io.IOException;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MacroMod
implements ModInitializer {
    public static final String MODID = "macrokeybinds";
    public static final Logger LOGGER = LogManager.getLogger();

    public void onInitialize() {
        this.setup();
        this.registerKeybindingEvent();
        MacroEvent event = new MacroEvent();
        event.onInputEvent();
        event.onServerConnect();
        event.onServerDisconnect();
        event.onTick();
    }

    private void setup() {
        try {
            File directory = new File(String.valueOf(FabricLoader.getInstance().getGameDir().resolve(FabricLoader.getInstance().getConfigDir())) + "/global-macros");
            if (directory.mkdirs() || directory.listFiles() == null) {
                return;
            }
            for (File file : directory.listFiles()) {
                IMacro macro = MacroFlow.getMacroFromFile(file);
                if (macro == null) {
                    LOGGER.error(String.format("Macro from %s is null !", file.getAbsolutePath()));
                    continue;
                }
                MacroUtil.getGlobalKeybindsMap().put(macro.getUUID(), macro);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LOGGER.info(MacroUtil.getGlobalKeybindsMap().size() + " macros loaded");
    }

    private void registerKeybindingEvent() {
        MacroUtil.guiBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.macrokeybinds.openoptions.desc", 78, class_304.class_11900.method_74698((class_2960)class_2960.method_60654((String)"key.categories.macrokeybinds"))));
    }
}

