/*
 * Decompiled with CFR 0.152.
 */
package com.thomas7520.macrokeybinds.util;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.SuggestionContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11908;
import net.minecraft.class_124;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5481;
import net.minecraft.class_637;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;

public class MacroCMDSuggestor {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(\\s+)");
    private static final class_2583 ERROR_STYLE = class_2583.field_24360.method_10977(class_124.field_1061);
    private static final class_2583 INFO_STYLE = class_2583.field_24360.method_10977(class_124.field_1080);
    private static final List<class_2583> HIGHLIGHT_STYLES = (List)Stream.of(class_124.field_1075, class_124.field_1054, class_124.field_1060, class_124.field_1076, class_124.field_1065).map(arg_0 -> ((class_2583)class_2583.field_24360).method_10977(arg_0)).collect(ImmutableList.toImmutableList());
    final class_310 client;
    private final class_437 owner;
    final class_342 textField;
    final class_327 textRenderer;
    private final boolean slashOptional;
    private final boolean suggestingWhenEmpty;
    final int inWindowIndexOffset;
    final int maxSuggestionSize;
    final boolean chatScreenSized;
    final int color;
    private final List<class_5481> messages = Lists.newArrayList();
    private int x;
    private int width;
    @Nullable
    private ParseResults<class_637> parse;
    @Nullable
    private CompletableFuture<Suggestions> pendingSuggestions;
    @Nullable
    private SuggestionWindow window;
    private boolean windowActive;
    boolean completingSuggestions;
    private boolean canLeave = true;

    public MacroCMDSuggestor(class_310 client, class_437 owner, class_342 textField, class_327 textRenderer, boolean slashOptional, boolean suggestingWhenEmpty, int inWindowIndexOffset, int maxSuggestionSize, boolean chatScreenSized, int color) {
        this.client = client;
        this.owner = owner;
        this.textField = textField;
        this.textRenderer = textRenderer;
        this.slashOptional = slashOptional;
        this.suggestingWhenEmpty = suggestingWhenEmpty;
        this.inWindowIndexOffset = inWindowIndexOffset;
        this.maxSuggestionSize = maxSuggestionSize;
        this.chatScreenSized = chatScreenSized;
        this.color = color;
        textField.method_73210(this::provideRenderText);
    }

    public void setWindowActive(boolean windowActive) {
        this.windowActive = windowActive;
        if (!windowActive) {
            this.window = null;
        }
    }

    public void setCanLeave(boolean canLeave) {
        this.canLeave = canLeave;
    }

    public boolean keyPressed(class_11908 input) {
        boolean bl;
        boolean bl2 = bl = this.window != null;
        if (bl && this.window.keyPressed(input)) {
            return true;
        }
        if (this.owner.method_25399() != this.textField || !input.method_74236() || this.canLeave && !bl) {
            return false;
        }
        this.show(true);
        return true;
    }

    public boolean mouseScrolled(double amount) {
        return this.window != null && this.window.mouseScrolled(class_3532.method_15350((double)amount, (double)-1.0, (double)1.0));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return this.window != null && this.window.mouseClicked((int)mouseX, (int)mouseY, button);
    }

    public void show(boolean narrateFirstSuggestion) {
        Suggestions suggestions;
        if (this.pendingSuggestions != null && this.pendingSuggestions.isDone() && !(suggestions = this.pendingSuggestions.join()).isEmpty()) {
            int i = 0;
            for (Suggestion suggestion : suggestions.getList()) {
                i = Math.max(i, this.textRenderer.method_1727(suggestion.getText()));
            }
            int j = class_3532.method_15340((int)this.textField.method_1889(suggestions.getRange().getStart()), (int)0, (int)(this.textField.method_1889(0) + this.textField.method_1859() - i));
            int k = this.chatScreenSized ? this.owner.field_22790 - 12 : 72;
            this.window = new SuggestionWindow(j, this.textField.method_46427(), i, this.sortSuggestions(suggestions), narrateFirstSuggestion);
        }
    }

    public boolean isOpen() {
        return this.window != null;
    }

    public class_2561 getSuggestionUsageNarrationText() {
        if (this.window != null && this.window.completed) {
            if (this.canLeave) {
                return class_2561.method_43471((String)"narration.suggestion.usage.cycle.hidable");
            }
            return class_2561.method_43471((String)"narration.suggestion.usage.cycle.fixed");
        }
        if (this.canLeave) {
            return class_2561.method_43471((String)"narration.suggestion.usage.fill.hidable");
        }
        return class_2561.method_43471((String)"narration.suggestion.usage.fill.fixed");
    }

    public void clearWindow() {
        this.window = null;
    }

    private List<Suggestion> sortSuggestions(Suggestions suggestions) {
        String string = this.textField.method_1882().substring(0, this.textField.method_1881());
        int i = MacroCMDSuggestor.getStartOfCurrentWord(string);
        String string2 = string.substring(i).toLowerCase(Locale.ROOT);
        ArrayList list = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        for (Suggestion suggestion : suggestions.getList()) {
            if (suggestion.getText().startsWith(string2) || suggestion.getText().startsWith("minecraft:" + string2)) {
                list.add(suggestion);
                continue;
            }
            list2.add(suggestion);
        }
        list.addAll(list2);
        return list;
    }

    public void refresh() {
        boolean bl;
        String string = this.textField.method_1882();
        if (this.parse != null && !this.parse.getReader().getString().equals(string)) {
            this.parse = null;
        }
        if (!this.completingSuggestions) {
            this.textField.method_1887((String)null);
            this.window = null;
        }
        this.messages.clear();
        StringReader stringReader = new StringReader(string);
        boolean bl2 = bl = stringReader.canRead() && stringReader.peek() == '/';
        if (bl) {
            stringReader.skip();
        }
        boolean bl22 = this.slashOptional || bl;
        int i = this.textField.method_1881();
        if (bl22) {
            int j;
            CommandDispatcher commandDispatcher = this.client.field_1724.field_3944.method_2886();
            if (this.parse == null) {
                this.parse = commandDispatcher.parse(stringReader, (Object)this.client.field_1724.field_3944.method_2875());
            }
            int n = j = this.suggestingWhenEmpty ? stringReader.getCursor() : 1;
            if (!(i < j || this.window != null && this.completingSuggestions)) {
                this.pendingSuggestions = commandDispatcher.getCompletionSuggestions(this.parse, i);
                this.pendingSuggestions.thenRun(() -> {
                    if (this.pendingSuggestions.isDone()) {
                        this.showCommandSuggestions();
                    }
                });
            }
        } else {
            String string2 = string.substring(0, i);
            int j = MacroCMDSuggestor.getStartOfCurrentWord(string2);
            Collection collection = this.client.field_1724.field_3944.method_2875().method_44750();
            this.pendingSuggestions = class_2172.method_9265((Iterable)collection, (SuggestionsBuilder)new SuggestionsBuilder(string2, j));
        }
    }

    private static int getStartOfCurrentWord(String input) {
        if (Strings.isNullOrEmpty((String)input)) {
            return 0;
        }
        int i = 0;
        Matcher matcher = WHITESPACE_PATTERN.matcher(input);
        while (matcher.find()) {
            i = matcher.end();
        }
        return i;
    }

    private static class_5481 formatException(CommandSyntaxException exception) {
        class_2561 text = class_2564.method_10883((Message)exception.getRawMessage());
        String string = exception.getContext();
        if (string == null) {
            return text.method_30937();
        }
        return class_2561.method_43469((String)"command.context.parse_error", (Object[])new Object[]{text, exception.getCursor(), string}).method_30937();
    }

    private void showCommandSuggestions() {
        boolean bl = false;
        if (this.textField.method_1881() == this.textField.method_1882().length()) {
            if (this.pendingSuggestions.join().isEmpty() && !this.parse.getExceptions().isEmpty()) {
                int i = 0;
                for (Map.Entry entry : this.parse.getExceptions().entrySet()) {
                    CommandSyntaxException commandSyntaxException = (CommandSyntaxException)entry.getValue();
                    if (commandSyntaxException.getType() == CommandSyntaxException.BUILT_IN_EXCEPTIONS.literalIncorrect()) {
                        ++i;
                        continue;
                    }
                    this.messages.add(MacroCMDSuggestor.formatException(commandSyntaxException));
                }
                if (i > 0) {
                    this.messages.add(MacroCMDSuggestor.formatException(CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().create()));
                }
            } else if (this.parse.getReader().canRead()) {
                bl = true;
            }
        }
        this.x = 0;
        this.width = this.owner.field_22789;
        if (this.messages.isEmpty() && !this.showUsages(class_124.field_1080) && bl) {
            this.messages.add(MacroCMDSuggestor.formatException(class_2170.method_23917(this.parse)));
        }
        this.window = null;
        if (this.windowActive && ((Boolean)this.client.field_1690.method_42425().method_41753()).booleanValue()) {
            this.show(false);
        }
    }

    private boolean showUsages(class_124 formatting) {
        CommandContextBuilder commandContextBuilder = this.parse.getContext();
        SuggestionContext suggestionContext = commandContextBuilder.findSuggestionContext(this.textField.method_1881());
        Map map = this.client.field_1724.field_3944.method_2886().getSmartUsage(suggestionContext.parent, (Object)this.client.field_1724.field_3944.method_2875());
        ArrayList list = Lists.newArrayList();
        int i = 0;
        class_2583 style = class_2583.field_24360.method_10977(formatting);
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getKey() instanceof LiteralCommandNode) continue;
            list.add(class_5481.method_30747((String)((String)entry.getValue()), (class_2583)style));
            i = Math.max(i, this.textRenderer.method_1727((String)entry.getValue()));
        }
        if (!list.isEmpty()) {
            this.messages.addAll(list);
            this.x = class_3532.method_15340((int)this.textField.method_1889(suggestionContext.startPos), (int)0, (int)(this.textField.method_1889(0) + this.textField.method_1859() - i));
            this.width = i;
            return true;
        }
        return false;
    }

    private class_5481 provideRenderText(String original, int firstCharacterIndex) {
        if (this.parse != null) {
            return MacroCMDSuggestor.highlight(this.parse, original, firstCharacterIndex);
        }
        return class_5481.method_30747((String)original, (class_2583)class_2583.field_24360);
    }

    @Nullable
    static String getSuggestionSuffix(String original, String suggestion) {
        if (suggestion.startsWith(original)) {
            return suggestion.substring(original.length());
        }
        return null;
    }

    private static class_5481 highlight(ParseResults<class_637> parse, String original, int firstCharacterIndex) {
        int m;
        ArrayList list = Lists.newArrayList();
        int i = 0;
        int j = -1;
        CommandContextBuilder commandContextBuilder = parse.getContext().getLastChild();
        for (ParsedArgument parsedArgument : commandContextBuilder.getArguments().values()) {
            int k;
            if (++j >= HIGHLIGHT_STYLES.size()) {
                j = 0;
            }
            if ((k = Math.max(parsedArgument.getRange().getStart() - firstCharacterIndex, 0)) >= original.length()) break;
            int l = Math.min(parsedArgument.getRange().getEnd() - firstCharacterIndex, original.length());
            if (l <= 0) continue;
            list.add(class_5481.method_30747((String)original.substring(i, k), (class_2583)INFO_STYLE));
            list.add(class_5481.method_30747((String)original.substring(k, l), (class_2583)HIGHLIGHT_STYLES.get(j)));
            i = l;
        }
        if (parse.getReader().canRead() && (m = Math.max(parse.getReader().getCursor() - firstCharacterIndex, 0)) < original.length()) {
            int n = Math.min(m + parse.getReader().getRemainingLength(), original.length());
            list.add(class_5481.method_30747((String)original.substring(i, m), (class_2583)INFO_STYLE));
            list.add(class_5481.method_30747((String)original.substring(m, n), (class_2583)ERROR_STYLE));
            i = n;
        }
        list.add(class_5481.method_30747((String)original.substring(i), (class_2583)INFO_STYLE));
        return class_5481.method_30749((List)list);
    }

    public void render(class_332 context, int mouseX, int mouseY) {
        if (!this.tryRenderWindow(context, mouseX, mouseY)) {
            this.renderMessages(context);
        }
    }

    public boolean tryRenderWindow(class_332 context, int mouseX, int mouseY) {
        if (this.window != null) {
            this.window.render(context, mouseX, mouseY);
            return true;
        }
        return false;
    }

    public void renderMessages(class_332 context) {
        int i = 0;
        for (class_5481 orderedText : this.messages) {
            int j = this.textField.method_46427() - 20;
            context.method_25294(this.x - 1, j, this.x + this.width + 1, j + 12, this.color);
            context.method_35720(this.textRenderer, orderedText, this.x, j + 2, -1);
            ++i;
        }
    }

    public class_2561 getNarration() {
        if (this.window != null) {
            return class_5244.field_33849.method_27661().method_10852(this.window.getNarration());
        }
        return class_5244.field_39003;
    }

    @Environment(value=EnvType.CLIENT)
    public class SuggestionWindow {
        private final class_768 area;
        private final String typedText;
        private final List<Suggestion> suggestions;
        private int inWindowIndex;
        private int selection;
        private class_241 mouse = class_241.field_1340;
        boolean completed;
        private int lastNarrationIndex;

        SuggestionWindow(int x, int y, int width, List<Suggestion> suggestions, boolean narrateFirstSuggestion) {
            int i = x - 1;
            int j = MacroCMDSuggestor.this.chatScreenSized ? y - 3 - Math.min(suggestions.size(), MacroCMDSuggestor.this.maxSuggestionSize) * 12 : y;
            this.area = new class_768(i, j, width + 1, Math.min(suggestions.size(), MacroCMDSuggestor.this.maxSuggestionSize) * 12);
            this.typedText = MacroCMDSuggestor.this.textField.method_1882();
            this.lastNarrationIndex = narrateFirstSuggestion ? -1 : 0;
            this.suggestions = suggestions;
            this.select(0);
        }

        public void render(class_332 context, int mouseX, int mouseY) {
            Message message;
            int i = Math.min(this.suggestions.size(), MacroCMDSuggestor.this.maxSuggestionSize);
            int j = -5592406;
            boolean bl = this.inWindowIndex > 0;
            boolean bl2 = this.suggestions.size() > this.inWindowIndex + i;
            boolean bl3 = bl || bl2;
            boolean bl4 = this.mouse.field_1343 != (float)mouseX || this.mouse.field_1342 != (float)mouseY;
            boolean bl5 = bl4;
            if (bl4) {
                this.mouse = new class_241((float)mouseX, (float)mouseY);
            }
            if (bl3) {
                int k;
                context.method_25294(this.area.method_3321(), this.area.method_3322() - 1, this.area.method_3321() + this.area.method_3319(), this.area.method_3322(), MacroCMDSuggestor.this.color);
                context.method_25294(this.area.method_3321(), this.area.method_3322() + this.area.method_3320(), this.area.method_3321() + this.area.method_3319(), this.area.method_3322() + this.area.method_3320() + 1, MacroCMDSuggestor.this.color);
                if (bl) {
                    for (k = 0; k < this.area.method_3319(); ++k) {
                        if (k % 2 != 0) continue;
                        context.method_25294(this.area.method_3321() + k, this.area.method_3322() - 1, this.area.method_3321() + k + 1, this.area.method_3322(), -1);
                    }
                }
                if (bl2) {
                    for (k = 0; k < this.area.method_3319(); ++k) {
                        if (k % 2 != 0) continue;
                        context.method_25294(this.area.method_3321() + k, this.area.method_3322() + this.area.method_3320(), this.area.method_3321() + k + 1, this.area.method_3322() + this.area.method_3320() + 1, -1);
                    }
                }
            }
            boolean bl52 = false;
            for (int l = 0; l < i; ++l) {
                Suggestion suggestion = this.suggestions.get(l + this.inWindowIndex);
                context.method_25294(this.area.method_3321(), this.area.method_3322() + 12 * l, this.area.method_3321() + this.area.method_3319(), this.area.method_3322() + 12 * l + 12, MacroCMDSuggestor.this.color);
                if (mouseX > this.area.method_3321() && mouseX < this.area.method_3321() + this.area.method_3319() && mouseY > this.area.method_3322() + 12 * l && mouseY < this.area.method_3322() + 12 * l + 12) {
                    if (bl4) {
                        this.select(l + this.inWindowIndex);
                    }
                    bl52 = true;
                }
                context.method_25303(MacroCMDSuggestor.this.textRenderer, suggestion.getText(), this.area.method_3321() + 1, this.area.method_3322() + 2 + 12 * l, l + this.inWindowIndex == this.selection ? Color.YELLOW.getRGB() : -5592406);
            }
            if (bl52 && (message = this.suggestions.get(this.selection).getTooltip()) != null) {
                context.method_51438(MacroCMDSuggestor.this.textRenderer, class_2564.method_10883((Message)message), mouseX, mouseY);
            }
        }

        public boolean mouseClicked(int x, int y, int button) {
            if (!this.area.method_3318(x, y)) {
                return false;
            }
            int i = (y - this.area.method_3322()) / 12 + this.inWindowIndex;
            if (i >= 0 && i < this.suggestions.size()) {
                this.select(i);
                this.complete();
            }
            return true;
        }

        public boolean mouseScrolled(double amount) {
            int j;
            int i = (int)(MacroCMDSuggestor.this.client.field_1729.method_1603() * (double)MacroCMDSuggestor.this.client.method_22683().method_4486() / (double)MacroCMDSuggestor.this.client.method_22683().method_4480());
            if (this.area.method_3318(i, j = (int)(MacroCMDSuggestor.this.client.field_1729.method_1604() * (double)MacroCMDSuggestor.this.client.method_22683().method_4502() / (double)MacroCMDSuggestor.this.client.method_22683().method_4507()))) {
                this.inWindowIndex = class_3532.method_15340((int)((int)((double)this.inWindowIndex - amount)), (int)0, (int)Math.max(this.suggestions.size() - MacroCMDSuggestor.this.maxSuggestionSize, 0));
                return true;
            }
            return false;
        }

        public boolean keyPressed(class_11908 input) {
            if (input.method_74234()) {
                this.scroll(-1);
                this.completed = false;
                return true;
            }
            if (input.method_74235()) {
                this.scroll(1);
                this.completed = false;
                return true;
            }
            if (input.method_74236()) {
                if (this.completed) {
                    this.scroll(input.method_74239() ? -1 : 1);
                }
                this.complete();
                return true;
            }
            if (input.method_74231()) {
                MacroCMDSuggestor.this.clearWindow();
                MacroCMDSuggestor.this.textField.method_1887((String)null);
                return true;
            }
            return false;
        }

        public void scroll(int offset) {
            this.select(this.selection + offset);
            int i = this.inWindowIndex;
            int j = this.inWindowIndex + MacroCMDSuggestor.this.maxSuggestionSize - 1;
            if (this.selection < i) {
                this.inWindowIndex = class_3532.method_15340((int)this.selection, (int)0, (int)Math.max(this.suggestions.size() - MacroCMDSuggestor.this.maxSuggestionSize, 0));
            } else if (this.selection > j) {
                this.inWindowIndex = class_3532.method_15340((int)(this.selection + MacroCMDSuggestor.this.inWindowIndexOffset - MacroCMDSuggestor.this.maxSuggestionSize), (int)0, (int)Math.max(this.suggestions.size() - MacroCMDSuggestor.this.maxSuggestionSize, 0));
            }
        }

        public void select(int index) {
            this.selection = index;
            if (this.selection < 0) {
                this.selection += this.suggestions.size();
            }
            if (this.selection >= this.suggestions.size()) {
                this.selection -= this.suggestions.size();
            }
            Suggestion suggestion = this.suggestions.get(this.selection);
            if (this.lastNarrationIndex != this.selection) {
                MacroCMDSuggestor.this.client.method_44713().method_70816(this.getNarration());
            }
        }

        public void complete() {
            Suggestion suggestion = this.suggestions.get(this.selection);
            MacroCMDSuggestor.this.completingSuggestions = true;
            MacroCMDSuggestor.this.textField.method_1852(suggestion.apply(this.typedText));
            int i = suggestion.getRange().getStart() + suggestion.getText().length();
            MacroCMDSuggestor.this.textField.method_1875(i);
            MacroCMDSuggestor.this.textField.method_1884(i);
            this.select(this.selection);
            MacroCMDSuggestor.this.completingSuggestions = false;
            this.completed = true;
        }

        class_2561 getNarration() {
            this.lastNarrationIndex = this.selection;
            Suggestion suggestion = this.suggestions.get(this.selection);
            Message message = suggestion.getTooltip();
            if (message != null) {
                return class_2561.method_43469((String)"narration.suggestion.tooltip", (Object[])new Object[]{this.selection + 1, this.suggestions.size(), suggestion.getText(), class_2561.method_30163((String)message.getString())});
            }
            return class_2561.method_43469((String)"narration.suggestion", (Object[])new Object[]{this.selection + 1, this.suggestions.size(), suggestion.getText()});
        }
    }
}

