/*
 * Decompiled with CFR 0.152.
 */
package com.thomas7520.macrokeybinds.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.thomas7520.macrokeybinds.object.DelayedMacro;
import com.thomas7520.macrokeybinds.object.IMacro;
import com.thomas7520.macrokeybinds.object.MacroType;
import com.thomas7520.macrokeybinds.object.RepeatMacro;
import com.thomas7520.macrokeybinds.object.SimpleMacro;
import com.thomas7520.macrokeybinds.object.ToggleMacro;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

public class MacroFlow {
    public static IMacro getMacroFromFile(File file) throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        FileInputStream fileInputStream = new FileInputStream(file);
        InputStreamReader reader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
        JsonObject object = (JsonObject)new GsonBuilder().create().fromJson((Reader)new BufferedReader(new FileReader(file)), JsonObject.class);
        IMacro macro = switch (MacroType.valueOf(object.get("macroType").getAsString())) {
            case MacroType.SIMPLE -> (IMacro)gson.fromJson((Reader)reader, SimpleMacro.class);
            case MacroType.TOGGLE -> (IMacro)gson.fromJson((Reader)reader, ToggleMacro.class);
            case MacroType.REPEAT -> (IMacro)gson.fromJson((Reader)reader, RepeatMacro.class);
            case MacroType.DELAYED -> (IMacro)gson.fromJson((Reader)reader, DelayedMacro.class);
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)MacroType.valueOf(object.get("type").getAsString())));
        };
        ((Reader)reader).close();
        return macro;
    }

    public static void writeMacro(IMacro macro, String path) {
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            File macroFile = new File(path + "/" + macro.getUUID().toString() + ".json");
            macroFile.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(macroFile);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);
            gson.toJson((Object)macro, (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

