/*
 * Decompiled with CFR 0.152.
 */
package com.thomas7520.macrokeybinds.util;

import com.thomas7520.macrokeybinds.MacroMod;
import com.thomas7520.macrokeybinds.object.IMacro;
import com.thomas7520.macrokeybinds.object.MacroModifier;
import com.thomas7520.macrokeybinds.util.MacroFlow;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_304;

public class MacroUtil {
    private static final HashMap<UUID, IMacro> keybinds = new HashMap();
    private static final HashMap<UUID, IMacro> serverKeybinds = new HashMap();
    private static String serverIP = "";
    public static class_304 guiBinding;

    public static void initServerMacros(String ip) {
        serverIP = ip;
        try {
            File directory = new File(String.valueOf(FabricLoader.getInstance().getGameDir().resolve(FabricLoader.getInstance().getConfigDir())) + "/servers-macros/" + serverIP + "/");
            if (directory.mkdirs() || directory.listFiles() == null) {
                return;
            }
            for (File file : directory.listFiles()) {
                IMacro macro = MacroFlow.getMacroFromFile(file);
                if (macro == null) {
                    MacroMod.LOGGER.error(String.format("Macro from %s is null !", file.getAbsolutePath()));
                    continue;
                }
                MacroUtil.getServerKeybinds().put(macro.getUUID(), macro);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static HashMap<UUID, IMacro> getGlobalKeybindsMap() {
        return keybinds;
    }

    public static HashMap<UUID, IMacro> getServerKeybinds() {
        return serverKeybinds;
    }

    public static String getServerIP() {
        return serverIP;
    }

    public static void setServerIP(String ip) {
        serverIP = ip;
    }

    public static boolean isNumeric(CharSequence cs) {
        if (cs.length() == 0 || cs.toString().equalsIgnoreCase("\b")) {
            return true;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(cs.charAt(i))) continue;
            return false;
        }
        return new BigInteger(cs.toString()).compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) < 0;
    }

    public static boolean isCombinationAssigned(IMacro macro) {
        boolean serverKeyAssigned = false;
        boolean globalKeyAssigned = false;
        for (IMacro value : MacroUtil.getServerKeybinds().values()) {
            if (macro.getUUID() == value.getUUID() || value.getKey() != macro.getKey() || value.getModifier() != macro.getModifier()) continue;
            serverKeyAssigned = true;
            break;
        }
        for (IMacro value : MacroUtil.getGlobalKeybindsMap().values()) {
            if (macro.getUUID() == value.getUUID() || value.getKey() != macro.getKey() || value.getModifier() != macro.getModifier()) continue;
            globalKeyAssigned = true;
            break;
        }
        return serverKeyAssigned || globalKeyAssigned;
    }

    public static boolean isCombinationAssigned(int key, MacroModifier modifier) {
        boolean serverKeyAssigned = false;
        boolean globalKeyAssigned = false;
        for (IMacro value : MacroUtil.getServerKeybinds().values()) {
            if (value.getKey() != key || value.getModifier() != modifier) continue;
            serverKeyAssigned = true;
            break;
        }
        for (IMacro value : MacroUtil.getGlobalKeybindsMap().values()) {
            if (value.getKey() != key || value.getModifier() != modifier) continue;
            globalKeyAssigned = true;
            break;
        }
        return serverKeyAssigned || globalKeyAssigned;
    }
}

