/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;

public class StackStateTracker<T> {
    private final ObjectList<T> storage = new ObjectArrayList();
    @Nullable
    private final ObjectList<Throwable> traces;
    private final ObjectList<Key> keys = new ObjectArrayList();

    public StackStateTracker(boolean saveStackTraceOnPush) {
        this.traces = saveStackTraceOnPush ? new ObjectArrayList() : null;
    }

    public void push(Key key, T state) {
        this.storage.add(state);
        this.keys.add((Object)key);
        if (this.traces != null) {
            this.traces.add((Object)new Throwable());
        }
    }

    public Key push(String hintText, T state) {
        Key key = new Key(hintText);
        this.push(key, state);
        return key;
    }

    public T pop(Key key) throws IllegalStateException {
        if (this.keys.isEmpty()) {
            throw new IllegalStateException("Tried to pop with key " + key + " on an empty stack!");
        }
        int index = this.keys.size() - 1;
        Key topKey = (Key)this.keys.get(index);
        if (topKey != key) {
            StringBuilder builder = new StringBuilder("Tried to pop with key ").append(key).append(" when stack had ").append(topKey).append(" on top!");
            this.addStackState(builder);
            IllegalStateException exc = new IllegalStateException(builder.toString());
            if (this.traces != null) {
                Throwable pushTrace = (Throwable)this.traces.get(index);
                exc.initCause(pushTrace);
            }
            throw exc;
        }
        this.keys.remove(index);
        if (this.traces != null) {
            this.traces.remove(index);
        }
        return (T)this.storage.remove(index);
    }

    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    public void addStackState(StringBuilder b) {
        b.append("\nStack contents (from top to bottom):\n");
        for (int i = this.keys.size() - 1; i >= 0; --i) {
            Key key = (Key)this.keys.get(i);
            b.append('\t').append(key.toString()).append('\n');
        }
    }

    public static final class Key {
        public final String hintName;

        public String toString() {
            return this.hintName;
        }

        @Generated
        public Key(String hintName) {
            this.hintName = hintName;
        }
    }
}

