/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong;

import com.ventooth.swansong.EnvInfo;
import com.ventooth.swansong.Share;
import com.ventooth.swansong.config.ModuleConfig;
import com.ventooth.swansong.debug.DebugCommandClient;
import com.ventooth.swansong.debug.DebugCommandServer;
import com.ventooth.swansong.image.ThreadedScreenshot;
import com.ventooth.swansong.resources.ShaderPackManager;
import com.ventooth.swansong.resources.pack.ModJarContainer;
import com.ventooth.swansong.shader.ShaderEngine;
import com.ventooth.swansong.shader.ShaderTypes;
import com.ventooth.swansong.zoom.FunkyZoom;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import org.lwjgl.input.Keyboard;

@Mod(modid="swansong", name="SwanSong", version="1.2.6", acceptedMinecraftVersions="[1.7.10]", guiFactory="com.ventooth.swansong.config.ConfigGuiFactory", dependencies="required-after:falsepatternlib@[1.9.0,);")
public final class SwanSong {
    @SidedProxy(clientSide="com.ventooth.swansong.SwanSong$ClientProxy", serverSide="com.ventooth.swansong.SwanSong$ServerProxy")
    public static Proxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent evt) {
        evt.registerServerCommand((ICommand)new DebugCommandServer());
    }

    @Generated
    public SwanSong() {
    }

    public static interface Proxy {
        default public void preInit(FMLPreInitializationEvent event) {
        }

        default public void init(FMLInitializationEvent event) {
        }

        default public void postInit(FMLPostInitializationEvent event) {
        }
    }

    public static final class ServerProxy
    implements Proxy {
        @Override
        public void preInit(FMLPreInitializationEvent event) {
            Share.log.warn("This mod does NOT belong in your DEDICATED SERVER! (but prolly wont crash idk..)");
        }

        @Generated
        public ServerProxy() {
        }
    }

    public static final class ClientProxy
    implements Proxy {
        @Override
        public void preInit(FMLPreInitializationEvent event) {
            ModJarContainer.init();
            EnvInfo.init();
            ShaderTypes.registerInternalFallbacks();
            MinecraftForge.EVENT_BUS.register((Object)this);
            FMLCommonHandler.instance().bus().register((Object)this);
            if (ModuleConfig.FastTextRender && Loader.isModLoaded((String)"smoothfont")) {
                Share.log.warn("The FastTestRender module is not compatible with SmoothFont (yet), and has been disabled!");
            }
        }

        @Override
        public void init(FMLInitializationEvent event) {
            ClientCommandHandler.instance.func_71560_a((ICommand)new DebugCommandClient());
        }

        @Override
        public void postInit(FMLPostInitializationEvent event) {
            ShaderPackManager.init();
            if (ModuleConfig.ThreadedScreenshots) {
                ThreadedScreenshot.init();
            }
            if (ModuleConfig.FunkyZoom) {
                if (Loader.isModLoaded((String)"zume")) {
                    Share.log.warn("No FunkyZoom allowed, you get zume instead...");
                } else {
                    FunkyZoom.init();
                }
            }
            ShaderTypes.validateRegistry();
            ShaderEngine.firstInit();
        }

        @SubscribeEvent
        public void onDebugGuiText(RenderGameOverlayEvent.Text text) {
            if (!Minecraft.func_71410_x().field_71474_y.field_74330_P) {
                return;
            }
            text.right.add("\u00a7bSwanSong \u00a791.2.6");
            if (!ShaderEngine.isInitialized()) {
                text.right.add("\u00a74Shaders disabled");
                return;
            }
            text.right.add("\u00a7bPack \u00a79" + ShaderPackManager.currentShaderPackName);
            text.right.add("\u00a7bShadows " + (ShaderEngine.shadowPassExists() ? "\u00a7aEnabled" : "\u00a74Disabled"));
            text.right.add("\u00a7bShader switches: \u00a7r" + ShaderEngine.prevFrameShaderSwitches);
        }

        @SubscribeEvent
        public void onDimensionChange(EntityJoinWorldEvent event) {
            if (event.world.field_72995_K && event.entity instanceof EntityPlayerSP) {
                ShaderEngine.scheduleShaderPackReload();
            }
        }

        @SubscribeEvent
        public void onKey(InputEvent.KeyInputEvent e) {
            if (Keyboard.getEventKey() == 19 && Keyboard.isKeyDown((int)61) && Keyboard.getEventKeyState() && !Keyboard.isRepeatEvent()) {
                ShaderEngine.scheduleShaderPackReload();
            }
        }

        @Generated
        public ClientProxy() {
        }
    }
}

