/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.config;

import com.falsepattern.lib.config.ConfigException;
import com.falsepattern.lib.config.ConfigurationManager;
import com.ventooth.swansong.Share;
import com.ventooth.swansong.config.CompatConfig;
import com.ventooth.swansong.config.DebugConfig;
import com.ventooth.swansong.config.ModuleConfig;
import com.ventooth.swansong.config.ShadersConfig;
import com.ventooth.swansong.config.ZoomConfig;
import cpw.mods.fml.client.config.DummyConfigElement;
import cpw.mods.fml.client.config.IConfigElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public final class Configs {
    public static void poke() {
    }

    private static void init() {
        ConfigurationManager.initialize((Class[])Configs.cfgClasses());
    }

    public static void syncConfigFile() {
        Share.log.debug("Syncing Configs");
        Class[] types = Configs.cfgClasses();
        try {
            ConfigurationManager.saveToFile((boolean)true, (Class[])types);
        }
        catch (ConfigException e) {
            Share.log.error("Failed to save config to file:", (Throwable)e);
        }
        try {
            ConfigurationManager.loadFromFile((Class[])types);
        }
        catch (ConfigException e) {
            Share.log.error("Failed to reload config from file:", (Throwable)e);
        }
        Share.log.debug("Synced Configs");
    }

    static Class<?>[] cfgClasses() {
        List<CfgCategory> categories = Configs.cfgCategories(true);
        ArrayList types = new ArrayList();
        for (CfgCategory category : categories) {
            types.add(category.type());
        }
        return types.toArray(new Class[0]);
    }

    static List<IConfigElement> cfgElements() throws ConfigException {
        List<CfgCategory> categories = Configs.cfgCategories(false);
        ArrayList<IConfigElement> elements = new ArrayList<IConfigElement>();
        for (CfgCategory category : categories) {
            elements.add(category.asElement());
        }
        return elements;
    }

    static List<CfgCategory> cfgCategories(boolean init) {
        ArrayList<CfgCategory> categories = new ArrayList<CfgCategory>();
        categories.add(new CfgCategory("00_modules", "config.swansong.modules.Modules", ModuleConfig.class));
        if (init || ModuleConfig.Debug) {
            categories.add(new CfgCategory("01_debug", "config.swansong.modules.Debug", DebugConfig.class));
        }
        categories.add(new CfgCategory("02_shaders", "config.swansong.modules.Shaders", ShadersConfig.class));
        categories.add(new CfgCategory("03_compat", "config.swansong.modules.Compat", CompatConfig.class));
        if (init || ModuleConfig.FunkyZoom) {
            categories.add(new CfgCategory("04_zoom", "config.swansong.modules.Zoom", ZoomConfig.class));
        }
        return categories;
    }

    @Generated
    private Configs() {
    }

    static {
        Configs.init();
    }

    static final class CfgCategory {
        private final String name;
        private final String lang;
        private final Class<?> type;

        CfgCategory(String name, String lang, Class<?> type) {
            this.name = name;
            this.lang = lang;
            this.type = type;
        }

        IConfigElement asElement() throws ConfigException {
            List innerElements = ConfigurationManager.getConfigElementsMulti((Class[])new Class[]{this.type});
            return new DummyConfigElement.DummyCategoryElement(this.name, this.lang, innerElements);
        }

        public String name() {
            return this.name;
        }

        public String lang() {
            return this.lang;
        }

        public Class<?> type() {
            return this.type;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            CfgCategory that = (CfgCategory)obj;
            return Objects.equals(this.name, that.name) && Objects.equals(this.lang, that.lang) && Objects.equals(this.type, that.type);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.lang, this.type);
        }

        public String toString() {
            return "CfgCategory[name=" + this.name + ", lang=" + this.lang + ", type=" + this.type + ']';
        }
    }
}

