/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.gui;

import com.ventooth.swansong.config.ShadersConfig;
import com.ventooth.swansong.gui.Translatable;
import com.ventooth.swansong.resources.ShaderPackManager;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.Locale;

public abstract class GuiButtonShaders
extends GuiButton {
    protected final Locale locale;

    public GuiButtonShaders(int id, int posX, int posY, int stepY, int width, int height, Translatable lang, Locale locale) {
        super(id, posX, posY + stepY * id, width, height, lang.format(locale, new Object[0]));
        this.locale = locale;
    }

    public abstract void onClick();

    public void update() {
    }

    public static void addButtons(List<GuiButton> buttonList, int posX, int posY, int stepY, int width, int height, Locale locale) {
        buttonList.add(new AntiAliasing(posX, posY, stepY, width, height, locale));
        buttonList.add(new NormalMapping(posX, posY, stepY, width, height, locale));
        buttonList.add(new SpecularMapping(posX, posY, stepY, width, height, locale));
        buttonList.add(new RenderQuality(posX, posY, stepY, width, height, locale));
        buttonList.add(new ShadowQuality(posX, posY, stepY, width, height, locale));
        buttonList.add(new HandDepth(posX, posY, stepY, width, height, locale));
        buttonList.add(new OldHandLight(posX, posY, stepY, width, height, locale));
        buttonList.add(new OldHandDepth(posX, posY, stepY, width, height, locale));
    }

    private static <T extends Enum<T>> T nextValue(T[] values, T current) {
        return values[(current.ordinal() + 1) % values.length];
    }

    public static final class AntiAliasing
    extends GuiButtonShaders {
        public static int ID = 0;

        private AntiAliasing(int posX, int posY, int stepY, int width, int height, Locale locale) {
            super(ID, posX, posY, stepY, width, height, ShadersConfig.AntiAliasing, locale);
        }

        @Override
        public void onClick() {
            ShadersConfig.AntiAliasing = (ShadersConfig.AntiAliasingCfg)GuiButtonShaders.nextValue((Enum[])ShadersConfig.AntiAliasingCfg.values(), (Enum)ShadersConfig.AntiAliasing);
            this.field_146126_j = ShadersConfig.AntiAliasing.format(this.locale, new Object[0]);
            ShaderPackManager.saveShaderSettings();
        }
    }

    public static final class NormalMapping
    extends GuiButtonShaders {
        public static int ID = 1;

        private NormalMapping(int posX, int posY, int stepY, int width, int height, Locale locale) {
            super(ID, posX, posY, stepY, width, height, ShadersConfig.NormalMapping, locale);
        }

        @Override
        public void onClick() {
            ShadersConfig.NormalMapping = (ShadersConfig.NormalMappingCfg)GuiButtonShaders.nextValue((Enum[])ShadersConfig.NormalMappingCfg.values(), (Enum)ShadersConfig.NormalMapping);
            this.field_146126_j = ShadersConfig.NormalMapping.format(this.locale, new Object[0]);
            ShaderPackManager.saveShaderSettings();
            Minecraft.func_71410_x().func_110436_a();
        }
    }

    public static final class SpecularMapping
    extends GuiButtonShaders {
        public static int ID = 2;

        private SpecularMapping(int posX, int posY, int stepY, int width, int height, Locale locale) {
            super(ID, posX, posY, stepY, width, height, ShadersConfig.SpecularMapping, locale);
        }

        @Override
        public void onClick() {
            ShadersConfig.SpecularMapping = (ShadersConfig.SpecularMappingCfg)GuiButtonShaders.nextValue((Enum[])ShadersConfig.SpecularMappingCfg.values(), (Enum)ShadersConfig.SpecularMapping);
            this.field_146126_j = ShadersConfig.SpecularMapping.format(this.locale, new Object[0]);
            ShaderPackManager.saveShaderSettings();
            Minecraft.func_71410_x().func_110436_a();
        }
    }

    public static final class RenderQuality
    extends GuiButtonShaders {
        public static int ID = 3;

        private RenderQuality(int posX, int posY, int stepY, int width, int height, Locale locale) {
            super(ID, posX, posY, stepY, width, height, ShadersConfig.RenderQuality, locale);
        }

        @Override
        public void onClick() {
            ShadersConfig.RenderQuality = (ShadersConfig.RenderQualityCfg)GuiButtonShaders.nextValue((Enum[])ShadersConfig.RenderQualityCfg.values(), (Enum)ShadersConfig.RenderQuality);
            this.field_146126_j = ShadersConfig.RenderQuality.format(this.locale, new Object[0]);
            ShaderPackManager.saveShaderSettings();
        }
    }

    public static final class ShadowQuality
    extends GuiButtonShaders {
        public static int ID = 4;

        private ShadowQuality(int posX, int posY, int stepY, int width, int height, Locale locale) {
            super(ID, posX, posY, stepY, width, height, ShadersConfig.ShadowQuality, locale);
        }

        @Override
        public void onClick() {
            ShadersConfig.ShadowQuality = (ShadersConfig.ShadowQualityCfg)GuiButtonShaders.nextValue((Enum[])ShadersConfig.ShadowQualityCfg.values(), (Enum)ShadersConfig.ShadowQuality);
            this.field_146126_j = ShadersConfig.ShadowQuality.format(this.locale, new Object[0]);
            ShaderPackManager.saveShaderSettings();
        }
    }

    public static final class HandDepth
    extends GuiButtonShaders {
        public static int ID = 5;

        private HandDepth(int posX, int posY, int stepY, int width, int height, Locale locale) {
            super(ID, posX, posY, stepY, width, height, ShadersConfig.HandDepth, locale);
        }

        @Override
        public void onClick() {
            ShadersConfig.HandDepth = (ShadersConfig.HandDepthCfg)GuiButtonShaders.nextValue((Enum[])ShadersConfig.HandDepthCfg.values(), (Enum)ShadersConfig.HandDepth);
            this.field_146126_j = ShadersConfig.HandDepth.format(this.locale, new Object[0]);
            ShaderPackManager.saveShaderSettings();
        }
    }

    public static final class OldHandLight
    extends GuiButtonShaders {
        public static int ID = 6;

        private OldHandLight(int posX, int posY, int stepY, int width, int height, Locale locale) {
            super(ID, posX, posY, stepY, width, height, ShadersConfig.OldHandLight, locale);
        }

        @Override
        public void onClick() {
            ShadersConfig.OldHandLight = (ShadersConfig.OldHandLightCfg)GuiButtonShaders.nextValue((Enum[])ShadersConfig.OldHandLightCfg.values(), (Enum)ShadersConfig.OldHandLight);
            this.field_146126_j = ShadersConfig.OldHandLight.format(this.locale, new Object[0]);
            ShaderPackManager.saveShaderSettings();
        }
    }

    public static final class OldHandDepth
    extends GuiButtonShaders {
        public static int ID = 7;

        private OldHandDepth(int posX, int posY, int stepY, int width, int height, Locale locale) {
            super(ID, posX, posY, stepY, width, height, ShadersConfig.OldHandDepth, locale);
        }

        @Override
        public void onClick() {
            ShadersConfig.OldHandDepth = (ShadersConfig.OldHandDepthCfg)GuiButtonShaders.nextValue((Enum[])ShadersConfig.OldHandDepthCfg.values(), (Enum)ShadersConfig.OldHandDepth);
            this.field_146126_j = ShadersConfig.OldHandDepth.format(this.locale, new Object[0]);
            ShaderPackManager.saveShaderSettings();
        }
    }
}

