/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.gui;

import com.ventooth.swansong.gui.GuiButtonShaders;
import com.ventooth.swansong.gui.GuiShaderOptions;
import com.ventooth.swansong.resources.ShaderPackManager;
import com.ventooth.swansong.shader.ShaderEngine;
import com.ventooth.swansong.shader.config.ConfigEntry;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;
import org.lwjgl.opengl.GL11;

public final class GuiShaders
extends GuiScreen {
    private static final int BUTTON_ID_BROWSE = 201;
    private static final int BUTTON_ID_EXIT = 202;
    private static final int BUTTON_ID_OPTIONS = 203;
    private final GuiScreen parentGui;
    private final String screenTitle;
    private int updateTimer = -1;
    private GuiSlotShaders slots;
    private GuiButton optionsButton;
    @Nullable
    static ConfigEntry.RootScreen configScreen;

    public GuiShaders(GuiScreen parentGui) {
        this.parentGui = parentGui;
        this.screenTitle = I18n.func_135052_a((String)"gui.swansong.shaders.title", (Object[])new Object[0]);
    }

    public void func_73866_w_() {
        int btnWidth = 120;
        int btnHeight = 20;
        int btnX = this.field_146294_l - 120 - 10;
        int baseY = 30;
        int stepY = 20;
        int shaderListWidth = this.field_146294_l - 120 - 20;
        this.slots = new GuiSlotShaders(shaderListWidth, this.field_146295_m, 30, this.field_146295_m - 50, 16);
        GuiButtonShaders.addButtons(this.field_146292_n, btnX, 30, 20, 120, 20, ShaderEngine.locale());
        int btnFolderWidth = Math.min(150, shaderListWidth / 2 - 10);
        this.field_146292_n.add(new GuiButton(201, shaderListWidth / 4 - btnFolderWidth / 2, this.field_146295_m - 25, btnFolderWidth, 20, I18n.func_135052_a((String)"gui.swansong.shaders.browse", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(202, shaderListWidth / 4 * 3 - btnFolderWidth / 2, this.field_146295_m - 25, btnFolderWidth, 20, I18n.func_135052_a((String)"gui.swansong.shaders.exit", (Object[])new Object[0])));
        configScreen = ShaderEngine.configScreen();
        this.optionsButton = new GuiButton(203, btnX, this.field_146295_m - 25, 120, 20, I18n.func_135052_a((String)"gui.swansong.shaders.options", (Object[])new Object[0]));
        this.optionsButton.field_146124_l = configScreen != null;
        this.field_146292_n.add(this.optionsButton);
        this.updateButtons();
    }

    protected void func_146284_a(GuiButton button) {
        if (!button.field_146124_l) {
            return;
        }
        if (button instanceof GuiButtonShaders) {
            GuiButtonShaders cfgButton = (GuiButtonShaders)button;
            cfgButton.onClick();
            return;
        }
        switch (button.field_146127_k) {
            case 201: {
                ShaderPackManager.openShaderPacksDir();
                break;
            }
            case 202: {
                this.field_146297_k.func_147108_a(this.parentGui);
                break;
            }
            case 203: {
                if (configScreen == null) break;
                this.field_146297_k.func_147108_a((GuiScreen)new GuiShaderOptions(this, configScreen));
                break;
            }
            default: {
                this.slots.func_148147_a(button);
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.slots.func_148128_a(mouseX, mouseY, partialTicks);
        this.drawCenteredString(this.screenTitle, this.field_146294_l / 2, 15, 0xFFFFFF);
        String version = GL11.glGetString((int)7938);
        String vendor = GL11.glGetString((int)7936);
        String renderer = GL11.glGetString((int)7937);
        String info = "OpenGL: " + version + ", " + vendor + ", " + renderer;
        int infoWidth = this.field_146289_q.func_78256_a(info);
        if (infoWidth < this.field_146294_l - 5) {
            this.drawCenteredString(info, this.field_146294_l / 2, this.field_146295_m - 40, 0x808080);
        } else {
            this.drawString(info, 5, this.field_146295_m - 40, 0x808080);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_73876_c() {
        configScreen = ShaderEngine.configScreen();
        this.optionsButton.field_146124_l = configScreen != null;
        --this.updateTimer;
        if (this.updateTimer <= 0) {
            this.slots.updateList();
            this.updateTimer += 20;
        }
    }

    public void updateButtons() {
        for (GuiButton guiButton : this.field_146292_n) {
            if (!(guiButton instanceof GuiButtonShaders)) continue;
            GuiButtonShaders cfgButton = (GuiButtonShaders)guiButton;
            cfgButton.update();
        }
    }

    private void drawCenteredString(String text, int posX, int posY, int color) {
        this.func_73732_a(this.field_146289_q, text, posX, posY, color);
    }

    private void drawString(String text, int posX, int posY, int color) {
        this.func_73731_b(this.field_146289_q, text, posX, posY, color);
    }

    public final class GuiSlotShaders
    extends GuiSlot {
        private @UnmodifiableView List<String> shaderPackNames;
        private int selectedIndex;

        public GuiSlotShaders(int width, int height, int top, int bottom, int slotHeight) {
            super(GuiShaders.this.field_146297_k, width, height, top, bottom, slotHeight);
            this.updateList();
            int posYSelected = this.selectedIndex * slotHeight;
            int wMid = (bottom - top) / 2;
            if (posYSelected > wMid) {
                this.func_148145_f(posYSelected - wMid);
            }
            this.func_148134_d(7, 8);
        }

        public int func_148139_c() {
            return this.field_148155_a - 20;
        }

        public void updateList() {
            ShaderPackManager.refreshShaderPackNames();
            this.shaderPackNames = ShaderPackManager.getShaderPackNames();
            this.selectedIndex = 0;
            String currentName = ShaderPackManager.getCurrentShaderPackName();
            int size = this.shaderPackNames.size();
            for (int i = 0; i < size; ++i) {
                if (!Objects.equals(this.shaderPackNames.get(i), currentName)) continue;
                this.selectedIndex = i;
                break;
            }
        }

        protected int func_148127_b() {
            return this.shaderPackNames.size();
        }

        protected void func_148144_a(int index, boolean doubleClicked, int mouseX, int mouseY) {
            if (index == this.selectedIndex) {
                return;
            }
            this.selectedIndex = index;
            ShaderPackManager.setShaderPackByName(this.shaderPackNames.get(index));
            GuiShaders.this.updateButtons();
        }

        protected boolean func_148131_a(int index) {
            return index == this.selectedIndex;
        }

        protected int func_148137_d() {
            return this.field_148155_a - 6;
        }

        protected int func_148138_e() {
            return this.func_148127_b() * 18;
        }

        protected void func_148123_a() {
        }

        protected void drawContainerBackground(Tessellator tessellator) {
        }

        protected void func_148126_a(int index, int posX, int posY, int contentY, Tessellator tess, int mouseX, int mouseY) {
            int color;
            String label = this.shaderPackNames.get(index);
            if (label.equals("(disabled)")) {
                label = I18n.func_135052_a((String)"options.off", (Object[])new Object[0]);
                color = 0xE04040;
            } else if (label.equals("(default)")) {
                label = I18n.func_135052_a((String)"gui.swansong.shaders.default", (Object[])new Object[0]);
                color = 0xA0A0A0;
            } else {
                color = 0xE0E0E0;
            }
            GuiShaders.this.drawCenteredString(label, this.field_148155_a / 2, posY + 1, color);
        }
    }
}

