/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.gui;

import com.ventooth.swansong.gui.Colors;
import it.unimi.dsi.fastutil.objects.ObjectList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;

public class TooltipRenderer {
    private static final int delay = 700;
    private int prevX = 0;
    private int prevY = 0;
    private long prevMouseMove = 0L;

    public void drawTooltip(GuiScreen screen, int x, int y, ObjectList<String> lines) {
        if (Math.abs(x - this.prevX) > 5 || Math.abs(y - this.prevY) > 5) {
            this.prevX = x;
            this.prevY = y;
            this.prevMouseMove = System.currentTimeMillis();
            return;
        }
        if (lines == null || lines.isEmpty()) {
            return;
        }
        if (System.currentTimeMillis() - this.prevMouseMove < 700L) {
            return;
        }
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int width = 0;
        int height = 0;
        for (String line : lines) {
            width = Math.max(width, fr.func_78256_a(line));
            height += 11;
        }
        int rectX = x + 2;
        int rectY = y + 2;
        int rectW = width + 10;
        int rectH = height + 10;
        rectX = Math.min(rectX, screen.field_146294_l - rectW);
        rectY = Math.min(rectY, screen.field_146295_m - rectH);
        this.drawRectBorder(rectX, rectY, rectX + rectW, rectY + rectH, Colors.COLOR_RECT_BORDER);
        Gui.func_73734_a((int)rectX, (int)rectY, (int)(rectX + rectW), (int)(rectY + rectH), (int)Colors.COLOR_RECT_FILL);
        int offsetY = 5;
        for (String line : lines) {
            int color = Colors.COLOR_DEFAULT_RGB;
            if (line.endsWith("!")) {
                color = Colors.COLOR_RED_RGB;
            }
            fr.func_78261_a(line, rectX + 5, rectY + offsetY, color);
            offsetY += 11;
        }
    }

    private void drawRectBorder(int x1, int y1, int x2, int y2, int col) {
        Gui.func_73734_a((int)x1, (int)(y1 - 1), (int)x2, (int)y1, (int)col);
        Gui.func_73734_a((int)x1, (int)y2, (int)x2, (int)(y2 + 1), (int)col);
        Gui.func_73734_a((int)(x1 - 1), (int)y1, (int)x1, (int)y2, (int)col);
        Gui.func_73734_a((int)x2, (int)y1, (int)(x2 + 1), (int)y2, (int)col);
    }
}

