/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.mathparser;

import com.ventooth.swansong.mathparser.TokenType;
import java.util.Objects;

public final class Token {
    private final int offset;
    private final TokenType type;
    private final String text;

    public Token(int offset, TokenType type, String text) {
        this.offset = offset;
        this.type = type;
        this.text = text;
    }

    public int until() {
        return this.offset + this.text.length();
    }

    public int offset() {
        return this.offset;
    }

    public TokenType type() {
        return this.type;
    }

    public String text() {
        return this.text;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Token that = (Token)obj;
        return this.offset == that.offset && Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.text, that.text);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.offset, this.type, this.text});
    }

    public String toString() {
        return "Token[offset=" + this.offset + ", type=" + (Object)((Object)this.type) + ", text=" + this.text + ']';
    }
}

