/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.mixin.mixins.client.compat.thaumcraft;

import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.ventooth.swansong.api.ShaderStateInfo;
import com.ventooth.swansong.shader.ShaderEngine;
import com.ventooth.swansong.shader.ShaderState;
import com.ventooth.swansong.shader.StateGraph;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import thaumcraft.client.renderers.tile.TileEldritchObeliskRenderer;

@Mixin(value={TileEldritchObeliskRenderer.class})
public abstract class TileEldritchObeliskRendererMixin {
    @Shadow(remap=false)
    private boolean inrange;

    @Inject(method={"renderTileEntityAt"}, at={@At(value="INVOKE", target="Lorg/lwjgl/opengl/GL11;glPushMatrix()V", ordinal=0, remap=false)}, require=1)
    private void prePortals(TileEntity te, double x, double y, double z, float f, CallbackInfo ci, @Share(value="portal_pass") LocalBooleanRef portalPass) {
        portalPass.set(false);
        if (!this.inrange) {
            return;
        }
        if (ShaderEngine.graph.isManaged()) {
            if (ShaderStateInfo.shadowPassActive()) {
                this.inrange = false;
                return;
            }
            GL11.glDisable((int)2896);
            if (!ShaderEngine.hasPortalShader()) {
                this.inrange = false;
            }
            ShaderEngine.graph.push(StateGraph.Stack.Portal);
            ShaderState.pushBlockEntity();
            ShaderState.portal();
            ShaderState.updatePortalEyeState(false, false, false, true);
            portalPass.set(true);
        }
    }

    @Inject(method={"renderTileEntityAt"}, at={@At(value="INVOKE", target="Lorg/lwjgl/opengl/GL11;glPopMatrix()V", ordinal=0, remap=false)}, require=1)
    private void postPortals(TileEntity te, double x, double y, double z, float f, CallbackInfo ci, @Share(value="portal_pass") LocalBooleanRef portalPass) {
        if (portalPass.get()) {
            GL11.glEnable((int)2896);
            ShaderState.nextBlockEntity(te);
            ShaderState.popBlockEntity();
            ShaderEngine.graph.pop(StateGraph.Stack.Portal);
        }
    }
}

