/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.resources.pack;

import com.ventooth.swansong.Share;
import com.ventooth.swansong.resources.pack.ModJarContainer;
import com.ventooth.swansong.resources.pack.ShaderPack;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import net.minecraft.world.WorldProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InternalShaderPack
extends ShaderPack {
    public static final String NAME = "(internal)";
    public static final InternalShaderPack INSTANCE = new InternalShaderPack();

    private InternalShaderPack() {
        super(NAME);
    }

    @Override
    @NotNull
    public InputStream get(String path) throws IOException {
        path = InternalShaderPack.fixPath(path);
        Share.log.trace("Reading shader from fallback path: {}", new Object[]{path});
        ZipEntry entry = ModJarContainer.getEntry(path);
        if (entry == null) {
            throw new FileNotFoundException("path=" + path);
        }
        InputStream is = ModJarContainer.getInputStream(entry);
        Share.log.trace("Yeah, the InputStream does exist for: {}", new Object[]{path});
        return is;
    }

    @Override
    public boolean has(String path) {
        return ModJarContainer.getEntry(InternalShaderPack.fixPath(path)) != null;
    }

    private static String fixPath(String path) {
        return "assets/swansong" + path;
    }

    @Override
    @Nullable
    public String getWorldSpecialization(@Nullable WorldProvider dimension) {
        return null;
    }
}

