/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.resources.pack;

import com.ventooth.swansong.resources.pack.ShaderPack;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import lombok.Generated;
import net.minecraft.world.WorldProvider;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolvedShaderPack
extends ShaderPack {
    private final byte[] storage;
    private final Object2LongMap<String> offsets;
    private final List<WorldSpecializationPredicate> specializations;
    private final boolean hasWorld0;

    public ResolvedShaderPack(String name, byte[] storage, Object2LongMap<String> offsets, List<WorldSpecializationPredicate> specializations, boolean hasWorld0) {
        super(name);
        this.storage = storage;
        this.offsets = offsets;
        this.specializations = specializations;
        this.hasWorld0 = hasWorld0;
    }

    @Override
    @NotNull
    public InputStream get(String path) throws IOException {
        long region = this.offsets.getOrDefault((Object)path, -1L);
        if (region == -1L) {
            throw new FileNotFoundException(path);
        }
        int offset = (int)(region >>> 32 & 0xFFFFFFFFL);
        int length = (int)(region & 0xFFFFFFFFL);
        return new ByteArrayInputStream(this.storage, offset, length);
    }

    @Override
    public boolean has(String path) {
        return this.offsets.containsKey((Object)path);
    }

    @Override
    @Nullable
    public String getWorldSpecialization(@Nullable WorldProvider dimension) {
        if (dimension != null) {
            for (WorldSpecializationPredicate specialization : this.specializations) {
                if (!specialization.matches(dimension)) continue;
                return specialization.dirName();
            }
        }
        if (this.hasWorld0) {
            return "world0";
        }
        return null;
    }

    public static interface WorldSpecializationPredicate {
        public boolean matches(@NotNull WorldProvider var1);

        public String dirName();

        public static class All
        implements WorldSpecializationPredicate {
            private final String dirName;

            @Override
            public boolean matches(@NotNull WorldProvider dimension) {
                return true;
            }

            @Generated
            public All(String dirName) {
                this.dirName = dirName;
            }

            @Override
            @Generated
            public String dirName() {
                return this.dirName;
            }
        }

        public static class ByName
        implements WorldSpecializationPredicate {
            private final String dimName;
            private final String dirName;

            @Override
            public boolean matches(@NotNull WorldProvider dimension) {
                return this.dimName.equals(dimension.func_80007_l());
            }

            @Generated
            public ByName(String dimName, String dirName) {
                this.dimName = dimName;
                this.dirName = dirName;
            }

            @Override
            @Generated
            public String dirName() {
                return this.dirName;
            }
        }

        public static class ByClass
        implements WorldSpecializationPredicate {
            private final String className;
            private final String dirName;

            @Override
            public boolean matches(@NotNull WorldProvider dimension) {
                return this.matchesClass(dimension.getClass());
            }

            private boolean matchesClass(Class<?> klass) {
                Class<?>[] itfs;
                if (this.className.equals(klass.getName())) {
                    return true;
                }
                Class<?> sup = klass.getSuperclass();
                if (sup != null && this.matchesClass(sup)) {
                    return true;
                }
                for (Class<?> itf : itfs = klass.getInterfaces()) {
                    if (!this.matchesClass(itf)) continue;
                    return true;
                }
                return false;
            }

            @Generated
            public ByClass(String className, String dirName) {
                this.className = className;
                this.dirName = dirName;
            }

            @Override
            @Generated
            public String dirName() {
                return this.dirName;
            }
        }

        public static class ByID
        implements WorldSpecializationPredicate {
            private final int id;
            private final String dirName;

            @Override
            public boolean matches(@NotNull WorldProvider dimension) {
                return dimension.field_76574_g == this.id;
            }

            @Generated
            public ByID(int id, String dirName) {
                this.id = id;
                this.dirName = dirName;
            }

            @Override
            @Generated
            public String dirName() {
                return this.dirName;
            }
        }
    }

    static enum DimensionPropertiesVariant {
        Iris,
        Swansong;

    }

    public static class Builder {
        private final String name;
        private final ExposedByteArrayOutputStream out = new ExposedByteArrayOutputStream();
        private final Object2LongMap<String> offsets = new Object2LongOpenHashMap();
        private final ObjectList<WorldSpecializationPredicate> specializations = new ObjectArrayList();
        private final ObjectList<WorldSpecializationPredicate> specializationsIris = new ObjectArrayList();
        private final ObjectList<WorldSpecializationPredicate> specializationsSwansong = new ObjectArrayList();
        private boolean hasWorld0 = false;
        private final byte[] copyBuf = new byte[4096];

        public void addSpecialization(WorldSpecializationPredicate specialization) {
            this.specializations.add((Object)specialization);
        }

        public void hasWorld0() {
            this.hasWorld0 = true;
        }

        public void add(String path, InputStream data) throws IOException {
            int offset = this.out.size();
            int size = this.copyFrom(data);
            if ("shaders/dimensions.properties".equals(path)) {
                this.parseDimensionProperties(offset, size, DimensionPropertiesVariant.Iris);
            } else if ("shaders/dimensions_swansong.properties".equals(path)) {
                this.parseDimensionProperties(offset, size, DimensionPropertiesVariant.Swansong);
            }
            long packed = ((long)offset & 0xFFFFFFFFL) << 32 | (long)size & 0xFFFFFFFFL;
            if (path.charAt(0) != '/') {
                path = "/" + path;
            }
            this.offsets.put((Object)path, packed);
        }

        private void parseDimensionProperties(int offset, int size, DimensionPropertiesVariant variant) throws IOException {
            Properties properties = new Properties();
            ByteArrayInputStream in = new ByteArrayInputStream(this.out.buf(), offset, size);
            properties.load(in);
            block28: for (String name : properties.stringPropertyNames()) {
                String value;
                if (!name.startsWith("dimension.") || (value = properties.getProperty(name)) == null) continue;
                String dirName = name.substring("dimension.".length());
                switch (variant) {
                    case Iris: {
                        String[] namespaces;
                        String[] stringArray = namespaces = StringUtils.split((String)value, (char)' ');
                        int n = stringArray.length;
                        block29: for (int i = 0; i < n; ++i) {
                            String namespace;
                            switch (namespace = stringArray[i]) {
                                case "minecraft:the_overworld": {
                                    this.specializationsIris.add((Object)new WorldSpecializationPredicate.ByName("Overworld", dirName));
                                    continue block29;
                                }
                                case "minecraft:the_nether": {
                                    this.specializationsIris.add((Object)new WorldSpecializationPredicate.ByName("Nether", dirName));
                                    continue block29;
                                }
                                case "minecraft:the_end": {
                                    this.specializationsIris.add((Object)new WorldSpecializationPredicate.ByName("The End", dirName));
                                    continue block29;
                                }
                                case "*": {
                                    this.specializationsIris.add((Object)new WorldSpecializationPredicate.All(dirName));
                                }
                            }
                        }
                        continue block28;
                    }
                    case Swansong: {
                        String[] patterns;
                        block30: for (String pattern : patterns = StringUtils.split((String)value, (char)';')) {
                            String[] parts = StringUtils.split((String)pattern, (String)":", (int)2);
                            if (parts.length != 2) continue;
                            String type = parts[0].trim();
                            String subPattern = parts[1].trim();
                            if (subPattern.length() > 2 && subPattern.charAt(0) == '\"' && subPattern.charAt(subPattern.length() - 1) == '\"') {
                                subPattern = subPattern.substring(1, subPattern.length() - 1);
                            }
                            switch (type) {
                                case "id": {
                                    try {
                                        int dimID = Integer.parseInt(subPattern);
                                        this.specializationsSwansong.add((Object)new WorldSpecializationPredicate.ByID(dimID, dirName));
                                    }
                                    catch (NumberFormatException numberFormatException) {}
                                    continue block30;
                                }
                                case "class": {
                                    this.specializationsSwansong.add((Object)new WorldSpecializationPredicate.ByClass(subPattern, dirName));
                                    continue block30;
                                }
                                case "name": {
                                    this.specializationsSwansong.add((Object)new WorldSpecializationPredicate.ByName(subPattern, dirName));
                                }
                            }
                        }
                        break;
                    }
                }
            }
        }

        private int copyFrom(InputStream data) throws IOException {
            int read;
            int totalRead = 0;
            while ((read = data.read(this.copyBuf)) >= 0) {
                this.out.write(this.copyBuf, 0, read);
                totalRead += read;
            }
            return totalRead;
        }

        public ResolvedShaderPack build() {
            ObjectArrayList spec = new ObjectArrayList();
            spec.addAll(this.specializationsSwansong);
            spec.addAll(this.specializationsIris);
            spec.addAll(this.specializations);
            return new ResolvedShaderPack(this.name, this.out.toByteArray(), this.offsets, (List<WorldSpecializationPredicate>)spec, this.hasWorld0);
        }

        @Generated
        public Builder(String name) {
            this.name = name;
        }

        private static class ExposedByteArrayOutputStream
        extends ByteArrayOutputStream {
            private ExposedByteArrayOutputStream() {
            }

            public byte[] buf() {
                return this.buf;
            }
        }
    }
}

