/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader;

import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.util.AxisAlignedBB;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class ClippingHelperShadow
extends ClippingHelper {
    private float minCamX;
    private float minCamY;
    private float minCamZ;
    private float maxCamX;
    private float maxCamY;
    private float maxCamZ;
    private float minX;
    private float minY;
    private float minZ;
    private float maxX;
    private float maxY;
    private float maxZ;
    private boolean hasReceiver = false;
    private final Vector3f scratch = new Vector3f();
    public final Matrix4f shadowModelViewMatrix = new Matrix4f();

    public void begin() {
        this.minCamX = Float.POSITIVE_INFINITY;
        this.minCamY = Float.POSITIVE_INFINITY;
        this.minCamZ = Float.POSITIVE_INFINITY;
        this.maxCamX = Float.NEGATIVE_INFINITY;
        this.maxCamY = Float.NEGATIVE_INFINITY;
        this.maxCamZ = Float.NEGATIVE_INFINITY;
        this.minX = Float.POSITIVE_INFINITY;
        this.minY = Float.POSITIVE_INFINITY;
        this.minZ = Float.POSITIVE_INFINITY;
        this.maxX = Float.NEGATIVE_INFINITY;
        this.maxY = Float.NEGATIVE_INFINITY;
        this.maxZ = Float.NEGATIVE_INFINITY;
        this.hasReceiver = false;
    }

    public void addShadowReceiver(WorldRenderer wr) {
        this.addShadowReceiver(wr.field_78923_c, wr.field_78920_d, wr.field_78921_e, wr.field_78923_c + 16, wr.field_78920_d + 16, wr.field_78921_e + 16);
    }

    public void addShadowReceiver(AxisAlignedBB aabb) {
        this.addShadowReceiver((float)aabb.field_72340_a, (float)aabb.field_72338_b, (float)aabb.field_72339_c, (float)aabb.field_72336_d, (float)aabb.field_72337_e, (float)aabb.field_72334_f);
    }

    public void addShadowReceiver(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.hasReceiver = true;
        this.minX = Math.min(this.minX, minX);
        this.minY = Math.min(this.minY, minY);
        this.minZ = Math.min(this.minZ, minZ);
        this.maxX = Math.max(this.maxX, maxX);
        this.maxY = Math.max(this.maxY, maxY);
        this.maxZ = Math.max(this.maxZ, maxZ);
    }

    public void end() {
        this.minCamX = Float.POSITIVE_INFINITY;
        this.minCamY = Float.POSITIVE_INFINITY;
        this.minCamZ = Float.POSITIVE_INFINITY;
        this.maxCamX = Float.NEGATIVE_INFINITY;
        this.maxCamY = Float.NEGATIVE_INFINITY;
        this.maxCamZ = Float.NEGATIVE_INFINITY;
        if (!this.hasReceiver) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            float x = (i & 1) == 0 ? this.minX : this.maxX;
            float y = (i & 2) == 0 ? this.minY : this.maxY;
            float z = (i & 4) == 0 ? this.minZ : this.maxZ;
            this.shadowModelViewMatrix.transformPosition(x, y, z, this.scratch);
            x = this.scratch.x;
            y = this.scratch.y;
            z = this.scratch.z;
            this.minCamX = Math.min(this.minCamX, x);
            this.minCamY = Math.min(this.minCamY, y);
            this.minCamZ = Math.min(this.minCamZ, z);
            this.maxCamX = Math.max(this.maxCamX, x);
            this.maxCamY = Math.max(this.maxCamY, y);
            this.maxCamZ = Math.max(this.maxCamZ, z);
        }
        if (Float.isNaN(this.minCamX)) {
            this.minCamX = Float.NEGATIVE_INFINITY;
        }
        if (Float.isNaN(this.minCamY)) {
            this.minCamY = Float.NEGATIVE_INFINITY;
        }
        if (Float.isNaN(this.minCamZ)) {
            this.minCamZ = Float.NEGATIVE_INFINITY;
        }
        if (Float.isNaN(this.maxCamX)) {
            this.maxCamX = Float.POSITIVE_INFINITY;
        }
        if (Float.isNaN(this.maxCamY)) {
            this.maxCamY = Float.POSITIVE_INFINITY;
        }
        if (Float.isNaN(this.maxCamZ)) {
            this.maxCamZ = Float.POSITIVE_INFINITY;
        }
    }

    public boolean func_78553_b(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (!this.hasReceiver) {
            return false;
        }
        return this.isShadowVisible((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ);
    }

    private boolean isShadowVisible(float mX, float mY, float mZ, float MX, float MY, float MZ) {
        float minX = Float.POSITIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float minZ = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        float maxZ = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < 8; ++i) {
            float x = (i & 1) == 0 ? mX : MX;
            float y = (i & 2) == 0 ? mY : MY;
            float z = (i & 4) == 0 ? mZ : MZ;
            this.shadowModelViewMatrix.transformPosition(x, y, z, this.scratch);
            x = this.scratch.x;
            y = this.scratch.y;
            z = this.scratch.z;
            minX = Math.min(minX, x);
            minY = Math.min(minY, y);
            minZ = Math.min(minZ, z);
            maxX = Math.max(maxX, x);
            maxY = Math.max(maxY, y);
            maxZ = Math.max(maxZ, z);
        }
        return maxX > this.minCamX && minX < this.maxCamX && maxY > this.minCamY && minY < this.maxCamY && maxZ > this.minCamZ && minZ < this.maxCamZ;
    }
}

