/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader;

import com.falsepattern.lib.util.MathUtil;
import com.ventooth.swansong.config.ShadersConfig;
import com.ventooth.swansong.shader.MCRenderStage;
import com.ventooth.swansong.shader.ShaderEngine;
import com.ventooth.swansong.shader.loader.ShaderLoaderOutParams;
import it.unimi.dsi.fastutil.ints.AbstractIntList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.nio.DoubleBuffer;
import lombok.Generated;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.joml.Vector4d;
import org.joml.Vector4dc;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public final class ShaderState {
    private static final DoubleBuffer tempDoubleBuf = BufferUtils.createDoubleBuffer((int)16);
    private static final double LOG_HALF = Math.log(0.5);
    private static final Vector4dc sunPosModelView = new Vector4d(0.0, 100.0, 0.0, 0.0);
    private static final Vector4dc upPosModelView = new Vector4d(0.0, 100.0, 0.0, 0.0);
    private static final Vector4dc moonPosModelView = new Vector4d(0.0, -100.0, 0.0, 0.0);
    private static final Matrix4d tempMat4d = new Matrix4d();
    private static final Vector4d tempVec4d = new Vector4d();
    @Nullable
    private static Runnable uniformUpdateTask = null;
    private static float subTick = 0.0f;
    private static long currentTimeMs = 0L;
    private static long lastFrameTimeMs = 0L;
    private static long diffSystemTime = 0L;
    private static double frameTime = 0.0;
    private static double frameTimeCounter = 0.0;
    private static int worldTime = 0;
    private static int worldDay = 0;
    private static int moonPhase = 0;
    private static int frameCounter = 0;
    private static int isEyeInWater = 0;
    private static double rainStrength = 0.0;
    private static double wetness;
    private static double nightVision;
    private static double blindness;
    private static final Vector2i viewSize;
    private static final Vector2i eyeBrightness;
    private static final Vector2d eyeBrightnessD;
    private static final Vector2d eyeBrightnessSmooth;
    private static final Vector2i eyeBrightnessSmoothRound;
    private static final Vector2d eyeBrightnessSmoothRoundD;
    private static final Vector3d camPos;
    private static final Vector3d camPosFract;
    private static final Vector3i camPosInt;
    private static final Vector3d camPosIntD;
    private static final Vector3d prevCamPos;
    private static final Vector3d prevCamPosFract;
    private static final Vector3i prevCamPosInt;
    private static final Vector3d prevCamPosIntD;
    private static final Vector3d upPos;
    private static final Matrix4d projectionMat;
    private static final Matrix4d prevProjectionMat;
    private static final Matrix4d projectionMatInv;
    private static final Matrix4d modelViewMat;
    private static final Matrix4d prevModelViewMat;
    private static final Matrix4d modelViewMatInv;
    private static final Matrix4d shadowProjectionMat;
    private static final Matrix4d shadowProjectionMatInv;
    private static final Matrix4d shadowModelViewMat;
    private static final Matrix4d shadowModelViewMatInv;
    private static double celestialAngle;
    private static double sunAngle;
    private static double shadowAngle;
    private static boolean isShadowMoon;
    private static double sunPathRotation;
    private static final Vector3d sunPosition;
    private static final Vector3d moonPosition;
    private static final Vector3d shadowLightPosition;
    private static final boolean fogEnabled = false;
    private static int fogMode;
    private static final Vector3d fogColor;
    private static final Vector3d skyColor;
    private static final Vector4d entityColor;
    private static final boolean[] portalEye;
    private static final Vector2i atlasSize;
    @Nullable
    private static ItemStack heldItem;
    private static boolean isHeldItemTranslucent;
    private static int biome;
    private static double wetnessHalfLife;
    private static double drynessHalfLife;
    private static double eyeBrightnessHalfLife;
    private static double centerDepthHalfLife;
    private static double centerDepth;
    private static double centerDepthSmooth;
    private static boolean useOldBlockLight;
    private static int blockEntityId;
    private static AbstractIntList blockEntityIdStack;
    private static int entityId;
    private static int renderStage;
    private static AbstractIntList renderStageStack;

    public static void applyParams(ShaderLoaderOutParams params) {
        sunPathRotation = params.sunPathRotation;
        wetnessHalfLife = params.wetnessHalfLife;
        drynessHalfLife = params.drynessHalfLife;
        eyeBrightnessHalfLife = params.eyeBrightnessHalfLife;
        centerDepthHalfLife = params.centerDepthHalfLife;
        useOldBlockLight = params.oldLighting == null ? true : params.oldLighting;
    }

    public static double sunAngle() {
        return sunAngle;
    }

    public static double shadowAngle() {
        return shadowAngle;
    }

    public static int biome() {
        return biome;
    }

    public static float blockLightLevel(float old) {
        if (useOldBlockLight) {
            return old;
        }
        return 1.0f;
    }

    public static float blockAoLight() {
        return 0.2f;
    }

    public static Vector3dc shadowLightPosition() {
        return shadowLightPosition;
    }

    public static Vector3dc sunPosition() {
        return sunPosition;
    }

    public static Vector3dc moonPosition() {
        return moonPosition;
    }

    public static Matrix4dc shadowProjection() {
        return shadowProjectionMat;
    }

    public static Matrix4dc shadowProjectionInverse() {
        return shadowProjectionMatInv;
    }

    public static Matrix4dc shadowModelView() {
        return shadowModelViewMat;
    }

    public static Matrix4dc shadowModelViewInverse() {
        return shadowModelViewMatInv;
    }

    public static int isEyeInWater() {
        return isEyeInWater;
    }

    public static double rainStrength() {
        return rainStrength;
    }

    public static double wetness() {
        return wetness;
    }

    public static double nightVision() {
        return nightVision;
    }

    public static double blindness() {
        return blindness;
    }

    public static Vector2ic eyeBrightness() {
        return eyeBrightness;
    }

    public static Vector2ic eyeBrightnessSmooth() {
        return eyeBrightnessSmoothRound;
    }

    public static Vector2dc eyeBrightnessD() {
        return eyeBrightnessD;
    }

    public static Vector2dc eyeBrightnessSmoothD() {
        return eyeBrightnessSmoothRoundD;
    }

    public static int worldTime() {
        return worldTime;
    }

    public static int worldDay() {
        return worldDay;
    }

    public static int moonPhase() {
        return moonPhase;
    }

    public static int frameCounter() {
        return frameCounter;
    }

    public static Vector2ic viewSize() {
        return viewSize;
    }

    public static double viewWidth() {
        return ShaderState.viewSize.x;
    }

    public static double viewHeight() {
        return ShaderState.viewSize.y;
    }

    public static double aspectRatio() {
        return ShaderState.viewWidth() / ShaderState.viewHeight();
    }

    public static Vector3dc camPos() {
        return camPos;
    }

    public static Vector3dc camPosFract() {
        return camPosFract;
    }

    public static Vector3ic camPosInt() {
        return camPosInt;
    }

    public static Vector3dc camPosIntD() {
        return camPosIntD;
    }

    public static Vector3dc prevCamPos() {
        return prevCamPos;
    }

    public static Vector3dc prevCamPosFract() {
        return prevCamPosFract;
    }

    public static Vector3ic prevCamPosInt() {
        return prevCamPosInt;
    }

    public static Vector3dc prevCamPosIntD() {
        return prevCamPosIntD;
    }

    public static Vector3dc upPos() {
        return upPos;
    }

    public static double eyeAltitude() {
        return ShaderState.camPos.y;
    }

    public static Matrix4dc projectionMat() {
        return projectionMat;
    }

    public static Matrix4dc prevProjectionMat() {
        return prevProjectionMat;
    }

    public static Matrix4dc projectionMatInv() {
        return projectionMatInv;
    }

    public static Matrix4dc modelViewMat() {
        return modelViewMat;
    }

    public static Matrix4dc prevModelViewMat() {
        return prevModelViewMat;
    }

    public static Matrix4dc modelViewMatInv() {
        return modelViewMatInv;
    }

    public static int fogMode() {
        return 0;
    }

    public static Vector3dc fogColor() {
        return fogColor;
    }

    public static Vector3dc skyColor() {
        return skyColor;
    }

    public static Vector4dc entityColor() {
        return entityColor;
    }

    public static boolean[] portalEye() {
        return portalEye;
    }

    public static double nearPlane() {
        return 0.05;
    }

    public static double farPlane() {
        return ShaderState.mc().field_71474_y.field_151451_c * 16;
    }

    public static boolean isGuiHidden() {
        return ShaderState.mc().field_71474_y.field_74319_N;
    }

    public static double screenBrightness() {
        return ShaderState.mc().field_71474_y.field_74333_Y;
    }

    public static double frameTimeCounter() {
        return frameTimeCounter;
    }

    public static double frameTime() {
        return frameTime;
    }

    public static double centerDepthSmooth() {
        return centerDepthSmooth;
    }

    public static int blockEntityId() {
        return blockEntityId;
    }

    public static int entityId() {
        return entityId;
    }

    public static int renderStage() {
        return renderStage;
    }

    public static Vector2ic atlasSize() {
        return atlasSize;
    }

    public static void updateSubTick(float subTick) {
        ShaderState.subTick = subTick;
    }

    public static float getSubTick() {
        return subTick;
    }

    public static void updateAtlasSize(int width, int height) {
        if (ShaderState.atlasSize.x != width || ShaderState.atlasSize.y != height) {
            atlasSize.set(width, height);
            ShaderState.updateUniforms();
        }
    }

    public static void updateRenderStage(MCRenderStage stage) {
        int newStage = stage.value();
        if (newStage != renderStage) {
            renderStage = newStage;
            ShaderState.updateUniforms();
        }
    }

    public static void pushRenderStage() {
        if (renderStageStack.size() >= 32) {
            throw new IllegalStateException("Render stage stack overflow!");
        }
        renderStageStack.push(renderStage);
    }

    public static void popRenderStage() {
        if (renderStageStack.isEmpty()) {
            throw new IllegalStateException("Tried to pop empty render stage stack!");
        }
        int newStage = renderStageStack.popInt();
        if (newStage != renderStage) {
            renderStage = newStage;
            ShaderState.updateUniforms();
        }
    }

    public static void updateCenterDepth(double currentCenterDepth) {
        centerDepth = currentCenterDepth;
        double temp1 = (double)diffSystemTime * 0.01;
        double temp2 = Math.exp(LOG_HALF * temp1 / centerDepthHalfLife);
        centerDepthSmooth = centerDepth + (centerDepthSmooth - centerDepth) * temp2;
    }

    public static boolean isHeldItemTranslucent() {
        return isHeldItemTranslucent;
    }

    public static void nextBlockEntity(TileEntity tileEntity) {
        int newId = ShaderEngine.getBlockEntityID(tileEntity);
        if (newId != blockEntityId) {
            blockEntityId = newId;
            ShaderState.updateUniforms();
        }
    }

    public static void pushBlockEntity() {
        if (blockEntityIdStack.size() >= 32) {
            throw new IllegalStateException("Block entity ID stack overflow!");
        }
        blockEntityIdStack.push(blockEntityId);
    }

    public static void popBlockEntity() {
        if (blockEntityIdStack.isEmpty()) {
            throw new IllegalStateException("Tried to pop empty block entity ID stack");
        }
        int newId = blockEntityIdStack.popInt();
        if (newId != blockEntityId) {
            blockEntityId = newId;
            ShaderState.updateUniforms();
        }
    }

    public static void portal() {
        blockEntityId = ShaderEngine.getBlockID(Blocks.field_150384_bq, 0);
        ShaderState.updateUniforms();
    }

    public static void nextEntity(Entity entity) {
        entityId = ShaderEngine.getEntityID(entity);
        ShaderState.updateUniforms();
    }

    public static void setHeldItem(@Nullable ItemStack itemStack) {
        heldItem = itemStack;
        isHeldItemTranslucent = false;
        if (heldItem == null) {
            return;
        }
        Item item = itemStack.func_77973_b();
        if (!(item instanceof ItemBlock)) {
            return;
        }
        ItemBlock itemBlock = (ItemBlock)item;
        Block block = itemBlock.field_150939_a;
        if (block == null) {
            return;
        }
        isHeldItemTranslucent = block.func_149701_w() != 0;
    }

    public static boolean updateViewSize() {
        float q = ShadersConfig.RenderQuality.get();
        int width = (int)((float)ShaderState.mc().field_71443_c * q);
        int height = (int)((float)ShaderState.mc().field_71440_d * q);
        if (width == ShaderState.viewSize.x && height == ShaderState.viewSize.y) {
            return false;
        }
        viewSize.set(width, height);
        return true;
    }

    public static void updatePreRenderWorld() {
        Minecraft mc = ShaderState.mc();
        WorldClient world = mc.field_71441_e;
        float partialTick = ShaderState.getSubTick();
        EntityLivingBase viewEntity = mc.field_71451_h;
        @Nullable EntityClientPlayerMP playerEntity = mc.field_71439_g;
        isEyeInWater = 0;
        if (mc.field_71474_y.field_74320_O == 0 && !playerEntity.func_70608_bn()) {
            if (viewEntity.func_70055_a(Material.field_151586_h)) {
                isEyeInWater = 1;
            } else if (viewEntity.func_70055_a(Material.field_151587_i)) {
                isEyeInWater = 2;
            }
        }
        nightVision = 0.0;
        blindness = 0.0;
        if (playerEntity != null) {
            if (playerEntity.func_70644_a(Potion.field_76439_r)) {
                nightVision = mc.field_71460_t.func_82830_a((EntityPlayer)mc.field_71439_g, partialTick);
            }
            if (playerEntity.func_70644_a(Potion.field_76440_q)) {
                int blindnessTicks = playerEntity.func_70660_b(Potion.field_76440_q).func_76459_b();
                blindness = MathUtil.clamp((double)((double)blindnessTicks / 20.0), (double)0.0, (double)1.0);
            }
        }
        ShaderState.updateEyeBrightness((Entity)viewEntity, partialTick);
        rainStrength = world.func_72867_j(partialTick);
        worldTime = (int)(world.func_72820_D() % 24000L);
        worldDay = (int)(world.func_82737_E() / 24000L);
        moonPhase = world.func_72853_d();
        if (++frameCounter >= 720720) {
            frameCounter = 0;
        }
        currentTimeMs = System.currentTimeMillis();
        if (lastFrameTimeMs == 0L) {
            lastFrameTimeMs = currentTimeMs;
        }
        diffSystemTime = currentTimeMs - lastFrameTimeMs;
        lastFrameTimeMs = currentTimeMs;
        frameTime = (double)diffSystemTime / 1000.0;
        frameTimeCounter += frameTime;
        frameTimeCounter %= 3600.0;
        double fadeScalar = (double)diffSystemTime * 0.01;
        double temp1 = Math.exp(LOG_HALF * fadeScalar / (wetness < rainStrength ? drynessHalfLife : wetnessHalfLife));
        wetness = wetness * temp1 + rainStrength * (1.0 - temp1);
        prevCamPos.set((Vector3dc)camPos);
        prevCamPosInt.set((Vector3ic)camPosInt);
        prevCamPosIntD.set((Vector3ic)prevCamPosInt);
        prevCamPosFract.set((Vector3dc)camPosFract);
        prevProjectionMat.set((Matrix4dc)projectionMat);
        prevModelViewMat.set((Matrix4dc)modelViewMat);
        Vec3 skyColor = ShaderState.mc().field_71441_e.func_72833_a((Entity)viewEntity, ShaderState.getSubTick());
        ShaderState.updateSkyColor(skyColor.field_72450_a, skyColor.field_72448_b, skyColor.field_72449_c);
        biome = world.func_72807_a((int)ShaderState.camPosInt.x, (int)ShaderState.camPosInt.z).field_76756_M;
        entityId = -1;
        blockEntityId = -1;
    }

    private static void eyeBrightnessFromRaw(int brightness) {
        ShaderState.eyeBrightness.x = brightness & 0xFFFF;
        ShaderState.eyeBrightness.y = brightness >>> 16 & 0xFFFF;
        eyeBrightnessD.set((Vector2ic)eyeBrightness);
    }

    private static void updateEyeBrightness(Entity viewEntity, float partialTick) {
        ShaderState.eyeBrightnessFromRaw(viewEntity.func_70070_b(partialTick));
        double temp1 = (double)diffSystemTime * 0.01;
        double temp2 = Math.exp(LOG_HALF * temp1 / eyeBrightnessHalfLife);
        ShaderState.eyeBrightnessSmooth.x = (double)ShaderState.eyeBrightness.x + (ShaderState.eyeBrightnessSmooth.x - (double)ShaderState.eyeBrightness.x) * temp2;
        ShaderState.eyeBrightnessSmooth.y = (double)ShaderState.eyeBrightness.y + (ShaderState.eyeBrightnessSmooth.y - (double)ShaderState.eyeBrightness.y) * temp2;
        eyeBrightnessSmoothRound.set((int)Math.round(ShaderState.eyeBrightnessSmooth.x), (int)Math.round(ShaderState.eyeBrightnessSmooth.y));
        eyeBrightnessSmoothRoundD.set((Vector2ic)eyeBrightnessSmoothRound);
    }

    public static void setCameraShadow(int size, double dist, Double fov, double intervalStep) {
        ShaderState.updateCamera(false);
        GL11.glViewport((int)0, (int)0, (int)size, (int)size);
        GL11.glMatrixMode((int)5889);
        double near = 0.05;
        double far = 256.0;
        if (fov == null) {
            GL11.glLoadIdentity();
            GL11.glOrtho((double)(-dist), (double)dist, (double)(-dist), (double)dist, (double)0.05, (double)256.0);
        } else {
            tempMat4d.setPerspective(Math.toRadians(fov), 1.0, 0.05, 256.0);
            tempDoubleBuf.clear();
            tempMat4d.get(tempDoubleBuf);
            GL11.glLoadMatrix((DoubleBuffer)tempDoubleBuf);
        }
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslated((double)0.0, (double)0.0, (double)-100.0);
        GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
        double angle = celestialAngle * -360.0;
        if (isShadowMoon) {
            angle += 180.0;
        }
        GL11.glRotated((double)angle, (double)0.0, (double)0.0, (double)1.0);
        GL11.glRotated((double)sunPathRotation, (double)1.0, (double)0.0, (double)0.0);
        if (fov == null) {
            double mod = intervalStep - intervalStep / 2.0;
            GL11.glTranslated((double)(ShaderState.camPos.x % mod), (double)(ShaderState.camPos.y % mod), (double)(ShaderState.camPos.z % mod));
        }
        tempDoubleBuf.clear();
        GL11.glGetDouble((int)2983, (DoubleBuffer)tempDoubleBuf);
        shadowProjectionMat.set(tempDoubleBuf).invert(shadowProjectionMatInv);
        GL11.glGetDouble((int)2982, (DoubleBuffer)tempDoubleBuf);
        shadowModelViewMat.set(tempDoubleBuf).invert(shadowModelViewMatInv);
        ShaderState.updateUniforms();
    }

    public static void preCelestialRotate() {
        GL11.glRotated((double)sunPathRotation, (double)0.0, (double)0.0, (double)1.0);
    }

    public static void postCelestialRotate() {
        tempDoubleBuf.clear();
        GL11.glGetDouble((int)2982, (DoubleBuffer)tempDoubleBuf);
        tempMat4d.set(tempDoubleBuf);
        sunPosition.set((Vector4dc)sunPosModelView.mul((Matrix4dc)tempMat4d, tempVec4d));
        moonPosition.set((Vector4dc)moonPosModelView.mul((Matrix4dc)tempMat4d, tempVec4d));
        if (shadowAngle == sunAngle) {
            shadowLightPosition.set((Vector3dc)sunPosition);
        } else {
            shadowLightPosition.set((Vector3dc)moonPosition);
        }
        ShaderState.updateUniforms();
    }

    public static void updateCamera(boolean withUpdate) {
        EntityLivingBase viewEntity = ShaderState.mc().field_71451_h;
        float partialTick = ShaderState.getSubTick();
        ShaderState.camPos.x = viewEntity.field_70142_S + (viewEntity.field_70165_t - viewEntity.field_70142_S) * (double)partialTick;
        ShaderState.camPos.y = viewEntity.field_70137_T + (viewEntity.field_70163_u - viewEntity.field_70137_T) * (double)partialTick;
        ShaderState.camPos.z = viewEntity.field_70136_U + (viewEntity.field_70161_v - viewEntity.field_70136_U) * (double)partialTick;
        camPos.floor(camPosFract);
        camPosInt.set((Vector3dc)camPosFract);
        camPosIntD.set((Vector3ic)camPosInt);
        camPos.sub((Vector3dc)camPosFract, camPosFract);
        tempDoubleBuf.clear();
        GL11.glGetDouble((int)2983, (DoubleBuffer)tempDoubleBuf);
        projectionMat.set(tempDoubleBuf).invert(projectionMatInv);
        GL11.glGetDouble((int)2982, (DoubleBuffer)tempDoubleBuf);
        modelViewMat.set(tempDoubleBuf).invert(modelViewMatInv);
        if (withUpdate) {
            ShaderState.updateUniforms();
        }
    }

    public static void updateCelestialAngle() {
        celestialAngle = ShaderState.mc().field_71441_e.func_72826_c(ShaderState.getSubTick());
        double d = sunAngle = celestialAngle < 0.75 ? celestialAngle + 0.25 : celestialAngle - 0.75;
        if (sunAngle <= 0.5) {
            shadowAngle = sunAngle;
            isShadowMoon = false;
        } else {
            shadowAngle = sunAngle - 0.5;
            isShadowMoon = true;
        }
    }

    public static void setUpPosition() {
        GL11.glGetDouble((int)2982, (DoubleBuffer)tempDoubleBuf);
        tempMat4d.set(tempDoubleBuf);
        upPos.set((Vector4dc)upPosModelView.mul((Matrix4dc)tempMat4d, tempVec4d));
        ShaderState.updateUniforms();
    }

    public static void updateFogColor(double r, double g, double b) {
        fogColor.set(r, g, b);
        ShaderState.updateUniforms();
    }

    public static void updateSkyColor(double r, double g, double b) {
        skyColor.set(r, g, b);
        ShaderState.updateUniforms();
    }

    public static void updateFogMode(int mode) {
        if (mode != 9729 && mode != 2048 && mode != 2049) {
            throw new AssertionError();
        }
        fogMode = mode;
        ShaderState.updateUniforms();
    }

    public static void updateEntityColor(double r, double g, double b, double a) {
        entityColor.set(r, g, b, a);
        ShaderState.updateUniforms();
    }

    public static void updatePortalEyeState(boolean s, boolean t, boolean r, boolean q) {
        ShaderState.portalEye[0] = s;
        ShaderState.portalEye[1] = t;
        ShaderState.portalEye[2] = r;
        ShaderState.portalEye[3] = q;
        ShaderState.updateUniforms();
    }

    public static void setUniformUpdateTask(Runnable task) {
        if (uniformUpdateTask != null) {
            throw new AssertionError();
        }
        uniformUpdateTask = task;
    }

    public static int heldBlockLightValue() {
        int itemId = ShaderState.heldItemId();
        if (itemId == -1) {
            return 0;
        }
        Block block = (Block)Block.field_149771_c.func_148754_a(itemId);
        return block != null ? block.func_149750_m() : 0;
    }

    public static int heldItemId() {
        ItemStack stack = ShaderState.heldItem();
        Item item = stack != null ? stack.func_77973_b() : null;
        int itemId = -1;
        if (item != null) {
            itemId = Item.field_150901_e.func_148757_b((Object)item);
        }
        return itemId;
    }

    private static ItemStack heldItem() {
        Minecraft mc = ShaderState.mc();
        EntityClientPlayerMP plr = mc.field_71439_g;
        ItemStack stack = plr != null ? plr.func_70694_bm() : null;
        return stack;
    }

    private static Minecraft mc() {
        return Minecraft.func_71410_x();
    }

    private static void updateUniforms() {
        if (uniformUpdateTask == null) {
            throw new AssertionError();
        }
        uniformUpdateTask.run();
    }

    @Generated
    private ShaderState() {
    }

    static {
        viewSize = new Vector2i();
        eyeBrightness = new Vector2i();
        eyeBrightnessD = new Vector2d();
        eyeBrightnessSmooth = new Vector2d();
        eyeBrightnessSmoothRound = new Vector2i();
        eyeBrightnessSmoothRoundD = new Vector2d();
        camPos = new Vector3d();
        camPosFract = new Vector3d();
        camPosInt = new Vector3i();
        camPosIntD = new Vector3d();
        prevCamPos = new Vector3d();
        prevCamPosFract = new Vector3d();
        prevCamPosInt = new Vector3i();
        prevCamPosIntD = new Vector3d();
        upPos = new Vector3d();
        projectionMat = new Matrix4d();
        prevProjectionMat = new Matrix4d();
        projectionMatInv = new Matrix4d();
        modelViewMat = new Matrix4d();
        prevModelViewMat = new Matrix4d();
        modelViewMatInv = new Matrix4d();
        shadowProjectionMat = new Matrix4d();
        shadowProjectionMatInv = new Matrix4d();
        shadowModelViewMat = new Matrix4d();
        shadowModelViewMatInv = new Matrix4d();
        celestialAngle = 0.0;
        sunAngle = 0.0;
        shadowAngle = 0.0;
        isShadowMoon = false;
        sunPathRotation = 30.0;
        sunPosition = new Vector3d();
        moonPosition = new Vector3d();
        shadowLightPosition = new Vector3d();
        fogMode = 2048;
        fogColor = new Vector3d();
        skyColor = new Vector3d();
        entityColor = new Vector4d();
        portalEye = new boolean[4];
        atlasSize = new Vector2i();
        heldItem = null;
        isHeldItemTranslucent = false;
        biome = 0;
        wetnessHalfLife = 600.0;
        drynessHalfLife = 200.0;
        eyeBrightnessHalfLife = 10.0;
        centerDepthHalfLife = 1.0;
        centerDepth = 0.0;
        centerDepthSmooth = 0.0;
        useOldBlockLight = true;
        blockEntityId = 0;
        blockEntityIdStack = new IntArrayList();
        entityId = 0;
        renderStage = 0;
        renderStageStack = new IntArrayList();
    }
}

