/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader;

import com.ventooth.swansong.Share;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import lombok.Generated;
import lombok.NonNull;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class ShaderTypes {
    public static final ResourceLocation gbuffers_basic;
    public static final ResourceLocation gbuffers_skybasic;
    public static final ResourceLocation gbuffers_textured;
    public static final ResourceLocation gbuffers_skytextured;
    public static final ResourceLocation gbuffers_clouds;
    public static final ResourceLocation gbuffers_beaconbeam;
    public static final ResourceLocation gbuffers_armor_glint;
    public static final ResourceLocation gbuffers_spidereyes;
    public static final ResourceLocation gbuffers_textured_lit;
    public static final ResourceLocation gbuffers_item;
    public static final ResourceLocation gbuffers_entities;
    public static final ResourceLocation gbuffers_weather;
    public static final ResourceLocation gbuffers_hand;
    public static final ResourceLocation gbuffers_hand_water;
    public static final ResourceLocation gbuffers_terrain;
    public static final ResourceLocation gbuffers_terrain_solid;
    public static final ResourceLocation gbuffers_terrain_cutout_mip;
    public static final ResourceLocation gbuffers_terrain_cutout;
    public static final ResourceLocation gbuffers_damagedblock;
    public static final ResourceLocation gbuffers_water;
    public static final ResourceLocation gbuffers_block;
    public static final ResourceLocation gbuffers_portal;
    public static final ResourceLocation shadow;
    public static final @Unmodifiable ObjectList<ResourceLocation> deferredList;
    public static final @Unmodifiable ObjectList<ResourceLocation> compositeList;
    public static final ResourceLocation _final;
    public static final @Unmodifiable ObjectList<ResourceLocation> general;
    public static final ResourceLocation blit_color_identical;
    public static final ResourceLocation blit_depth_identical;
    public static final ResourceLocation blit_color_mismatched;
    public static final ResourceLocation blit_depth_mismatched;
    public static final @Unmodifiable ObjectList<ResourceLocation> internal;
    private static Map<ResourceLocation, ResourceLocation> fallbacks;
    private static volatile boolean registryLocked;

    @Nullable
    public static ResourceLocation getFallback(ResourceLocation loc) {
        if (registryLocked) {
            return fallbacks.get(loc);
        }
        throw new IllegalStateException("Registry must be locked before a fallback can be resolved!");
    }

    public static void registerInternalFallbacks() {
        ShaderTypes.registerFallback(gbuffers_basic, null);
        ShaderTypes.registerFallback(gbuffers_skybasic, gbuffers_basic);
        ShaderTypes.registerFallback(gbuffers_textured, gbuffers_basic);
        ShaderTypes.registerFallback(gbuffers_skytextured, gbuffers_textured);
        ShaderTypes.registerFallback(gbuffers_clouds, gbuffers_textured);
        ShaderTypes.registerFallback(gbuffers_beaconbeam, gbuffers_textured);
        ShaderTypes.registerFallback(gbuffers_armor_glint, gbuffers_textured);
        ShaderTypes.registerFallback(gbuffers_spidereyes, gbuffers_textured);
        ShaderTypes.registerFallback(gbuffers_textured_lit, gbuffers_textured);
        ShaderTypes.registerFallback(gbuffers_item, gbuffers_textured_lit);
        ShaderTypes.registerFallback(gbuffers_entities, gbuffers_textured_lit);
        ShaderTypes.registerFallback(gbuffers_weather, gbuffers_textured_lit);
        ShaderTypes.registerFallback(gbuffers_hand, gbuffers_textured_lit);
        ShaderTypes.registerFallback(gbuffers_hand_water, gbuffers_hand);
        ShaderTypes.registerFallback(gbuffers_terrain, gbuffers_textured_lit);
        ShaderTypes.registerFallback(gbuffers_terrain_solid, gbuffers_terrain);
        ShaderTypes.registerFallback(gbuffers_terrain_cutout_mip, gbuffers_terrain);
        ShaderTypes.registerFallback(gbuffers_terrain_cutout, gbuffers_terrain);
        ShaderTypes.registerFallback(gbuffers_damagedblock, gbuffers_terrain);
        ShaderTypes.registerFallback(gbuffers_water, gbuffers_terrain);
        ShaderTypes.registerFallback(gbuffers_block, gbuffers_terrain);
        ShaderTypes.registerFallback(gbuffers_portal, gbuffers_block);
    }

    public static synchronized void registerFallback(@NonNull ResourceLocation shader, @Nullable ResourceLocation fallback) {
        if (shader == null) {
            throw new NullPointerException("shader is marked non-null but is null");
        }
        if (registryLocked) {
            throw new IllegalStateException("Registry is already locked! Register shaders in the init phase!");
        }
        if (fallbacks.containsKey(shader)) {
            throw new IllegalStateException(shader + " is already registered!");
        }
        fallbacks.put(shader, fallback);
        Share.log.debug("Registered Shader Fallback: [{}] -> [{}]", new Object[]{ShaderTypes.toStr(shader), ShaderTypes.toStr(fallback)});
    }

    public static synchronized void validateRegistry() {
        registryLocked = true;
        fallbacks.forEach((shader, fallback) -> {
            if (fallback == null) {
                return;
            }
            if (!fallbacks.containsKey(fallback)) {
                throw new IllegalStateException("Shader " + shader + " defined a missing fallback: " + fallback);
            }
        });
        fallbacks = Collections.unmodifiableMap(fallbacks);
        Share.log.info("Locked Shader Type Registry with {} entries:", new Object[]{fallbacks.size()});
        HashMap<ResourceLocation, List> reverse = new HashMap<ResourceLocation, List>();
        fallbacks.forEach((shader, fallback) -> reverse.computeIfAbsent((ResourceLocation)fallback, loc -> new ArrayList()).add(shader));
        reverse.forEach((fallback, shaders) -> {
            StringJoiner sj = new StringJoiner(" ");
            shaders.forEach(shader -> sj.add(ShaderTypes.toStr(shader)));
            Share.log.info("[{}] <- [{}]", new Object[]{ShaderTypes.toStr(fallback), sj});
        });
    }

    private static String toStr(@Nullable ResourceLocation loc) {
        if (loc == null) {
            return "NULL";
        }
        String name = loc.func_110623_a();
        String domain = loc.func_110624_b();
        if ("minecraft".equals(domain)) {
            return name;
        }
        return domain + ":" + name;
    }

    @Generated
    public ShaderTypes() {
    }

    static {
        ShaderTypeListBuilder listBuilder = new ShaderTypeListBuilder();
        gbuffers_basic = listBuilder.addSingle("gbuffers_basic");
        gbuffers_skybasic = listBuilder.addSingle("gbuffers_skybasic");
        gbuffers_textured = listBuilder.addSingle("gbuffers_textured");
        gbuffers_skytextured = listBuilder.addSingle("gbuffers_skytextured");
        gbuffers_clouds = listBuilder.addSingle("gbuffers_clouds");
        gbuffers_beaconbeam = listBuilder.addSingle("gbuffers_beaconbeam");
        gbuffers_armor_glint = listBuilder.addSingle("gbuffers_armor_glint");
        gbuffers_spidereyes = listBuilder.addSingle("gbuffers_spidereyes");
        gbuffers_textured_lit = listBuilder.addSingle("gbuffers_textured_lit");
        gbuffers_item = listBuilder.addSingle("gbuffers_item");
        gbuffers_entities = listBuilder.addSingle("gbuffers_entities");
        gbuffers_weather = listBuilder.addSingle("gbuffers_weather");
        gbuffers_hand = listBuilder.addSingle("gbuffers_hand");
        gbuffers_hand_water = listBuilder.addSingle("gbuffers_hand_water");
        gbuffers_terrain = listBuilder.addSingle("gbuffers_terrain");
        gbuffers_terrain_solid = listBuilder.addSingle("gbuffers_terrain_solid");
        gbuffers_terrain_cutout_mip = listBuilder.addSingle("gbuffers_terrain_cutout_mip");
        gbuffers_terrain_cutout = listBuilder.addSingle("gbuffers_terrain_cutout");
        gbuffers_damagedblock = listBuilder.addSingle("gbuffers_damagedblock");
        gbuffers_water = listBuilder.addSingle("gbuffers_water");
        gbuffers_block = listBuilder.addSingle("gbuffers_block");
        gbuffers_portal = listBuilder.addSingle("gbuffers_portal");
        shadow = listBuilder.addSingle("shadow");
        deferredList = listBuilder.addMulti("deferred", 100);
        compositeList = listBuilder.addMulti("composite", 100);
        _final = listBuilder.addSingle("final");
        general = listBuilder.build();
        listBuilder = new ShaderTypeListBuilder();
        blit_color_identical = listBuilder.addSingle("swansong:blit_identical/blit_color");
        blit_depth_identical = listBuilder.addSingle("swansong:blit_identical/blit_depth");
        blit_color_mismatched = listBuilder.addSingle("swansong:blit_mismatched/blit_color");
        blit_depth_mismatched = listBuilder.addSingle("swansong:blit_mismatched/blit_depth");
        internal = listBuilder.build();
        fallbacks = new HashMap<ResourceLocation, ResourceLocation>();
        registryLocked = false;
    }

    private static class ShaderTypeListBuilder {
        final ObjectList<ResourceLocation> list = new ObjectArrayList();

        private ShaderTypeListBuilder() {
        }

        @Unmodifiable ObjectList<ResourceLocation> addMulti(String baseName, int count) {
            ObjectArrayList list = new ObjectArrayList();
            list.add((Object)this.addSingle(baseName));
            for (int i = 1; i < count; ++i) {
                list.add((Object)this.addSingle(baseName + i));
            }
            return ObjectLists.unmodifiable((ObjectList)list);
        }

        ResourceLocation addSingle(String name) {
            ResourceLocation loc = new ResourceLocation(name);
            this.list.add((Object)loc);
            return loc;
        }

        @Unmodifiable ObjectList<ResourceLocation> build() {
            return ObjectLists.unmodifiable(this.list);
        }
    }
}

