/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader;

import com.ventooth.swansong.debug.DebugMarker;
import java.nio.FloatBuffer;
import lombok.Generated;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL30;

public final class ShadersCompositeMesh {
    private static boolean isInitialized = false;
    private static int vao = 0;
    private static int vbo = 0;

    public static void drawWithColor() {
        ShadersCompositeMesh.draw(Mask.Color);
    }

    public static void drawWithAnaglyphField(int field) {
        if (field == 0) {
            ShadersCompositeMesh.draw(Mask.AnaglyphCyan);
        } else {
            ShadersCompositeMesh.draw(Mask.AnaglyphRed);
        }
    }

    public static void drawWithDepth(boolean combine) {
        ShadersCompositeMesh.draw(combine ? Mask.DepthCombine : Mask.Depth);
    }

    public static void draw(Mask mask) {
        if (!isInitialized) {
            throw new AssertionError();
        }
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)2929);
        if (mask == Mask.DepthCombine) {
            GL11.glDepthFunc((int)515);
        } else {
            GL11.glDepthFunc((int)519);
        }
        switch (mask) {
            case Color: {
                GL11.glDepthMask((boolean)false);
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                break;
            }
            case AnaglyphRed: {
                GL11.glDepthMask((boolean)false);
                GL11.glColorMask((boolean)true, (boolean)false, (boolean)false, (boolean)false);
                break;
            }
            case AnaglyphCyan: {
                GL11.glDepthMask((boolean)false);
                GL11.glColorMask((boolean)false, (boolean)true, (boolean)true, (boolean)false);
                break;
            }
            case Depth: 
            case DepthCombine: {
                GL11.glDepthMask((boolean)true);
                GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                break;
            }
            case Both: {
                GL11.glDepthMask((boolean)true);
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            }
        }
        GL30.glBindVertexArray((int)vao);
        GL11.glDrawArrays((int)5, (int)0, (int)4);
        GL30.glBindVertexArray((int)0);
        if (DebugMarker.isEnabled()) {
            DebugMarker.GENERIC.insert("Composite drawn with mask: " + (Object)((Object)mask));
        }
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    public static void init() {
        if (isInitialized) {
            return;
        }
        vbo = GL15.glGenBuffers();
        vao = GL30.glGenVertexArrays();
        GL30.glBindVertexArray((int)vao);
        GL15.glBindBuffer((int)34962, (int)vbo);
        FloatBuffer mesh = BufferUtils.createFloatBuffer((int)16);
        mesh.put(0.0f).put(0.0f).put(0.0f).put(0.0f);
        mesh.put(1.0f).put(0.0f).put(1.0f).put(0.0f);
        mesh.put(0.0f).put(1.0f).put(0.0f).put(1.0f);
        mesh.put(1.0f).put(1.0f).put(1.0f).put(1.0f);
        mesh.flip();
        GL15.glBufferData((int)34962, (FloatBuffer)mesh, (int)35044);
        int xySizeFloats = 2;
        int uvSizeFloats = 2;
        int xySizeBytes = 8;
        int uvSizeBytes = 8;
        boolean xyOffsetBytes = false;
        int uvOffsetBytes = 8;
        int strideBytes = 16;
        GL11.glVertexPointer((int)2, (int)5126, (int)16, (long)0L);
        GL11.glEnableClientState((int)32884);
        GL11.glTexCoordPointer((int)2, (int)5126, (int)16, (long)8L);
        GL11.glEnableClientState((int)32888);
        GL15.glBindBuffer((int)34962, (int)0);
        GL30.glBindVertexArray((int)0);
        isInitialized = true;
    }

    public static void deinit() {
        if (!isInitialized) {
            return;
        }
        GL30.glDeleteVertexArrays((int)vao);
        vao = 0;
        GL15.glDeleteBuffers((int)vbo);
        vbo = 0;
        isInitialized = false;
    }

    @Generated
    private ShadersCompositeMesh() {
    }

    public static enum Mask {
        Color,
        AnaglyphRed,
        AnaglyphCyan,
        Depth,
        DepthCombine,
        Both;

    }
}

