/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader.loader;

import com.falsepattern.lib.util.MathUtil;
import com.ventooth.swansong.EnvInfo;
import com.ventooth.swansong.Share;
import com.ventooth.swansong.gl.GLProgram;
import com.ventooth.swansong.gl.GLShader;
import com.ventooth.swansong.resources.ShaderPackManager;
import com.ventooth.swansong.resources.ShaderpackResourceManagerAdapter;
import com.ventooth.swansong.resources.pack.ShaderPack;
import com.ventooth.swansong.shader.MCRenderStage;
import com.ventooth.swansong.shader.Report;
import com.ventooth.swansong.shader.ShaderException;
import com.ventooth.swansong.shader.ShaderTypes;
import com.ventooth.swansong.shader.config.ConfigEntry;
import com.ventooth.swansong.shader.info.Screen;
import com.ventooth.swansong.shader.info.ShaderProperties;
import com.ventooth.swansong.shader.loader.CompiledProgram;
import com.ventooth.swansong.shader.loader.IShaderPool;
import com.ventooth.swansong.shader.loader.ShaderLoaderInParams;
import com.ventooth.swansong.shader.loader.ShaderLoaderOutParams;
import com.ventooth.swansong.shader.loader.ShaderPool;
import com.ventooth.swansong.shader.loader.config.ConfigChoice;
import com.ventooth.swansong.shader.loader.config.ConfigProfile;
import com.ventooth.swansong.shader.loader.config.ConfigRootScreen;
import com.ventooth.swansong.shader.loader.config.ConfigScreen;
import com.ventooth.swansong.shader.preprocessor.MacroBuilder;
import com.ventooth.swansong.shader.preprocessor.Option;
import com.ventooth.swansong.shader.preprocessor.ShaderPreprocessor;
import com.ventooth.swansong.shader.preprocessor.ShaderStage2Meta;
import com.ventooth.swansong.shader.uniform.CompiledUniforms;
import com.ventooth.swansong.todo.tess.DanglingWiresTess;
import com.ventooth.swansong.uniforms.UniformFunctionRegistry;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.Language;
import net.minecraft.client.resources.Locale;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4d;

public class ShaderLoader {
    public ObjectList<ResourceLocation> inExpectedShaders;
    public ObjectList<DanglingWiresTess.AttribMapping> inAttribs;
    public ShaderLoaderInParams inParams;
    public byte @Nullable [] inShaderConfig;
    public EnvInfo inEnvInfo;
    public UniformFunctionRegistry inMcUniforms;
    private ShaderPool outShaderPool;
    @Nullable
    public CompiledUniforms outCompiledUniforms;
    public ConfigEntry.RootScreen outConfigScreen;
    public ShaderLoaderOutParams outParams;
    public Locale outLocale;
    private final ShaderPack pack;
    private final ShaderPreprocessor preprocessor;
    @Nullable
    private final WorldProvider dimension;
    private ShaderLoaderOutParams.Builder paramsBuilder;
    private boolean loaded = false;
    private Object2ObjectMap<String, Option.Value> configFile;
    private Stage1ExtraMacros stage1ExtraMacros;
    private DeduplicatingOptionList definesStage1;
    private DeduplicatingOptionList constsStage1;
    private ObjectList<ProgramStage1> stage1;
    private Object2ObjectMap<String, Option.Value> shaderPropertiesMacros;
    private ShaderProperties shaderProperties;
    private DeduplicatingOptionList definesStage2;
    private DeduplicatingOptionList constsStage2;
    private ObjectList<ProgramStage2> stage2;
    private ObjectSet<String> disabled;

    public IShaderPool borrowOutShaderPool() {
        ShaderPool res = this.outShaderPool;
        this.outShaderPool = null;
        return res;
    }

    public ShaderLoader(ShaderPack pack, @Nullable WorldProvider dimension) {
        this.pack = pack;
        this.preprocessor = new ShaderPreprocessor(pack);
        this.dimension = dimension;
    }

    public void reset() {
        this.inExpectedShaders = null;
        this.inAttribs = null;
        this.inShaderConfig = null;
        this.inEnvInfo = null;
        this.inParams = null;
        ShaderPool comp = this.outShaderPool;
        if (comp != null) {
            comp.close();
        }
        this.outShaderPool = null;
        this.outCompiledUniforms = null;
        this.outConfigScreen = null;
        this.outParams = null;
        this.outLocale = null;
        this.loaded = false;
        this.clearTemp();
    }

    private void clearTemp() {
        this.paramsBuilder = null;
        this.configFile = null;
        this.stage1ExtraMacros = null;
        this.definesStage1 = null;
        this.constsStage1 = null;
        this.stage1 = null;
        this.shaderPropertiesMacros = null;
        this.shaderProperties = null;
        this.definesStage2 = null;
        this.constsStage2 = null;
        this.stage2 = null;
        this.disabled = null;
    }

    public void lazyLoad(@Nullable Report report) {
        if (this.loaded) {
            return;
        }
        this.load(report);
    }

    public void load(@Nullable Report report) {
        this.loaded = true;
        Option.purgeCaches();
        ShaderPool comp = this.outShaderPool;
        if (comp != null) {
            comp.close();
        }
        this.outShaderPool = new ShaderPool();
        this.shaderPropertiesMacros = null;
        this.shaderProperties = null;
        this.paramsBuilder = new ShaderLoaderOutParams.Builder();
        this.configFile = new Object2ObjectOpenHashMap();
        this.definesStage1 = new DeduplicatingOptionList();
        this.constsStage1 = new DeduplicatingOptionList();
        this.definesStage2 = new DeduplicatingOptionList();
        this.constsStage2 = new DeduplicatingOptionList();
        this.stage1 = new ObjectArrayList(this.inExpectedShaders.size());
        this.stage2 = new ObjectArrayList(this.inExpectedShaders.size());
        this.disabled = new ObjectOpenHashSet();
        this.loadConfigFile();
        this.parseEnvInfo();
        for (ResourceLocation expectedShader : this.inExpectedShaders) {
            ProgramStage1 sh1 = this.runProgramStage1(expectedShader, report);
            if (sh1 == null) continue;
            this.stage1.add((Object)sh1);
        }
        this.inExpectedShaders = null;
        this.outLocale = new Locale();
        Language lang = Minecraft.func_71410_x().func_135016_M().func_135041_c();
        ArrayList<String> langs = new ArrayList<String>();
        langs.add("en_US");
        if (!"en_US".equals(lang.func_135034_a())) {
            langs.add(lang.func_135034_a());
        }
        this.outLocale.func_135022_a((IResourceManager)new ShaderpackResourceManagerAdapter(this.pack), langs);
        this.parseShadersProperties();
        this.extractParamsFromProperties();
        this.disableShadersFromProperties();
        if (!this.disabled.isEmpty()) {
            this.outShaderPool.setDisabled(this.disabled);
        }
        this.createConfigScreen();
        for (ProgramStage1 sh1 : this.stage1) {
            this.stage2.add((Object)this.runProgramStage2(sh1));
        }
        for (ProgramStage2 sh2 : this.stage2) {
            ProgramCompiled c = this.compileShader(sh2, report);
            if (c == null) continue;
            this.outShaderPool.insertShader(c.loc, new CompiledProgram(c.path, c.program, (ObjectList<String>)c.mipmapEnabled, c.renderTargets, c.actualLoc));
        }
        this.inAttribs = null;
        this.extractParamsFromStage2();
        this.compileUniforms();
        this.outParams = this.paramsBuilder.build();
        this.clearTemp();
        Option.purgeCaches();
    }

    private void parseEnvInfo() {
        String string;
        String string2;
        String string3;
        if (this.inEnvInfo == null) {
            return;
        }
        Option.Value mcVersion = ShaderLoader.parseSemVer(this.inEnvInfo.mcVersion, 10000, 100, 1);
        Option.Value glVersion = ShaderLoader.parseSemVer(this.inEnvInfo.glVersionStr.split(" ", 2)[0], 100, 10, 1);
        Option.Value glslVersion = ShaderLoader.parseSemVer(this.inEnvInfo.glslVersionStr.split(" ", 2)[0], 100, 1, 0);
        Option.Value swansongVersion = ShaderLoader.parseSemVer(this.inEnvInfo.swansongVersion, 10000, 100, 1);
        switch (this.inEnvInfo.glVendor) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ATI: {
                string3 = "MC_GL_VENDOR_ATI";
                break;
            }
            case INTEL: {
                string3 = "MC_GL_VENDOR_INTEL";
                break;
            }
            case NVIDIA: {
                string3 = "MC_GL_VENDOR_NVIDIA";
                break;
            }
            case AMD: {
                string3 = "MC_GL_VENDOR_AMD";
                break;
            }
            case XORG: {
                string3 = "MC_GL_VENDOR_XORG";
                break;
            }
            case OTHER: {
                string3 = "MC_GL_VENDOR_OTHER";
            }
        }
        String vendorMacro = string3;
        switch (this.inEnvInfo.glRenderer) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case RADEON: {
                string2 = "MC_GL_RENDERER_RADEON";
                break;
            }
            case GALLIUM: {
                string2 = "MC_GL_RENDERER_GALLIUM";
                break;
            }
            case INTEL: {
                string2 = "MC_GL_RENDERER_INTEL";
                break;
            }
            case GEFORCE: {
                string2 = "MC_GL_RENDERER_GEFORCE";
                break;
            }
            case QUADRO: {
                string2 = "MC_GL_RENDERER_QUADRO";
                break;
            }
            case MESA: {
                string2 = "MC_GL_RENDERER_MESA";
                break;
            }
            case OTHER: {
                string2 = "MC_GL_RENDERER_OTHER";
            }
        }
        String rendererMacro = string2;
        switch (this.inEnvInfo.osPlatform) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case WINDOWS: {
                string = "MC_OS_WINDOWS";
                break;
            }
            case OSX: {
                string = "MC_OS_MAC";
                break;
            }
            case LINUX: {
                string = "MC_OS_LINUX";
                break;
            }
            case OTHER: {
                string = "MC_OS_OTHER";
            }
        }
        String osMacro = string;
        ArrayList<String> extensions = new ArrayList<String>();
        for (String ext : this.inEnvInfo.glExtSet) {
            extensions.add("MC_" + ext);
        }
        extensions.sort(Comparator.naturalOrder());
        this.stage1ExtraMacros = new Stage1ExtraMacros(mcVersion, glVersion, glslVersion, swansongVersion, vendorMacro, rendererMacro, osMacro, extensions, new Option.Value.Dbl(this.inParams.handDepth), new Option.Value.Dbl(this.inParams.renderQuality), new Option.Value.Dbl(this.inParams.shadowQuality));
    }

    private static Option.Value parseSemVer(String version, int mulMajor, int mulMinor, int mulPatch) {
        String[] parts = version.split("\\.", 4);
        int major = parts.length >= 1 ? ShaderLoader.parseIntSafe(parts[0]) : 0;
        int minor = parts.length >= 2 ? ShaderLoader.parseIntSafe(parts[1]) : 0;
        int release = parts.length >= 3 ? ShaderLoader.parseIntSafe(parts[2]) : 0;
        return new Option.Value.Int(major * mulMajor + minor * mulMinor + release * mulPatch);
    }

    private static int parseIntSafe(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException ignored) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfigFile() {
        if (this.inShaderConfig == null) {
            return;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.inShaderConfig)));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String trimmed;
                int commentIndex = line.indexOf(35);
                String withoutComment = commentIndex < 0 ? line : line.substring(0, commentIndex);
                if (withoutComment.isEmpty() || (trimmed = line.trim()).isEmpty()) continue;
                String[] parts = trimmed.split("=", 2);
                if (parts.length != 2) {
                    Share.log.warn("Invalid shader config line: {}", new Object[]{line});
                    continue;
                }
                this.configFile.put((Object)parts[0].trim(), (Object)Option.Value.detect(parts[1].trim()));
            }
        }
        catch (IOException e) {
            Share.log.error("Failed to read shader config", (Throwable)e);
        }
        finally {
            this.inShaderConfig = null;
        }
    }

    private ProgramStage1 runProgramStage1(ResourceLocation inLoc, @Nullable Report report) {
        ShaderPreprocessor.PreprocessorStage1Suspend frag;
        ShaderPreprocessor.PreprocessorStage1Suspend vert;
        ResourceLocation loc;
        String path;
        String inPath;
        block6: {
            path = inPath = this.shaderPath(inLoc);
            loc = inLoc;
            while (true) {
                vert = this.runStage1(path + ".vsh");
                frag = this.runStage1(path + ".fsh");
                if (vert != null || frag != null) break block6;
                if ((loc = ShaderTypes.getFallback(loc)) == null) break;
                path = this.shaderPath(loc);
            }
            return null;
        }
        if (vert == null) {
            Share.log.error("Missing vertex shader for path: {}", new Object[]{path});
            if (report != null) {
                report.erroredShaders.add(path);
            }
            return null;
        }
        if (frag == null) {
            Share.log.error("Missing fragment shader for path: {}", new Object[]{path});
            if (report != null) {
                report.erroredShaders.add(path);
            }
            return null;
        }
        if (report != null && !Objects.equals(inPath, path)) {
            report.shadersFallback.put(inPath, path);
        }
        return new ProgramStage1(inLoc, loc, inPath, vert, frag);
    }

    private String shaderPath(ResourceLocation loc) {
        String spec;
        String domain = loc.func_110624_b();
        String path = loc.func_110623_a();
        if (!"minecraft".equals(domain)) {
            path = domain + "/" + path;
        }
        if ((spec = this.pack.getWorldSpecialization(this.dimension)) != null) {
            path = spec + "/" + path;
        }
        return path;
    }

    private ShaderPreprocessor.PreprocessorStage1Suspend runStage1(String path) {
        return this.preprocessor.runStage1(path, true, stage1 -> {
            this.addBuiltinMacros(stage1.extraMacros);
            for (Option opt : stage1.defines) {
                String name = opt.name;
                Option.Value config = (Option.Value)this.configFile.get((Object)name);
                if (config != null) {
                    opt.setCurrentValue(config);
                }
                this.definesStage1.add(opt);
            }
            for (Option opt : stage1.consts) {
                this.constsStage1.add(opt);
            }
        });
    }

    private void addBuiltinMacros(MacroBuilder builder) {
        builder.add(this.stage1ExtraMacros.glVendorMacro);
        builder.add(this.stage1ExtraMacros.glRendererMacro);
        builder.add("MC_GL_VERSION", this.stage1ExtraMacros.glVersion);
        builder.add("MC_GLSL_VERSION", this.stage1ExtraMacros.glslVersion);
        builder.add("MC_HAND_DEPTH", this.stage1ExtraMacros.handDepth);
        builder.add("MC_RENDER_QUALITY", this.stage1ExtraMacros.renderQuality);
        builder.add("MC_SHADOW_QUALITY", this.stage1ExtraMacros.shadowQuality);
        builder.add("MC_VERSION", this.stage1ExtraMacros.mcVersion);
        builder.add(this.stage1ExtraMacros.osMacro);
        for (MCRenderStage renderStage : MCRenderStage.values()) {
            builder.add(renderStage.macro(), renderStage.value());
        }
        for (String ext : this.stage1ExtraMacros.extensions) {
            builder.add(ext);
        }
        builder.add("IS_SWANSONG");
        builder.add("SWANSONG_VERSION", this.stage1ExtraMacros.swansongVersion);
    }

    private void parseShadersProperties() {
        MacroBuilder builder = new MacroBuilder();
        this.addBuiltinMacros(builder);
        this.definesStage1.options.forEach(option -> builder.add(option.name, option.getCurrentValue()));
        this.shaderPropertiesMacros = builder.get();
        byte[] propertiesBytes = this.preprocessor.getBytes("shaders.properties", false, stage1 -> stage1.extraMacros.addAll(this.shaderPropertiesMacros), stage2 -> {});
        if (propertiesBytes != null) {
            this.shaderProperties = ShaderProperties.parse(propertiesBytes);
        }
    }

    private void extractParamsFromProperties() {
        ShaderProperties props = this.shaderProperties;
        if (props == null) {
            return;
        }
        props.parseQuality("clouds", this.paramsBuilder::clouds);
        props.parseBool("moon", this.paramsBuilder::moon);
        props.parseBool("sun", this.paramsBuilder::sun);
        props.parseBool("underwaterOverlay", this.paramsBuilder::underwaterOverlay);
        props.parseBool("vignette", this.paramsBuilder::vignette);
        props.parseBool("oldHandLight", this.paramsBuilder::oldHandLight);
        props.parseBool("oldLighting", this.paramsBuilder::oldLighting);
        props.parseBool("shadowTerrain", this.paramsBuilder::shadowTerrain);
        props.parseBool("shadowTranslucent", this.paramsBuilder::shadowTranslucent);
        props.parseBool("shadowEntities", this.paramsBuilder::shadowEntities);
        props.parseBool("shadowBlockEntities", this.paramsBuilder::shadowBlockEntities);
        props.parseBool("backface.solid", this.paramsBuilder::backFaceSolid);
        props.parseBool("backface.cutout", this.paramsBuilder::backFaceCutout);
        props.parseBool("backface.cutoutMipped", this.paramsBuilder::backFaceCutoutMipped);
        props.parseBool("backface.translucent", this.paramsBuilder::backFaceTranslucent);
        props.parseBool("frustum.culling", this.paramsBuilder::frustumCulling);
        props.parseBool("shadow.culling", this.paramsBuilder::shadowCulling);
        props.parseBool("rain.depth", this.paramsBuilder::rainDepth);
        props.parseBool("beacon.beam.depth", this.paramsBuilder::beaconBeamDepth);
        props.parseBool("rpleCompatible", this.paramsBuilder::rpleCompatible);
        props.texture().forEach((name, path) -> {
            if ("noise".equals(name)) {
                this.paramsBuilder.noiseTexture((String)path);
                return;
            }
            String[] parts = name.split("\\.", 2);
            if (parts.length != 2) {
                Share.log.warn("Invalid texture in properties: \"{}\"", new Object[]{name});
                return;
            }
            ((Object2ObjectMap)this.paramsBuilder.textures.computeIfAbsent((Object)parts[0], ign -> new Object2ObjectLinkedOpenHashMap())).put((Object)parts[1], path);
        });
    }

    private void disableShadersFromProperties() {
        ShaderProperties props = this.shaderProperties;
        if (props == null) {
            return;
        }
        props.programEnableExpressions().forEach(program -> {
            String opt = "program." + program + ".enabled";
            props.parseBoolExpr(this.shaderPropertiesMacros, opt, flag -> {
                if (!flag) {
                    this.disabled.add(program);
                }
            });
        });
    }

    private void createConfigScreen() {
        ConfigProfile profile;
        ObjectArrayList allOptions = new ObjectArrayList();
        Screen screenInfo = this.shaderProperties != null ? this.shaderProperties.screen() : null;
        ObjectList<String> mainPage = screenInfo != null ? screenInfo.mainPage() : null;
        ObjectSet<String> sliders = screenInfo != null ? screenInfo.sliders() : null;
        Object2ObjectMap<String, String> profilesList = this.shaderProperties != null ? this.shaderProperties.profiles() : null;
        ConfigProfile configProfile = profile = profilesList != null && !profilesList.isEmpty() ? new ConfigProfile(this.outLocale, (ObjectList<Option>)allOptions, profilesList) : null;
        if (mainPage == null) {
            this.readStage1Options(arg_0 -> ((ObjectArrayList)allOptions).add(arg_0));
            ObjectArrayList mainScreenContent = new ObjectArrayList();
            if (profile != null) {
                mainScreenContent.add((Object)profile);
            }
            ConfigRootScreen root = new ConfigRootScreen(this.outLocale, (ObjectList<ConfigEntry>)mainScreenContent, (ObjectList<Option>)allOptions);
            this.outConfigScreen = root;
            for (int i = 0; i < allOptions.size(); ++i) {
                Option opt2 = (Option)allOptions.get(i);
                mainScreenContent.add((Object)this.optionToEntry(sliders, opt2, i, root));
            }
        } else {
            Object2IntOpenHashMap optionsIndices = new Object2IntOpenHashMap();
            Object2ObjectOpenHashMap optionsMap = new Object2ObjectOpenHashMap();
            this.readStage1Options(opt -> {
                optionsIndices.put((Object)opt.name, allOptions.size());
                allOptions.add(opt);
                optionsMap.put((Object)opt.name, opt);
            });
            ConfigRootScreen rootScreen = new ConfigRootScreen(this.outLocale, (ObjectList<ConfigEntry>)new ObjectArrayList(), (ObjectList<Option>)allOptions);
            this.outConfigScreen = rootScreen;
            Object2ObjectOpenHashMap subScreens = new Object2ObjectOpenHashMap();
            Object2ObjectMaps.fastForEach(screenInfo.subPages(), entry -> {
                String key = (String)entry.getKey();
                subScreens.put((Object)key, (Object)new ConfigScreen(this.outLocale, key, (ObjectList<ConfigEntry>)new ObjectArrayList()));
            });
            this.parseScreen((ObjectList<ConfigEntry>)rootScreen.content, (Object2ObjectMap<String, ConfigScreen>)subScreens, (Object2ObjectMap<String, Option>)optionsMap, profile, sliders, mainPage, (Object2IntMap<String>)optionsIndices, rootScreen);
            screenInfo.subPages().forEach((name, value) -> {
                ConfigScreen subScreen = (ConfigScreen)subScreens.get(name);
                this.parseScreen(subScreen.content, (Object2ObjectMap<String, ConfigScreen>)subScreens, (Object2ObjectMap<String, Option>)optionsMap, profile, sliders, (ObjectList<String>)value, (Object2IntMap<String>)optionsIndices, rootScreen);
            });
        }
    }

    private ConfigEntry optionToEntry(ObjectSet<String> sliders, Option opt, int index, ConfigRootScreen root) {
        if (sliders != null && sliders.contains((Object)opt.name)) {
            return new ConfigChoice.Draggable(this.outLocale, opt, index, root);
        }
        if (opt.isToggle()) {
            return new ConfigChoice.Toggleable(this.outLocale, opt, index, root);
        }
        return new ConfigChoice.Switchable(this.outLocale, opt, index, root);
    }

    private void parseScreen(ObjectList<ConfigEntry> output, Object2ObjectMap<String, ConfigScreen> subScreens, Object2ObjectMap<String, Option> options, ConfigProfile profile, ObjectSet<String> sliders, ObjectList<String> config, Object2IntMap<String> indices, ConfigRootScreen root) {
        for (String element : config) {
            if ("<empty>".equals(element)) {
                output.add(null);
                continue;
            }
            if ("<profile>".equals(element)) {
                output.add((Object)profile);
                continue;
            }
            if (element.startsWith("[") && element.endsWith("]")) {
                ConfigScreen subScreen = (ConfigScreen)subScreens.get((Object)element.substring(1, element.length() - 1));
                output.add((Object)subScreen);
                continue;
            }
            Option option = (Option)options.get((Object)element);
            if (option == null) {
                output.add(null);
                continue;
            }
            output.add((Object)this.optionToEntry(sliders, option, indices.getInt((Object)option.name), root));
        }
    }

    private void readStage1Options(Consumer<Option> configurer) {
        this.definesStage1.options.forEach(opt -> {
            if (opt.isConfigurable()) {
                configurer.accept(opt.copy(false));
            }
        });
        this.constsStage1.options.forEach(opt -> {
            if (opt.isConfigurable()) {
                Option theCopy = opt.copy(false);
                Option.Value config = (Option.Value)this.configFile.get((Object)theCopy.name);
                if (config != null) {
                    theCopy.setCurrentValue(config);
                }
                configurer.accept(theCopy);
            }
        });
    }

    private ProgramStage2 runProgramStage2(ProgramStage1 stage1) {
        IntList[] pRenderTargets = new IntList[1];
        ObjectLinkedOpenHashSet mipmapEnabled = new ObjectLinkedOpenHashSet();
        ShaderPreprocessor.PreprocessorStage2Suspend vert = stage1.vert.runStage2(stage2 -> this.fetchStage2Data((ShaderStage2Meta)stage2, (ObjectSet<String>)mipmapEnabled));
        ShaderPreprocessor.PreprocessorStage2Suspend frag = stage1.frag.runStage2(stage2 -> {
            this.fetchStage2Data((ShaderStage2Meta)stage2, (ObjectSet<String>)mipmapEnabled);
            pRenderTargets[0] = stage2.renderTargets;
        });
        return new ProgramStage2(stage1.loc, stage1.actualLoc, stage1.path, vert, frag, (ObjectList)new ObjectArrayList((ObjectCollection)mipmapEnabled), pRenderTargets[0]);
    }

    private void fetchStage2Data(ShaderStage2Meta stage2, ObjectSet<String> mipmapEnabled) {
        this.definesStage2.addAll(stage2.defines);
        for (Option opt : stage2.consts) {
            String name = opt.name;
            Option.Value config = (Option.Value)this.configFile.get((Object)name);
            if (config != null) {
                opt.setCurrentValue(config);
            }
            this.constsStage2.add(opt);
            this.tryFetchMipMapEnabledOption(opt, mipmapEnabled);
        }
    }

    private void tryFetchMipMapEnabledOption(Option option, ObjectSet<String> output) {
        if (!option.isToggle()) {
            return;
        }
        String name = option.name;
        if (!name.endsWith("MipmapEnabled")) {
            return;
        }
        String bufName = name.substring(0, name.length() - "MipmapEnabled".length());
        if (option.isEnabled()) {
            output.add((Object)bufName);
        }
    }

    private void extractParamsFromStage2() {
        ShaderLoaderOutParams.Builder p = this.paramsBuilder;
        block64: for (Option opt : this.constsStage2.options) {
            Option.Value v = opt.getCurrentValue();
            switch (opt.name) {
                case "ambientOcclusionLevel": {
                    v.safeDouble(0.0, 1.0, p::ambientOcclusionLevel);
                    continue block64;
                }
                case "sunPathRotation": {
                    v.safeDouble(p::sunPathRotation);
                    continue block64;
                }
                case "eyeBrightnessHalflife": {
                    v.safeDouble(p::eyeBrightnessHalfLife);
                    continue block64;
                }
                case "centerDepthHalflife": {
                    v.safeDouble(p::centerDepthHalfLife);
                    continue block64;
                }
                case "drynessHalflife": {
                    v.safeDouble(p::drynessHalfLife);
                    continue block64;
                }
                case "wetnessHalflife": {
                    v.safeDouble(p::wetnessHalfLife);
                    continue block64;
                }
                case "generateShadowMipmap": {
                    v.boolFused(p::shadowDepth0Mipmap, p::shadowDepth1Mipmap);
                    continue block64;
                }
                case "shadowtexMipmap": 
                case "shadowtex0Mipmap": {
                    v.boolFused(p::shadowDepth0Mipmap);
                    continue block64;
                }
                case "shadowtex0Nearest": 
                case "shadowtexNearest": 
                case "shadow0MinMagNearest": {
                    v.boolFused(p::shadowDepth0Nearest);
                    continue block64;
                }
                case "shadowtex1Mipmap": {
                    v.boolFused(p::shadowDepth1Mipmap);
                    continue block64;
                }
                case "shadowtex1Nearest": 
                case "shadow1MinMagNearest": {
                    v.boolFused(p::shadowDepth1Nearest);
                    continue block64;
                }
                case "generateShadowColorMipmap": {
                    v.boolFused(p::shadowColor0Mipmap, p::shadowColor1Mipmap);
                    continue block64;
                }
                case "shadowcolor0Mipmap": 
                case "shadowColor0Mipmap": {
                    v.boolFused(p::shadowColor0Mipmap);
                    continue block64;
                }
                case "shadowcolor0Nearest": 
                case "shadowColor0Nearest": 
                case "shadowColor0MinMagNearest": {
                    v.boolFused(p::shadowColor0Nearest);
                    continue block64;
                }
                case "shadowcolor1Mipmap": 
                case "shadowColor1Mipmap": {
                    v.boolFused(p::shadowColor1Mipmap);
                    continue block64;
                }
                case "shadowcolor1Nearest": 
                case "shadowColor1Nearest": 
                case "shadowColor1MinMagNearest": {
                    v.boolFused(p::shadowColor1Nearest);
                    continue block64;
                }
                case "noiseTextureResolution": {
                    v.safeInt(p::noiseTextureResolution);
                    continue block64;
                }
                case "shadowDistance": {
                    v.safeDouble(p::shadowDistance);
                    continue block64;
                }
                case "shadowDistanceRenderMul": {
                    v.safeDouble(p::shadowDistanceRenderMul);
                    continue block64;
                }
                case "shadowHardwareFiltering": {
                    v.boolFused(p::shadowHardwareFiltering0, p::shadowHardwareFiltering1);
                    continue block64;
                }
                case "shadowHardwareFiltering0": {
                    v.boolFused(p::shadowHardwareFiltering0);
                    continue block64;
                }
                case "shadowHardwareFiltering1": {
                    v.boolFused(p::shadowHardwareFiltering1);
                    continue block64;
                }
                case "shadowIntervalSize": {
                    v.safeDouble(p::shadowIntervalSize);
                    continue block64;
                }
                case "shadowMapFov": {
                    v.safeDouble(p::shadowMapFov);
                    continue block64;
                }
                case "shadowMapResolution": {
                    v.safeInt(p::shadowMapResolution);
                    continue block64;
                }
            }
            if (!this.tryFetchBufferFormat(opt) && !this.tryFetchBufferClear(opt) && !this.tryFetchBufferClearColor(opt)) continue;
        }
    }

    private boolean tryFetchBufferFormat(Option option) {
        String name = option.name;
        if (!name.endsWith("Format")) {
            return false;
        }
        String bufName = name.substring(0, name.length() - "Format".length());
        this.paramsBuilder.bufferFormat.put((Object)bufName, (Object)option.getCurrentValue().toString());
        return true;
    }

    private boolean tryFetchBufferClear(Option option) {
        if (!option.isToggle()) {
            return false;
        }
        String name = option.name;
        if (!name.endsWith("Clear")) {
            return false;
        }
        String bufName = name.substring(0, name.length() - "Clear".length());
        if (!option.isEnabled()) {
            this.paramsBuilder.bufferClearDisabled.add((Object)bufName);
        }
        return true;
    }

    private boolean tryFetchBufferClearColor(Option option) {
        String name = option.name;
        if (!name.endsWith("ClearColor")) {
            return false;
        }
        String bufName = name.substring(0, name.length() - "Clear".length());
        String txt = option.getCurrentValue().toString().trim();
        if (!txt.startsWith("vec4")) {
            return true;
        }
        int parenOpen = txt.indexOf(40);
        int parenClose = txt.indexOf(41);
        if (parenOpen < 0 || parenClose < parenOpen) {
            return true;
        }
        String values = txt.substring(parenOpen + 1, parenClose);
        String[] parts = values.split("\\s*,\\s*");
        if (parts.length != 4) {
            return true;
        }
        try {
            Vector4d vector = new Vector4d(Double.parseDouble(parts[0]), Double.parseDouble(parts[1]), Double.parseDouble(parts[2]), Double.parseDouble(parts[3]));
            this.paramsBuilder.bufferClearColor.put((Object)bufName, (Object)vector);
        }
        catch (NumberFormatException e) {
            Share.log.error("Could not parse buffer clear color: {}", new Object[]{values});
            Share.log.error("Stacktrace: ", (Throwable)e);
        }
        return true;
    }

    private void safeDouble(Option.Value val, double min, double max, DoubleConsumer output) {
        Double dVal = val.doubleValue();
        if (dVal == null) {
            return;
        }
        double clamped = MathUtil.clamp((double)dVal, (double)min, (double)max);
        output.accept(clamped);
    }

    private void safeDouble(Option.Value val, DoubleConsumer output) {
        Double dVal = val.doubleValue();
        if (dVal == null) {
            return;
        }
        output.accept(dVal);
    }

    private void compileUniforms() {
        if (this.shaderProperties == null) {
            return;
        }
        this.outCompiledUniforms = CompiledUniforms.createCompiledUniforms(this.inMcUniforms, this.shaderProperties.shaderVars());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProgramCompiled compileShader(ProgramStage2 stage2, @Nullable Report report) {
        GLShader vert = null;
        GLShader frag = null;
        try {
            vert = this.createShader(35633, stage2.path + ".vsh", stage2.vert.getNativeBuffer(true));
            frag = this.createShader(35632, stage2.path + ".fsh", stage2.frag.getNativeBuffer(true));
            GLProgram prog = this.createProgram(stage2.path, vert, frag);
            ProgramCompiled programCompiled = new ProgramCompiled(stage2.loc, stage2.actualLoc, stage2.path, prog, stage2.mipmapEnabled, stage2.renderTargets);
            return programCompiled;
        }
        catch (Exception e) {
            Share.log.error("Error while compiling shader {}", new Object[]{stage2.path});
            Share.log.error("Stacktrace:", (Throwable)e);
            if (report != null) {
                report.erroredShaders.add(stage2.path);
            }
            ProgramCompiled programCompiled = null;
            return programCompiled;
        }
        finally {
            if (vert != null) {
                vert.glDeleteShader();
            }
            if (frag != null) {
                frag.glDeleteShader();
            }
        }
    }

    @NotNull
    public GLShader createShader(int type, String name, ByteBuffer src) throws ShaderException {
        ShaderPackManager.dumpShader(name, src);
        GLShader shader = new GLShader();
        shader.glCreateShader(type);
        shader.glShaderSource(src);
        shader.glCompileShader();
        if (!shader.glGetShaderCompileStatus()) {
            String infoLog = shader.glGetShaderInfoLog();
            if (infoLog.isEmpty()) {
                infoLog = "Empty shader info log";
            }
            shader.glDeleteShader();
            throw new ShaderException("Failed to compile shader: " + name + '\n' + infoLog + '\n');
        }
        return shader;
    }

    @NotNull
    public GLProgram createProgram(@NotNull String name, @NotNull GLShader vertShader, @NotNull GLShader fragShader) throws ShaderException {
        GLProgram program = new GLProgram();
        program.glCreateProgram();
        program.glAttachShader(vertShader);
        program.glAttachShader(fragShader);
        for (DanglingWiresTess.AttribMapping attrib : this.inAttribs) {
            program.glBindAttribLocation(attrib.index, attrib.name);
        }
        program.glLinkProgram();
        if (!program.glGetProgramLinkStatus()) {
            String infoLog = program.glGetProgramInfoLog();
            if (infoLog.isEmpty()) {
                infoLog = "Empty program info log";
            }
            program.glDeleteProgram();
            throw new ShaderException("Failed to link program: " + name + '\n' + infoLog + '\n');
        }
        return program;
    }

    private static final class Stage1ExtraMacros {
        private final Option.Value mcVersion;
        private final Option.Value glVersion;
        private final Option.Value glslVersion;
        private final Option.Value swansongVersion;
        private final String glVendorMacro;
        private final String glRendererMacro;
        private final String osMacro;
        private final List<String> extensions;
        private final Option.Value handDepth;
        private final Option.Value renderQuality;
        private final Option.Value shadowQuality;

        private Stage1ExtraMacros(Option.Value mcVersion, Option.Value glVersion, Option.Value glslVersion, Option.Value swansongVersion, String glVendorMacro, String glRendererMacro, String osMacro, List<String> extensions, Option.Value handDepth, Option.Value renderQuality, Option.Value shadowQuality) {
            this.mcVersion = mcVersion;
            this.glVersion = glVersion;
            this.glslVersion = glslVersion;
            this.swansongVersion = swansongVersion;
            this.glVendorMacro = glVendorMacro;
            this.glRendererMacro = glRendererMacro;
            this.osMacro = osMacro;
            this.extensions = extensions;
            this.handDepth = handDepth;
            this.renderQuality = renderQuality;
            this.shadowQuality = shadowQuality;
        }

        public Option.Value mcVersion() {
            return this.mcVersion;
        }

        public Option.Value glVersion() {
            return this.glVersion;
        }

        public Option.Value glslVersion() {
            return this.glslVersion;
        }

        public Option.Value swansongVersion() {
            return this.swansongVersion;
        }

        public String glVendorMacro() {
            return this.glVendorMacro;
        }

        public String glRendererMacro() {
            return this.glRendererMacro;
        }

        public String osMacro() {
            return this.osMacro;
        }

        public List<String> extensions() {
            return this.extensions;
        }

        public Option.Value handDepth() {
            return this.handDepth;
        }

        public Option.Value renderQuality() {
            return this.renderQuality;
        }

        public Option.Value shadowQuality() {
            return this.shadowQuality;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Stage1ExtraMacros that = (Stage1ExtraMacros)obj;
            return Objects.equals(this.mcVersion, that.mcVersion) && Objects.equals(this.glVersion, that.glVersion) && Objects.equals(this.glslVersion, that.glslVersion) && Objects.equals(this.swansongVersion, that.swansongVersion) && Objects.equals(this.glVendorMacro, that.glVendorMacro) && Objects.equals(this.glRendererMacro, that.glRendererMacro) && Objects.equals(this.osMacro, that.osMacro) && Objects.equals(this.extensions, that.extensions) && Objects.equals(this.handDepth, that.handDepth) && Objects.equals(this.renderQuality, that.renderQuality) && Objects.equals(this.shadowQuality, that.shadowQuality);
        }

        public int hashCode() {
            return Objects.hash(this.mcVersion, this.glVersion, this.glslVersion, this.swansongVersion, this.glVendorMacro, this.glRendererMacro, this.osMacro, this.extensions, this.handDepth, this.renderQuality, this.shadowQuality);
        }

        public String toString() {
            return "Stage1ExtraMacros[mcVersion=" + this.mcVersion + ", glVersion=" + this.glVersion + ", glslVersion=" + this.glslVersion + ", swansongVersion=" + this.swansongVersion + ", glVendorMacro=" + this.glVendorMacro + ", glRendererMacro=" + this.glRendererMacro + ", osMacro=" + this.osMacro + ", extensions=" + this.extensions + ", handDepth=" + this.handDepth + ", renderQuality=" + this.renderQuality + ", shadowQuality=" + this.shadowQuality + ']';
        }
    }

    private class DeduplicatingOptionList {
        private final ObjectList<Option> options = new ObjectArrayList();
        private final Object2IntMap<String> indices = new Object2IntOpenHashMap();

        private DeduplicatingOptionList() {
            this.indices.defaultReturnValue(-1);
        }

        public void add(Option option) {
            int idx = this.indices.getInt((Object)option.name);
            if (idx < 0) {
                this.indices.put((Object)option.name, this.options.size());
                this.options.add((Object)option);
            } else {
                this.options.set(idx, (Object)option);
            }
        }

        public void addAll(List<Option> options) {
            for (Option option : options) {
                this.add(option);
            }
        }
    }

    private static final class ProgramStage1 {
        private final ResourceLocation loc;
        private final ResourceLocation actualLoc;
        private final String path;
        private final ShaderPreprocessor.PreprocessorStage1Suspend vert;
        private final ShaderPreprocessor.PreprocessorStage1Suspend frag;

        private ProgramStage1(ResourceLocation loc, ResourceLocation actualLoc, String path, ShaderPreprocessor.PreprocessorStage1Suspend vert, ShaderPreprocessor.PreprocessorStage1Suspend frag) {
            this.loc = loc;
            this.actualLoc = actualLoc;
            this.path = path;
            this.vert = vert;
            this.frag = frag;
        }

        public ResourceLocation loc() {
            return this.loc;
        }

        public ResourceLocation actualLoc() {
            return this.actualLoc;
        }

        public String path() {
            return this.path;
        }

        public ShaderPreprocessor.PreprocessorStage1Suspend vert() {
            return this.vert;
        }

        public ShaderPreprocessor.PreprocessorStage1Suspend frag() {
            return this.frag;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ProgramStage1 that = (ProgramStage1)obj;
            return Objects.equals(this.loc, that.loc) && Objects.equals(this.path, that.path) && Objects.equals(this.vert, that.vert) && Objects.equals(this.frag, that.frag);
        }

        public int hashCode() {
            return Objects.hash(this.loc, this.path, this.vert, this.frag);
        }

        public String toString() {
            return "ProgramStage1[loc=" + this.loc + ", path=" + this.path + ", vert=" + this.vert + ", frag=" + this.frag + ']';
        }
    }

    private static final class ProgramStage2 {
        private final ResourceLocation loc;
        private final ResourceLocation actualLoc;
        private final String path;
        private final ShaderPreprocessor.PreprocessorStage2Suspend vert;
        private final ShaderPreprocessor.PreprocessorStage2Suspend frag;
        private final ObjectList<String> mipmapEnabled;
        private final IntList renderTargets;

        private ProgramStage2(ResourceLocation loc, ResourceLocation actualLoc, String path, ShaderPreprocessor.PreprocessorStage2Suspend vert, ShaderPreprocessor.PreprocessorStage2Suspend frag, ObjectList<String> mipmapEnabled, IntList renderTargets) {
            this.loc = loc;
            this.actualLoc = actualLoc;
            this.path = path;
            this.vert = vert;
            this.frag = frag;
            this.mipmapEnabled = mipmapEnabled;
            this.renderTargets = renderTargets;
        }

        public ResourceLocation loc() {
            return this.loc;
        }

        public ResourceLocation actualLoc() {
            return this.actualLoc;
        }

        public String path() {
            return this.path;
        }

        public ShaderPreprocessor.PreprocessorStage2Suspend vert() {
            return this.vert;
        }

        public ShaderPreprocessor.PreprocessorStage2Suspend frag() {
            return this.frag;
        }

        public ObjectList<String> mipmapEnabled() {
            return this.mipmapEnabled;
        }

        public IntList renderTargets() {
            return this.renderTargets;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ProgramStage2 that = (ProgramStage2)obj;
            return Objects.equals(this.loc, that.loc) && Objects.equals(this.path, that.path) && Objects.equals(this.vert, that.vert) && Objects.equals(this.frag, that.frag) && Objects.equals(this.mipmapEnabled, that.mipmapEnabled) && Objects.equals(this.renderTargets, that.renderTargets);
        }

        public int hashCode() {
            return Objects.hash(this.loc, this.path, this.vert, this.frag, this.mipmapEnabled, this.renderTargets);
        }

        public String toString() {
            return "ProgramStage2[loc=" + this.loc + ", path=" + this.path + ", vert=" + this.vert + ", frag=" + this.frag + ", mipmapEnabled=" + this.mipmapEnabled + ", renderTargets=" + this.renderTargets + ']';
        }
    }

    private static final class ProgramCompiled {
        private final ResourceLocation loc;
        private final ResourceLocation actualLoc;
        private final String path;
        private final GLProgram program;
        private final ObjectList<String> mipmapEnabled;
        private final IntList renderTargets;

        private ProgramCompiled(ResourceLocation loc, ResourceLocation actualLoc, String path, GLProgram program, ObjectList<String> mipmapEnabled, IntList renderTargets) {
            this.loc = loc;
            this.actualLoc = actualLoc;
            this.path = path;
            this.program = program;
            this.mipmapEnabled = mipmapEnabled;
            this.renderTargets = renderTargets;
        }

        public ResourceLocation loc() {
            return this.loc;
        }

        public ResourceLocation actualLoc() {
            return this.actualLoc;
        }

        public String path() {
            return this.path;
        }

        public GLProgram program() {
            return this.program;
        }

        public ObjectList<String> mipmapEnabled() {
            return this.mipmapEnabled;
        }

        public IntList renderTargets() {
            return this.renderTargets;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ProgramCompiled that = (ProgramCompiled)obj;
            return Objects.equals(this.loc, that.loc) && Objects.equals(this.path, that.path) && Objects.equals(this.program, that.program) && Objects.equals(this.mipmapEnabled, that.mipmapEnabled) && Objects.equals(this.renderTargets, that.renderTargets);
        }

        public int hashCode() {
            return Objects.hash(this.loc, this.path, this.program, this.mipmapEnabled, this.renderTargets);
        }

        public String toString() {
            return "ProgramCompiled[loc=" + this.loc + ", path=" + this.path + ", program=" + this.program + ", mipmapEnabled=" + this.mipmapEnabled + ", renderTargets=" + this.renderTargets + ']';
        }
    }
}

