/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader.loader;

import com.ventooth.swansong.shader.loader.CompiledProgram;
import com.ventooth.swansong.shader.loader.IShaderPool;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import lombok.Generated;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class ShaderPool
implements IShaderPool {
    private volatile Object2ObjectMap<ResourceLocation, CompiledProgram> programs = new Object2ObjectOpenHashMap();
    private volatile ObjectSet<ResourceLocation> borrowed = new ObjectOpenHashSet();
    private volatile boolean dead = false;
    private volatile ObjectSet<String> disabled;

    public synchronized void insertShader(ResourceLocation loc, CompiledProgram program) {
        if (this.dead) {
            throw new IllegalStateException("Shader pool was deinitialized!");
        }
        boolean wasBorrowed = this.borrowed.remove((Object)loc);
        CompiledProgram old = (CompiledProgram)this.programs.put((Object)loc, (Object)program);
        if (old != null && !wasBorrowed) {
            old.program().glDeleteProgram();
        }
    }

    @Override
    @Nullable
    public synchronized CompiledProgram borrowShader(ResourceLocation loc, boolean essential) {
        if (this.dead) {
            throw new IllegalStateException("Shader pool was deinitialized!");
        }
        CompiledProgram shader = (CompiledProgram)this.programs.get((Object)loc);
        if (shader == null) {
            return null;
        }
        if (this.disabled != null && this.disabled.contains((Object)shader.path())) {
            return null;
        }
        this.borrowed.add((Object)loc);
        return shader;
    }

    public synchronized void setDisabled(ObjectSet<String> disabled) {
        this.disabled = disabled;
    }

    @Override
    public synchronized void close() {
        if (this.dead) {
            return;
        }
        this.dead = true;
        Object2ObjectMaps.fastForEach(this.programs, entry -> {
            if (this.borrowed.contains(entry.getKey())) {
                return;
            }
            ((CompiledProgram)entry.getValue()).program().glDeleteProgram();
        });
        this.programs = null;
        this.borrowed = null;
        this.disabled = null;
    }

    @Generated
    public ShaderPool() {
    }
}

