/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader.mappings;

import com.ventooth.swansong.Share;
import com.ventooth.swansong.resources.pack.ShaderPack;
import com.ventooth.swansong.shader.mappings.IntParsingUtils;
import com.ventooth.swansong.shader.mappings.MetaMapping;
import com.ventooth.swansong.shader.mappings.OrderedProperties;
import cpw.mods.fml.common.registry.GameRegistry;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.minecraft.block.Block;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockIDRemapper {
    private static final String PROP_FILE_NAME = "block.properties";
    @NotNull
    private final List<List<MetaMapping>> patterns;

    public int remap(int id, int meta) {
        if (id < 0 || id >= this.patterns.size()) {
            return id;
        }
        List<MetaMapping> mappings = this.patterns.get(id);
        if (mappings == null) {
            return id;
        }
        int mappingsSize = mappings.size();
        for (int i = 0; i < mappingsSize; ++i) {
            MetaMapping mapping = mappings.get(i);
            if (!mapping.matches(meta)) continue;
            return mapping.outputID();
        }
        return id;
    }

    @Nullable
    public static BlockIDRemapper createRemapper(@NotNull ShaderPack pack) {
        String path = pack.absolutize(null, PROP_FILE_NAME);
        try {
            if (!pack.has(path)) {
                return null;
            }
        }
        catch (IOException e) {
            return null;
        }
        OrderedProperties properties = new OrderedProperties();
        try (InputStream input = pack.get(path);){
            properties.load(input);
        }
        catch (IOException e) {
            return null;
        }
        ArrayList<List<MetaMapping>> mappings = null;
        for (Map.Entry<String, String> prop : properties) {
            int outputId;
            String key = prop.getKey();
            String value = prop.getValue();
            try {
                String blockIdStr = key.startsWith("block.") ? key.substring("block.".length()) : key;
                outputId = Integer.parseInt(blockIdStr);
            }
            catch (NumberFormatException ignored) {
                continue;
            }
            if (mappings == null) {
                mappings = new ArrayList<List<MetaMapping>>();
            }
            BlockIDRemapper.parsePatterns(outputId, value, mappings);
        }
        return mappings == null ? null : new BlockIDRemapper(mappings);
    }

    private static void parsePatterns(int outputId, @NotNull String property, ArrayList<List<MetaMapping>> result) {
        String[] parts;
        for (String part : parts = StringUtils.split((String)property, null)) {
            BlockIDRemapper.parsePattern(outputId, part, result);
        }
    }

    private static void parsePattern(int outputId, @NotNull String pattern, ArrayList<List<MetaMapping>> result) {
        int metaStartOffset;
        String block;
        String modId;
        String[] parts = StringUtils.split((String)pattern, (char)':');
        if (parts.length >= 2 && BlockIDRemapper.isBlockName(parts[1])) {
            modId = parts[0];
            block = parts[1];
            metaStartOffset = 2;
        } else {
            modId = "minecraft";
            block = parts[0];
            metaStartOffset = 1;
        }
        if (block.isEmpty()) {
            return;
        }
        IntList blocks = BlockIDRemapper.resolveBlocksIDs(modId, block);
        if (blocks == null) {
            return;
        }
        int blocksSize = blocks.size();
        for (int i = 0; i < blocksSize; ++i) {
            IntSet metas;
            int blockId = blocks.getInt(i);
            if (parts.length <= metaStartOffset) {
                metas = null;
            } else {
                metas = BlockIDRemapper.resolveBlockMetas(parts[metaStartOffset]);
                if (metas == null) continue;
            }
            result.ensureCapacity(blockId);
            while (blockId >= result.size()) {
                result.add(null);
            }
            List<MetaMapping> mappingsList = result.get(blockId);
            if (mappingsList == null) {
                mappingsList = new ArrayList<MetaMapping>();
                result.set(blockId, mappingsList);
            }
            if (MetaMapping.mergeInto(mappingsList, outputId, metas) != MetaMapping.Status.DuplicateWildcard) continue;
            Share.log.warn("Duplicate wildcard values for block ID: {}", new Object[]{blockId});
        }
    }

    private static boolean isBlockName(@NotNull String str) {
        return !str.isEmpty() && !Character.isDigit(str.charAt(0)) && !str.contains("=");
    }

    @Nullable
    private static IntList resolveBlocksIDs(@NotNull String modId, @NotNull String blockName) {
        if (!Character.isDigit(blockName.charAt(0))) {
            Block block = GameRegistry.findBlock((String)modId, (String)blockName);
            if (block == null) {
                return null;
            }
            return IntList.of((int)Block.func_149682_b((Block)block));
        }
        return IntParsingUtils.parseUnsignedIntMulti(blockName);
    }

    @Nullable
    private static IntSet resolveBlockMetas(@NotNull String str) {
        if (str.isEmpty() || !Character.isDigit(str.charAt(0))) {
            return null;
        }
        IntList theList = IntParsingUtils.parseUnsignedIntMulti(str);
        return theList == null ? null : (theList.size() < 8 ? new IntArraySet((IntCollection)theList) : new IntOpenHashSet((IntCollection)theList));
    }

    @Generated
    private BlockIDRemapper(@NotNull List<List<MetaMapping>> patterns) {
        if (patterns == null) {
            throw new NullPointerException("patterns is marked non-null but is null");
        }
        this.patterns = patterns;
    }
}

