/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader.mappings;

import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MetaMapping {
    private final int outputID;
    @Nullable
    private final IntSet pattern;

    public MetaMapping(int outputID, @Nullable IntSet pattern) {
        this.outputID = outputID;
        this.pattern = pattern;
    }

    public boolean matches(int meta) {
        if (this.pattern == null) {
            return true;
        }
        return this.pattern.contains(meta);
    }

    private boolean wildcard() {
        return this.pattern == null;
    }

    private static MetaMapping merge(MetaMapping a, @NotNull IntSet metas) {
        IntArraySet newSet;
        if (metas.isEmpty()) {
            return a;
        }
        int resLength = (a.pattern != null ? a.pattern.size() : 0) + metas.size();
        Object object = newSet = resLength <= 8 ? new IntArraySet() : new IntOpenHashSet();
        if (a.pattern != null) {
            newSet.addAll((IntCollection)a.pattern);
        }
        newSet.addAll((IntCollection)metas);
        return new MetaMapping(a.outputID, (IntSet)newSet);
    }

    public static Status mergeInto(List<MetaMapping> mappings, int outputID, @Nullable IntSet metas) {
        boolean wildcard = metas == null;
        boolean merged = false;
        int mappingsSize = mappings.size();
        for (int i = 0; i < mappingsSize; ++i) {
            MetaMapping oldMapping = mappings.get(i);
            boolean oldWildcard = oldMapping.wildcard();
            if (oldWildcard && wildcard) {
                return Status.DuplicateWildcard;
            }
            if (merged || oldMapping.outputID != outputID) continue;
            if (!oldWildcard) {
                if (wildcard) {
                    mappings.set(i, new MetaMapping(outputID, null));
                } else {
                    mappings.set(i, MetaMapping.merge(oldMapping, metas));
                }
            }
            merged = true;
        }
        if (merged) {
            return Status.Merged;
        }
        mappings.add(new MetaMapping(outputID, metas));
        return Status.Added;
    }

    public int outputID() {
        return this.outputID;
    }

    @Nullable
    public IntSet pattern() {
        return this.pattern;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MetaMapping that = (MetaMapping)obj;
        return this.outputID == that.outputID && Objects.equals(this.pattern, that.pattern);
    }

    public int hashCode() {
        return Objects.hash(this.outputID, this.pattern);
    }

    public String toString() {
        return "MetaMapping[outputID=" + this.outputID + ", pattern=" + this.pattern + ']';
    }

    public static enum Status {
        Added,
        Merged,
        DuplicateWildcard;

    }
}

