/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader.preprocessor;

import java.util.Objects;

public final class TaggedLine {
    private final int file;
    private final int line;
    private final String text;
    private final boolean lineBreak;
    private final Tag tag;

    public TaggedLine(int file, int line, String text, boolean lineBreak, Tag tag) {
        this.file = file;
        this.line = line;
        this.text = text;
        this.lineBreak = lineBreak;
        this.tag = tag;
    }

    public TaggedLine withTag(Tag tag) {
        return new TaggedLine(this.file, this.line, this.text, this.lineBreak, tag);
    }

    public TaggedLine withText(String text) {
        return new TaggedLine(this.file, this.line, text, this.lineBreak, this.tag);
    }

    public TaggedLine withText(String text, boolean lineBreak) {
        return new TaggedLine(this.file, this.line, text, lineBreak, this.tag);
    }

    public TaggedLine withTextAndTag(String text, Tag tag) {
        return new TaggedLine(this.file, this.line, text, this.lineBreak, tag);
    }

    public TaggedLine withTextAndTag(String text, boolean lineBreak, Tag tag) {
        return new TaggedLine(this.file, this.line, text, lineBreak, tag);
    }

    public int file() {
        return this.file;
    }

    public int line() {
        return this.line;
    }

    public String text() {
        return this.text;
    }

    public boolean lineBreak() {
        return this.lineBreak;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TaggedLine that = (TaggedLine)obj;
        return this.file == that.file && this.line == that.line && Objects.equals(this.text, that.text) && this.lineBreak == that.lineBreak && Objects.equals((Object)this.tag, (Object)that.tag);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.file, this.line, this.text, this.lineBreak, this.tag});
    }

    public String toString() {
        return "TaggedLine[file=" + this.file + ", line=" + this.line + ", text=" + this.text + ", lineBreak=" + this.lineBreak + ", tag=" + (Object)((Object)this.tag) + ']';
    }

    public static enum Tag {
        Standard,
        MultilineComment,
        Macro;

    }
}

