/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader.preprocessor.macro;

import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public interface InterpreterValue {
    public boolean asBool();

    public static final class DoubleValue
    implements InterpreterValue {
        private final double value;

        public DoubleValue(double value) {
            this.value = value;
        }

        public String toString() {
            return Double.toString(this.value);
        }

        @Override
        public boolean asBool() {
            return this.value != 0.0;
        }

        public double value() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            DoubleValue that = (DoubleValue)obj;
            return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(that.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }

    public static final class IntValue
    implements InterpreterValue {
        private final int value;

        public IntValue(int value) {
            this.value = value;
        }

        public String toString() {
            return Integer.toString(this.value);
        }

        @Override
        public boolean asBool() {
            return this.value != 0;
        }

        public int value() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            IntValue that = (IntValue)obj;
            return this.value == that.value;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

