/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader.shaderobjects;

import com.ventooth.swansong.Share;
import com.ventooth.swansong.gl.GLProgram;
import com.ventooth.swansong.shader.loader.CompiledProgram;
import com.ventooth.swansong.shader.uniform.Uniform;
import com.ventooth.swansong.shader.uniform.UniformGetterDanglingWires;
import com.ventooth.swansong.sufrace.Framebuffer;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.lwjgl.opengl.GL20;

public abstract class ManagedShader {
    protected static final Logger log = Share.getLogger();
    private static final IntList DEFAULT_RENDER_TARGETS = IntLists.singleton((int)0);
    protected final ResourceLocation loc;
    protected final ResourceLocation actualLoc;
    protected final String srcPath;
    protected GLProgram program;
    protected final IntList renderTargets;
    @Nullable
    public Framebuffer framebuffer;
    private @Unmodifiable Int2ObjectMap<@NotNull Uniform<?>> uniforms;
    private Int2ObjectArrayMap<@NotNull Uniform<?>> uniformsDirect;

    public ManagedShader(ResourceLocation loc, CompiledProgram prog) {
        this.loc = loc;
        this.actualLoc = prog.actualShaderType();
        this.srcPath = prog.path();
        this.program = prog.program();
        this.uniforms = Int2ObjectMaps.emptyMap();
        IntList tempRenderTargets = prog.renderTargets();
        if (tempRenderTargets == null) {
            tempRenderTargets = DEFAULT_RENDER_TARGETS;
        }
        this.renderTargets = tempRenderTargets;
    }

    public void init() {
        this.program.glUseProgram();
        Int2ObjectArrayMap uniforms = new Int2ObjectArrayMap();
        if (this.isFallback()) {
            log.debug("Initializing: {}, using fallback: {}", new Object[]{this.loc, this.actualLoc});
        } else {
            log.debug("Initializing: {}", new Object[]{this.loc});
        }
        int uniformCount = this.program.glGetProgramActiveUniforms();
        log.debug("Expecting {} uniforms", new Object[]{uniformCount});
        if (uniformCount != 0) {
            block0: for (int i = 0; i < uniformCount; ++i) {
                String uniformName = this.program.glGetActiveUniform(i);
                if (uniformName == null || uniformName.isEmpty()) continue;
                if (uniformName.startsWith("gl_")) {
                    log.debug("Skipping builtin: {}", new Object[]{uniformName});
                    continue;
                }
                int index = this.program.glGetUniformLocation(uniformName);
                List<Uniform<?>> relevantUniforms = this.relevantUniforms();
                for (Uniform<?> relevantUniform : relevantUniforms) {
                    if (!relevantUniform.name().equals(uniformName)) continue;
                    uniforms.put(index, relevantUniform);
                    log.debug("Binding relevant uniform: {} at index: {}", new Object[]{uniformName, index});
                    continue block0;
                }
                List<Uniform<?>> customUniforms = UniformGetterDanglingWires.customUniforms;
                if (customUniforms != null) {
                    for (Uniform<?> customUniform : customUniforms) {
                        if (!customUniform.name().equals(uniformName)) continue;
                        uniforms.put(index, customUniform);
                        log.debug("Binding custom uniform: {} at index: {}", new Object[]{uniformName, index});
                        continue block0;
                    }
                }
                log.debug("Unknown uniform: {} at index: {}", new Object[]{uniformName, index});
            }
        } else {
            log.debug("Shader {} initialized with no uniforms!", new Object[]{this.actualLoc});
        }
        this.uniformsDirect = uniforms;
        this.uniforms = Int2ObjectMaps.unmodifiable((Int2ObjectMap)uniforms);
        GL20.glUseProgram((int)0);
    }

    public Int2ObjectMap<Uniform<?>> getUniforms() {
        return this.uniforms;
    }

    public void deinit() {
        if (this.framebuffer != null) {
            this.framebuffer.deinit();
            this.framebuffer = null;
        }
        this.program.glDeleteProgram();
        this.program = null;
        this.uniforms = null;
        this.uniformsDirect = null;
    }

    public boolean isFallback() {
        return !Objects.equals(this.actualLoc, this.loc);
    }

    public void begin() {
        if (this.framebuffer != null) {
            this.framebuffer.bindDraw();
        }
        this.program.glUseProgram();
        ObjectIterator iter = this.uniformsDirect.int2ObjectEntrySet().fastIterator();
        while (iter.hasNext()) {
            Int2ObjectMap.Entry uniform = (Int2ObjectMap.Entry)iter.next();
            ((Uniform)uniform.getValue()).load(uniform.getIntKey());
        }
    }

    public void end(boolean unbind) {
        for (Uniform uniform : this.uniformsDirect.values()) {
            uniform.reset();
        }
        if (unbind) {
            GL20.glUseProgram((int)0);
        }
    }

    protected abstract List<Uniform<?>> relevantUniforms();

    @Generated
    public ResourceLocation loc() {
        return this.loc;
    }

    @Generated
    public String srcPath() {
        return this.srcPath;
    }

    @Generated
    public IntList renderTargets() {
        return this.renderTargets;
    }
}

