/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader.texbuf;

import com.ventooth.swansong.Share;
import com.ventooth.swansong.debug.GLDebugGroups;
import com.ventooth.swansong.mixin.interfaces.ShaderGameSettings;
import com.ventooth.swansong.shader.BufferNameUtil;
import com.ventooth.swansong.shader.CompositeTextureData;
import com.ventooth.swansong.shader.DrawBuffers;
import com.ventooth.swansong.shader.Report;
import com.ventooth.swansong.shader.ShaderEngine;
import com.ventooth.swansong.shader.ShadersCompositeMesh;
import com.ventooth.swansong.shader.shaderobjects.CompositeShader;
import com.ventooth.swansong.shader.texbuf.BufferConfig;
import com.ventooth.swansong.shader.texbuf.ColorBuffers;
import com.ventooth.swansong.shader.uniform.Uniform;
import com.ventooth.swansong.sufrace.Framebuffer;
import com.ventooth.swansong.sufrace.FramebufferAttachment;
import com.ventooth.swansong.sufrace.Texture2D;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositePipeline
implements Runnable {
    private final ObjectList<Runnable> steps;
    @Nullable
    private final ColorBuffers aux;

    public static CompositePipeline buildPipelineFinal(@NotNull DrawBuffers buffers, @NotNull ObjectList<CompositeShader> shaders, @NotNull Map<CompositeTextureData, Texture2D> customTextures, @Nullable Report report) {
        Report.CompositePipelineInfo info = report == null ? null : report.pipelines.computeIfAbsent("final", n -> new Report.CompositePipelineInfo());
        ObjectArrayList steps = new ObjectArrayList();
        BitSet inputMask = new BitSet();
        for (CompositeShader shader : shaders) {
            inputMask.clear();
            EnumMap<CompositeTextureData, Texture2D> inputTex = CompositePipeline.getInputTexFinal(buffers, customTextures, shader, inputMask);
            ObjectArrayList<Texture2D> mipInputs = CompositePipeline.getMipInputs(shader, inputTex);
            if (!mipInputs.isEmpty()) {
                steps.add((Object)new MipmapStep((ObjectList<Texture2D>)mipInputs));
            }
            if (info != null) {
                CompositePipeline.recordShaderIOInfo(shader, info, mipInputs, inputTex, null);
            }
            steps.add((Object)new FinalStep(Collections.unmodifiableMap(inputTex), shader));
        }
        return new CompositePipeline((ObjectList<Runnable>)ObjectLists.unmodifiable((ObjectList)steps), null);
    }

    public static CompositePipeline buildPipeline(String name, String auxPrefix, @NotNull Map<CompositeTextureData, BufferConfig> gBufferConfigs, @NotNull Map<CompositeTextureData, Texture2D> customTextures, @NotNull DrawBuffers buffers, @NotNull ObjectList<CompositeShader> shaders, int width, int height, @Nullable Report report) {
        Report.CompositePipelineInfo info = report == null ? null : report.pipelines.computeIfAbsent(name, n -> new Report.CompositePipelineInfo());
        ColorBuffers aux = CompositePipeline.genAux(auxPrefix, gBufferConfigs, shaders, width, height);
        if (info != null) {
            for (Texture2D tex : aux.getAllTextures().values()) {
                info.auxTextures.add(new Report.TextureInfo(tex));
            }
        }
        ObjectArrayList steps = new ObjectArrayList();
        BitSet auxTex = new BitSet();
        BitSet inputMask = new BitSet();
        int shadersSize = shaders.size();
        for (int i = 0; i < shadersSize; ++i) {
            ObjectArrayList<Texture2D> mipInputs;
            CompositeShader shader = (CompositeShader)shaders.get(i);
            inputMask.clear();
            EnumMap<CompositeTextureData, Texture2D> inputTex = CompositePipeline.getInputTex(buffers, customTextures, shader, inputMask, auxTex, aux);
            EnumMap<FramebufferAttachment, Texture2D> outputTex = CompositePipeline.getOutputTex(buffers, shader, inputMask, auxTex, aux);
            if (shader.framebuffer != null) {
                shader.framebuffer.deinit();
                shader.framebuffer = null;
            }
            if (!(mipInputs = CompositePipeline.getMipInputs(shader, inputTex)).isEmpty()) {
                steps.add((Object)new MipmapStep((ObjectList<Texture2D>)mipInputs));
            }
            if (info != null) {
                CompositePipeline.recordShaderIOInfo(shader, info, mipInputs, inputTex, outputTex);
            }
            shader.framebuffer = Framebuffer.create(name + i, Collections.unmodifiableMap(outputTex));
            steps.add((Object)new CompositeStep(Collections.unmodifiableMap(inputTex), shader));
        }
        CompositePipeline.genAuxPostBlit(buffers, auxTex, info, aux, (ObjectArrayList<Runnable>)steps);
        return new CompositePipeline((ObjectList<Runnable>)ObjectLists.unmodifiable((ObjectList)steps), aux);
    }

    private static void recordShaderIOInfo(CompositeShader shader, Report.CompositePipelineInfo info, ObjectArrayList<Texture2D> mipInputs, EnumMap<CompositeTextureData, Texture2D> inputTex, @Nullable EnumMap<FramebufferAttachment, Texture2D> outputTex) {
        Report.CompositeStageInfo stage = new Report.CompositeStageInfo(shader.srcPath());
        info.stages.add(stage);
        for (Texture2D mipmap : mipInputs) {
            stage.mipmaps.add((Object)mipmap.name());
        }
        for (Map.Entry input : inputTex.entrySet()) {
            stage.inputs.put((CompositeTextureData)((Object)input.getKey()), ((Texture2D)input.getValue()).name());
        }
        if (outputTex != null) {
            for (Map.Entry entry : outputTex.entrySet()) {
                stage.outputs.put((FramebufferAttachment)((Object)entry.getKey()), ((Texture2D)entry.getValue()).name());
            }
        }
    }

    private static void genAuxPostBlit(@NotNull DrawBuffers buffers, BitSet auxTex, Report.CompositePipelineInfo info, ColorBuffers aux, ObjectArrayList<Runnable> steps) {
        int maxAux = auxTex.length();
        if (maxAux > 0) {
            Int2ObjectArrayMap src = new Int2ObjectArrayMap();
            Int2ObjectArrayMap dst = new Int2ObjectArrayMap();
            Report.CompositePostBlit pb = info == null ? null : new Report.CompositePostBlit();
            for (int i = 0; i < maxAux; ++i) {
                if (!auxTex.get(i)) continue;
                CompositeTextureData id = DrawBuffers.textureFromColorTexIndex(i);
                Texture2D a = aux.get(id);
                Texture2D g = buffers.getByID(id);
                if (a == null || g == null) continue;
                if (pb != null) {
                    pb.from.add(a.name());
                    pb.to.add(g.name());
                }
                src.put(i, (Object)a);
                dst.put(i, (Object)g);
            }
            if (pb != null) {
                info.postBlit = pb;
            }
            steps.add((Object)new BlitStep((Int2ObjectMap<Texture2D>)Int2ObjectMaps.unmodifiable((Int2ObjectMap)src), (Int2ObjectMap<Texture2D>)Int2ObjectMaps.unmodifiable((Int2ObjectMap)dst)));
        }
    }

    @NotNull
    private static ObjectArrayList<Texture2D> getMipInputs(CompositeShader shader, EnumMap<CompositeTextureData, Texture2D> inputTex) {
        ObjectArrayList mipInputs = new ObjectArrayList();
        for (CompositeTextureData mip : shader.mipmapEnabled()) {
            Texture2D mipInput = inputTex.get((Object)mip);
            if (mipInput == null) {
                Share.log.debug("Failed to setup composite mipmap: [{}->colortex{}]", new Object[]{shader.loc(), mip});
                continue;
            }
            mipInputs.add((Object)mipInput);
        }
        return mipInputs;
    }

    @NotNull
    private static EnumMap<FramebufferAttachment, Texture2D> getOutputTex(@NotNull DrawBuffers buffers, CompositeShader shader, BitSet inputMask, BitSet auxTex, ColorBuffers aux) {
        ObjectArrayList outputs = new ObjectArrayList();
        IntIterator iter = shader.renderTargets().intIterator();
        while (iter.hasNext()) {
            int index = iter.nextInt();
            CompositeTextureData id = DrawBuffers.textureFromColorTexIndex(index);
            outputs.add((Object)id);
        }
        EnumMap<FramebufferAttachment, Texture2D> outputTex = new EnumMap<FramebufferAttachment, Texture2D>(FramebufferAttachment.class);
        int i = 0;
        for (CompositeTextureData output : outputs) {
            int auxIndex = DrawBuffers.colorTexIndexFromTexture(output);
            assert (auxIndex >= 0);
            boolean outIntoAux = inputMask.get(output.gpuIndex()) && !auxTex.get(auxIndex);
            auxTex.set(auxIndex, outIntoAux);
            Texture2D tex = outIntoAux ? aux.get(output) : buffers.getByID(output);
            FramebufferAttachment att = FramebufferAttachment.fromColorIndex(i);
            ++i;
            if (att == null) continue;
            outputTex.put(att, tex);
        }
        return outputTex;
    }

    @NotNull
    private static EnumMap<CompositeTextureData, Texture2D> getInputTex(@NotNull DrawBuffers buffers, @NotNull Map<CompositeTextureData, Texture2D> customTextures, CompositeShader shader, BitSet inputMask, BitSet auxTex, ColorBuffers aux) {
        ObjectArrayList<CompositeTextureData> inputs = CompositePipeline.scanInputs(shader, inputMask);
        EnumMap<CompositeTextureData, Texture2D> inputTex = new EnumMap<CompositeTextureData, Texture2D>(CompositeTextureData.class);
        for (CompositeTextureData input : inputs) {
            Texture2D tex = customTextures.get((Object)input);
            if (tex == null) {
                int auxIndex = DrawBuffers.colorTexIndexFromTexture(input);
                tex = auxIndex >= 0 && auxTex.get(auxIndex) ? aux.get(input) : buffers.getByID(input);
            }
            if (tex == null) continue;
            inputTex.put(input, tex);
        }
        return inputTex;
    }

    @NotNull
    private static EnumMap<CompositeTextureData, Texture2D> getInputTexFinal(@NotNull DrawBuffers buffers, @NotNull Map<CompositeTextureData, Texture2D> customTextures, CompositeShader shader, BitSet inputMask) {
        ObjectArrayList<CompositeTextureData> inputs = CompositePipeline.scanInputs(shader, inputMask);
        EnumMap<CompositeTextureData, Texture2D> inputTex = new EnumMap<CompositeTextureData, Texture2D>(CompositeTextureData.class);
        for (CompositeTextureData input : inputs) {
            Texture2D tex = customTextures.get((Object)input);
            if (tex == null) {
                tex = buffers.getByID(input);
            }
            if (tex == null) continue;
            inputTex.put(input, tex);
        }
        return inputTex;
    }

    @NotNull
    private static ObjectArrayList<CompositeTextureData> scanInputs(CompositeShader shader, BitSet inputMask) {
        ObjectArrayList inputs = new ObjectArrayList();
        for (Uniform uniform : shader.getUniforms().values()) {
            CompositeTextureData index = BufferNameUtil.gbufferIndexFromName(uniform.name());
            if (index == null) continue;
            int auxIndex = DrawBuffers.colorTexIndexFromTexture(index);
            if (auxIndex >= 0) {
                inputMask.set(index.gpuIndex());
            }
            inputs.add((Object)index);
        }
        return inputs;
    }

    @Override
    public void run() {
        for (Runnable step : this.steps) {
            step.run();
        }
    }

    public void resize(int width, int height) {
        if (this.aux != null) {
            this.aux.resize(width, height);
        }
    }

    public void deinit() {
        if (this.aux != null) {
            this.aux.deinit();
        }
    }

    private static ColorBuffers genAux(String prefix, Map<CompositeTextureData, BufferConfig> gBufferConfigs, ObjectList<CompositeShader> shaders, int width, int height) {
        BitSet auxNeeded = new BitSet();
        BitSet gbufferUniforms = new BitSet();
        for (CompositeShader shader : shaders) {
            CompositeTextureData id;
            gbufferUniforms.clear();
            for (Uniform uniform : shader.getUniforms().values()) {
                id = BufferNameUtil.gbufferIndexFromName(uniform.name());
                if (id == null) continue;
                gbufferUniforms.set(id.gpuIndex());
            }
            IntIterator iter = shader.renderTargets().intIterator();
            while (iter.hasNext()) {
                int index = iter.nextInt();
                id = DrawBuffers.textureFromColorTexIndex(index);
                if (id == null || !gbufferUniforms.get(id.gpuIndex())) continue;
                auxNeeded.set(index);
            }
        }
        EnumMap<CompositeTextureData, BufferConfig> configs = new EnumMap<CompositeTextureData, BufferConfig>(CompositeTextureData.class);
        for (Map.Entry<CompositeTextureData, BufferConfig> entry : gBufferConfigs.entrySet()) {
            CompositeTextureData id = entry.getKey();
            int index = DrawBuffers.colorTexIndexFromTexture(id);
            if (!auxNeeded.get(index)) continue;
            configs.put(id, entry.getValue());
        }
        return new ColorBuffers(configs, prefix, width, height);
    }

    @Generated
    private CompositePipeline(ObjectList<Runnable> steps, @Nullable ColorBuffers aux) {
        this.steps = steps;
        this.aux = aux;
    }

    private static class MipmapStep
    implements Runnable {
        private final ObjectList<Texture2D> mipInputs;

        @Override
        public void run() {
            GLDebugGroups.push(GLDebugGroups.GEN_COMPOSITE_MIPS);
            ShaderEngine.genMipmaps(this.mipInputs);
            GLDebugGroups.pop(GLDebugGroups.GEN_COMPOSITE_MIPS);
        }

        @Generated
        public MipmapStep(ObjectList<Texture2D> mipInputs) {
            this.mipInputs = mipInputs;
        }
    }

    private static class FinalStep
    implements Runnable {
        private final Map<CompositeTextureData, Texture2D> inputs;
        private final CompositeShader shader;

        @Override
        public void run() {
            GLDebugGroups.RENDER_COMPOSITE_FINAL.push();
            ShaderEngine.useCompositeShader(this.shader);
            ShaderEngine.bindCompositeTextures(this.inputs);
            float anaglyph = ((ShaderGameSettings)Minecraft.func_71410_x().field_71474_y).swan$anaglyph();
            GLDebugGroups.RENDER_COMPOSITE_FINAL_DRAW.push();
            if (anaglyph != 0.0f) {
                ShadersCompositeMesh.drawWithAnaglyphField(EntityRenderer.field_78515_b);
            } else {
                ShadersCompositeMesh.drawWithColor();
            }
            GLDebugGroups.RENDER_COMPOSITE_FINAL_DRAW.pop();
            GLDebugGroups.RENDER_COMPOSITE_FINAL.pop();
        }

        @Generated
        public FinalStep(Map<CompositeTextureData, Texture2D> inputs, CompositeShader shader) {
            this.inputs = inputs;
            this.shader = shader;
        }
    }

    private static class CompositeStep
    implements Runnable {
        private final Map<CompositeTextureData, Texture2D> inputs;
        private final CompositeShader shader;

        @Override
        public void run() {
            ShaderEngine.useCompositeShader(this.shader);
            ShaderEngine.bindCompositeTextures(this.inputs);
            GLDebugGroups.RENDER_COMPOSITE_DRAW.push();
            ShadersCompositeMesh.drawWithColor();
            GLDebugGroups.RENDER_COMPOSITE_DRAW.pop();
        }

        @Generated
        public CompositeStep(Map<CompositeTextureData, Texture2D> inputs, CompositeShader shader) {
            this.inputs = inputs;
            this.shader = shader;
        }
    }

    private static class BlitStep
    implements Runnable {
        private final Int2ObjectMap<Texture2D> src;
        private final Int2ObjectMap<Texture2D> dst;

        @Override
        public void run() {
            ShaderEngine.blitColors(this.src, this.dst);
        }

        @Generated
        public BlitStep(Int2ObjectMap<Texture2D> src, Int2ObjectMap<Texture2D> dst) {
            this.src = src;
            this.dst = dst;
        }
    }
}

