/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader.uniform;

import java.nio.FloatBuffer;
import java.util.function.Supplier;
import lombok.Generated;
import org.joml.Matrix4dc;
import org.joml.Vector2dc;
import org.joml.Vector2ic;
import org.joml.Vector3dc;
import org.joml.Vector4dc;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;

public abstract class Uniform<T> {
    protected final String name;
    protected int lastLocation = -1;
    private static final FloatBuffer tempFloatBuf = BufferUtils.createFloatBuffer((int)16);

    public void update() {
        if (this.lastLocation != -1) {
            this.load(this.lastLocation);
        }
    }

    public abstract T value();

    public abstract void load(int var1);

    public void reset() {
        this.lastLocation = -1;
    }

    public static void set(int location, boolean v) {
        GL20.glUniform1i((int)location, (int)(v ? 1 : 0));
    }

    public static void set(int location, int v) {
        GL20.glUniform1i((int)location, (int)v);
    }

    public static void set(int location, Vector2ic v) {
        GL20.glUniform2i((int)location, (int)v.x(), (int)v.y());
    }

    public static void set(int location, float v) {
        GL20.glUniform1f((int)location, (float)v);
    }

    public static void set(int location, double v) {
        GL20.glUniform1f((int)location, (float)((float)v));
    }

    public static void set(int location, Vector3dc v) {
        GL20.glUniform3f((int)location, (float)((float)v.x()), (float)((float)v.y()), (float)((float)v.z()));
    }

    public static void set(int location, Vector2dc v) {
        GL20.glUniform2f((int)location, (float)((float)v.x()), (float)((float)v.y()));
    }

    public static void set(int location, Vector4dc v) {
        GL20.glUniform4f((int)location, (float)((float)v.x()), (float)((float)v.y()), (float)((float)v.z()), (float)((float)v.w()));
    }

    public static void set(int location, Matrix4dc v) {
        v.get(tempFloatBuf);
        GL20.glUniformMatrix4((int)location, (boolean)false, (FloatBuffer)tempFloatBuf);
    }

    @Generated
    private Uniform(String name) {
        this.name = name;
    }

    @Generated
    public String name() {
        return this.name;
    }

    public static class Of<T>
    extends Uniform<T> {
        private final Supplier<T> getter;
        private final Setter<T> setter;

        public Of(String name, Supplier<T> getter, Setter<T> setter) {
            super(name);
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public T value() {
            return this.getter.get();
        }

        @Override
        public void load(int location) {
            T value = this.value();
            this.setter.set(location, value);
            this.lastLocation = location;
        }
    }

    public static class OfDouble
    extends Uniform<Double> {
        private final DoubleSupplier getter;
        private final DoubleSetter setter;

        public OfDouble(String name, DoubleSupplier getter, DoubleSetter setter) {
            super(name);
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        @Deprecated
        public Double value() {
            return this.getter.getDouble();
        }

        public double doubleValue() {
            return this.getter.getDouble();
        }

        @Override
        public void load(int location) {
            double value = this.doubleValue();
            this.setter.setDouble(location, value);
            this.lastLocation = location;
        }
    }

    public static class OfFloat
    extends Uniform<Float> {
        private final FloatSupplier getter;
        private final FloatSetter setter;

        public OfFloat(String name, FloatSupplier getter, FloatSetter setter) {
            super(name);
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        @Deprecated
        public Float value() {
            return Float.valueOf(this.getter.getFloat());
        }

        public float floatValue() {
            return this.getter.getFloat();
        }

        @Override
        public void load(int location) {
            float value = this.floatValue();
            this.setter.setFloat(location, value);
            this.lastLocation = location;
        }
    }

    public static class OfInt
    extends Uniform<Integer> {
        private final IntSupplier getter;
        private final IntSetter setter;

        public OfInt(String name, IntSupplier getter, IntSetter setter) {
            super(name);
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        @Deprecated
        public Integer value() {
            return this.getter.getInt();
        }

        public int intValue() {
            return this.getter.getInt();
        }

        @Override
        public void load(int location) {
            int value = this.intValue();
            this.setter.setInt(location, value);
            this.lastLocation = location;
        }
    }

    public static class OfBoolean
    extends Uniform<Boolean> {
        private final BooleanSupplier getter;
        private final BooleanSetter setter;

        public OfBoolean(String name, BooleanSupplier getter, BooleanSetter setter) {
            super(name);
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        @Deprecated
        public Boolean value() {
            return this.getter.getBoolean();
        }

        public boolean booleanValue() {
            return this.getter.getBoolean();
        }

        @Override
        public void load(int location) {
            boolean value = this.booleanValue();
            this.setter.setBoolean(location, value);
            this.lastLocation = location;
        }
    }

    @FunctionalInterface
    public static interface DoubleSupplier
    extends Supplier<Double> {
        @Override
        @Deprecated
        default public Double get() {
            return this.getDouble();
        }

        public double getDouble();
    }

    @FunctionalInterface
    public static interface FloatSupplier
    extends Supplier<Float> {
        @Override
        @Deprecated
        default public Float get() {
            return Float.valueOf(this.getFloat());
        }

        public float getFloat();
    }

    @FunctionalInterface
    public static interface IntSupplier
    extends Supplier<Integer> {
        @Override
        @Deprecated
        default public Integer get() {
            return this.getInt();
        }

        public int getInt();
    }

    @FunctionalInterface
    public static interface BooleanSupplier
    extends Supplier<Boolean> {
        @Override
        @Deprecated
        default public Boolean get() {
            return this.getBoolean();
        }

        public boolean getBoolean();
    }

    @FunctionalInterface
    public static interface DoubleSetter
    extends Setter<Double> {
        @Override
        @Deprecated
        default public void set(int location, Double value) {
            this.setDouble(location, value);
        }

        public void setDouble(int var1, double var2);
    }

    @FunctionalInterface
    public static interface FloatSetter
    extends Setter<Float> {
        @Override
        @Deprecated
        default public void set(int location, Float value) {
            this.setFloat(location, value.floatValue());
        }

        public void setFloat(int var1, float var2);
    }

    @FunctionalInterface
    public static interface IntSetter
    extends Setter<Integer> {
        @Override
        @Deprecated
        default public void set(int location, Integer value) {
            this.setInt(location, value);
        }

        public void setInt(int var1, int var2);
    }

    @FunctionalInterface
    public static interface BooleanSetter
    extends Setter<Boolean> {
        @Override
        @Deprecated
        default public void set(int location, Boolean value) {
            this.setBoolean(location, value);
        }

        public void setBoolean(int var1, boolean var2);
    }

    @FunctionalInterface
    public static interface Setter<T> {
        public void set(int var1, T var2);
    }
}

