/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.sufrace;

import com.ventooth.swansong.Share;
import com.ventooth.swansong.gl.GLTexture;
import com.ventooth.swansong.shader.preprocessor.FSProvider;
import com.ventooth.swansong.sufrace.Texture2D;
import com.ventooth.swansong.sufrace.TextureMeta;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public final class CustomTexture2D
extends Texture2D {
    private static final Logger log = Share.getLogger();

    private CustomTexture2D(String name, GLTexture texture, int internalFormat, int width, int height) {
        super(name, texture, internalFormat, width, height);
    }

    @Nullable
    public static CustomTexture2D load(FSProvider fs, String path) {
        TextureMeta meta;
        IntBuffer buf;
        int height;
        int width;
        try {
            BufferedImage img = ImageIO.read(fs.get(path));
            width = img.getWidth();
            height = img.getHeight();
            int size = width * height;
            int[] pixels = new int[size];
            img.getRGB(0, 0, width, height, pixels, 0, width);
            buf = BufferUtils.createIntBuffer((int)(width * height));
            buf.put(pixels);
            buf.flip();
        }
        catch (Exception e) {
            log.warn("Failed to load custom texture", (Throwable)e);
            return null;
        }
        try {
            String str = IOUtils.toString((InputStream)fs.get(path + ".mcmeta"));
            meta = TextureMeta.read(str);
            if (meta == null) {
                log.debug("Texture meta is null");
                meta = new TextureMeta(false, false);
            }
        }
        catch (Exception e) {
            meta = new TextureMeta(false, false);
            log.warn("Failed to load texture meta", (Throwable)e);
        }
        GLTexture texture = new GLTexture();
        texture.glGenTextures();
        texture.glBindTexture2D();
        CustomTexture2D.setParams2D(meta.clamp(), meta.blur());
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)32993, (int)33639, (IntBuffer)buf);
        return new CustomTexture2D("custom:" + path, texture, 6408, width, height);
    }
}

