/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.sufrace;

import com.ventooth.swansong.debug.DebugMarker;
import com.ventooth.swansong.debug.GLObjectLabel;
import com.ventooth.swansong.gl.GLFramebuffer;
import com.ventooth.swansong.sufrace.FramebufferAttachment;
import com.ventooth.swansong.sufrace.Texture2D;
import java.nio.IntBuffer;
import java.util.Map;
import lombok.Generated;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class Framebuffer {
    protected final String name;
    public final GLFramebuffer framebuffer;
    boolean isManaged = true;

    public Framebuffer(String name, GLFramebuffer framebuffer) {
        this.name = name;
        this.framebuffer = framebuffer;
        if (GLObjectLabel.isEnabled() && name != null && !name.isEmpty()) {
            GLObjectLabel.set(framebuffer, name);
        }
    }

    public static Framebuffer wrap(String name, int glName) {
        GLFramebuffer framebuffer = new GLFramebuffer();
        framebuffer.glName = glName;
        Framebuffer fb = new Framebuffer(name, framebuffer);
        fb.isManaged = false;
        return fb;
    }

    public static Framebuffer create(String name, boolean depthOnly) {
        GLFramebuffer framebuffer = new GLFramebuffer();
        framebuffer.glGenFramebuffers();
        framebuffer.glBindFramebuffer();
        if (depthOnly) {
            GL20.glDrawBuffers((int)0);
        } else {
            GL20.glDrawBuffers((int)36064);
        }
        return new Framebuffer(name, framebuffer);
    }

    public static Framebuffer create(String name, Texture2D colorTex) {
        GLFramebuffer framebuffer = new GLFramebuffer();
        framebuffer.glGenFramebuffers();
        framebuffer.glBindFramebuffer();
        colorTex.attachToFramebufferColor(36064);
        GL20.glDrawBuffers((int)36064);
        GL30.glBindFramebuffer((int)36160, (int)0);
        return new Framebuffer(name, framebuffer);
    }

    public static Framebuffer create(String name, Texture2D colorTex, Texture2D depthTex) {
        GLFramebuffer framebuffer = new GLFramebuffer();
        framebuffer.glGenFramebuffers();
        framebuffer.glBindFramebuffer();
        depthTex.attachToFramebufferDepth();
        colorTex.attachToFramebufferColor(36064);
        GL20.glDrawBuffers((int)36064);
        GL30.glBindFramebuffer((int)36160, (int)0);
        return new Framebuffer(name, framebuffer);
    }

    private static void attachColorAndSetDrawBuffers(Map<FramebufferAttachment, Texture2D> colorTexList) {
        int size = colorTexList.size();
        IntBuffer drawBuffers = BufferUtils.createIntBuffer((int)size);
        for (Map.Entry<FramebufferAttachment, Texture2D> entry : colorTexList.entrySet()) {
            int attachment = entry.getKey().toGLConstant();
            Texture2D tex = entry.getValue();
            tex.attachToFramebufferColor(attachment);
            drawBuffers.put(attachment);
        }
        drawBuffers.flip();
        GL20.glDrawBuffers((IntBuffer)drawBuffers);
    }

    public static Framebuffer create(String name, Map<FramebufferAttachment, Texture2D> colorTexList, Texture2D depthTex) {
        GLFramebuffer framebuffer = new GLFramebuffer();
        framebuffer.glGenFramebuffers();
        framebuffer.glBindFramebuffer();
        depthTex.attachToFramebufferDepth();
        Framebuffer.attachColorAndSetDrawBuffers(colorTexList);
        GL30.glBindFramebuffer((int)36160, (int)0);
        return new Framebuffer(name, framebuffer);
    }

    public static Framebuffer create(String name, Map<FramebufferAttachment, Texture2D> colorTexList) {
        GLFramebuffer framebuffer = new GLFramebuffer();
        framebuffer.glGenFramebuffers();
        framebuffer.glBindFramebuffer();
        Framebuffer.attachColorAndSetDrawBuffers(colorTexList);
        GL30.glBindFramebuffer((int)36160, (int)0);
        return new Framebuffer(name, framebuffer);
    }

    public static Framebuffer create(String name, Texture2D colorTex0, Texture2D colorTex1, Texture2D depthTex) {
        GLFramebuffer framebuffer = new GLFramebuffer();
        framebuffer.glGenFramebuffers();
        framebuffer.glBindFramebuffer();
        depthTex.attachToFramebufferDepth();
        colorTex0.attachToFramebufferColor(36064);
        colorTex1.attachToFramebufferColor(36065);
        IntBuffer drawBuffers = BufferUtils.createIntBuffer((int)2);
        drawBuffers.put(36064);
        drawBuffers.put(36065);
        drawBuffers.flip();
        GL20.glDrawBuffers((IntBuffer)drawBuffers);
        GL30.glBindFramebuffer((int)36160, (int)0);
        return new Framebuffer(name, framebuffer);
    }

    public void bind() {
        this.framebuffer.glBindFramebuffer();
        DebugMarker.FRAMEBUFFER_BIND.insertFormat("[{0}]", this.name);
    }

    public void bindDraw() {
        this.framebuffer.glBindFramebufferDraw();
        DebugMarker.FRAMEBUFFER_BIND_DRAW.insertFormat("[{0}]", this.name);
    }

    public void bindRead() {
        this.framebuffer.glBindFramebufferRead();
        DebugMarker.FRAMEBUFFER_BIND_DRAW.insertFormat("[{0}]", this.name);
    }

    public void deinit() {
        if (this.isManaged) {
            this.framebuffer.glDeleteFramebuffers();
        }
    }

    public void clear() {
        this.framebuffer.glBindFramebuffer();
        GL30.glBindFramebuffer((int)36160, (int)0);
    }

    @Generated
    public String name() {
        return this.name;
    }
}

