/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.sufrace;

import com.ventooth.swansong.debug.GLObjectLabel;
import com.ventooth.swansong.gl.GLTexture;
import com.ventooth.swansong.image.ImageUtils;
import java.awt.image.BufferedImage;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import lombok.Generated;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

public class Texture2D {
    private final String name;
    private final GLTexture texture;
    private final int internalFormat;
    private int width;
    private int height;
    @Deprecated
    private BufferedImage img;
    private static final boolean IS_DEBUGGER_PRESENT = Texture2D.isDebuggerPresent();

    public Texture2D(String name, GLTexture texture, int internalFormat, int width, int height) {
        this.name = name;
        this.texture = texture;
        this.internalFormat = internalFormat;
        this.width = width;
        this.height = height;
        if (GLObjectLabel.isEnabled()) {
            GLObjectLabel.set(this.texture, name);
        }
    }

    public static boolean sizeEquals(Texture2D a, Texture2D b) {
        return a.width == b.width && a.height == b.height;
    }

    public int glName() {
        return this.texture.glName;
    }

    public void resize(int width, int height) {
        boolean isDepth = this.internalFormat == 6402;
        this.texture.glBindTexture2D();
        if (isDepth) {
            GL11.glTexImage2D((int)3553, (int)0, (int)6402, (int)width, (int)height, (int)0, (int)6402, (int)5126, (ByteBuffer)null);
        } else {
            GL11.glTexImage2D((int)3553, (int)0, (int)this.internalFormat, (int)width, (int)height, (int)0, (int)32993, (int)33639, (ByteBuffer)null);
        }
        GL11.glBindTexture((int)3553, (int)0);
        this.width = width;
        this.height = height;
    }

    public static Texture2D ofColorDrawBuffer(String name, int width, int height, int internalformat) {
        GLTexture texture = new GLTexture();
        texture.glGenTextures();
        texture.glBindTexture2D();
        Texture2D.setParams2D(10496, 9729);
        GL11.glTexImage2D((int)3553, (int)0, (int)internalformat, (int)width, (int)height, (int)0, (int)32993, (int)33639, (ByteBuffer)null);
        return new Texture2D(name, texture, internalformat, width, height);
    }

    public static Texture2D ofDepthDrawBuffer(String name, int width, int height) {
        GLTexture texture = new GLTexture();
        texture.glGenTextures();
        texture.glBindTexture2D();
        Texture2D.setParams2D(10496, 9728);
        GL11.glTexParameteri((int)3553, (int)34891, (int)6409);
        GL11.glTexImage2D((int)3553, (int)0, (int)6402, (int)width, (int)height, (int)0, (int)6402, (int)5126, (ByteBuffer)null);
        return new Texture2D(name, texture, 6402, width, height);
    }

    public static Texture2D ofShadowDepthBuffer(String name, int width, int height, boolean nearest, boolean mipped, boolean hwFiltering) {
        GLTexture texture = new GLTexture();
        texture.glGenTextures();
        texture.glBindTexture2D();
        Texture2D.setParams2D(10496, Texture2D.getMinFilter(nearest, mipped), Texture2D.getMagFilter(nearest));
        if (hwFiltering) {
            GL11.glTexParameteri((int)3553, (int)34892, (int)34894);
        }
        GL11.glTexImage2D((int)3553, (int)0, (int)6402, (int)width, (int)height, (int)0, (int)6402, (int)5126, (ByteBuffer)null);
        return new Texture2D(name, texture, 6402, width, height);
    }

    public static Texture2D ofShadowColorBuffer(String name, int width, int height, boolean nearest, boolean mipped) {
        GLTexture texture = new GLTexture();
        texture.glGenTextures();
        texture.glBindTexture2D();
        Texture2D.setParams2D(10496, Texture2D.getMinFilter(nearest, mipped), Texture2D.getMagFilter(nearest));
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)32993, (int)33639, (ByteBuffer)null);
        return new Texture2D(name, texture, 6408, width, height);
    }

    public static Texture2D ofColoredPixel(String name, int rgba) {
        GLTexture texture = new GLTexture();
        texture.glGenTextures();
        texture.glBindTexture2D();
        Texture2D.setParams2D(10496, 9728, 9728);
        IntBuffer pixel = BufferUtils.createIntBuffer((int)1);
        pixel.put(0, rgba);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)1, (int)1, (int)0, (int)6408, (int)33639, (IntBuffer)pixel);
        return new Texture2D(name, texture, 6408, 1, 1);
    }

    public static void setParams2D(boolean clamp, boolean blur) {
        Texture2D.setParams2D(clamp ? 10496 : 10497, blur ? 9729 : 9728);
    }

    public static void setParams2D(int wrap, int filter) {
        Texture2D.setParams2D(wrap, filter, filter);
    }

    public static void setParams2D(int wrap, int minFilter, int magFilter) {
        GL11.glTexParameteri((int)3553, (int)10242, (int)wrap);
        GL11.glTexParameteri((int)3553, (int)10243, (int)wrap);
        GL11.glTexParameteri((int)3553, (int)10241, (int)minFilter);
        GL11.glTexParameteri((int)3553, (int)10240, (int)magFilter);
    }

    private static int getMinFilter(boolean nearest, boolean mipped) {
        if (mipped) {
            return nearest ? 9984 : 9987;
        }
        return nearest ? 9728 : 9729;
    }

    public static int getMagFilter(boolean nearest) {
        return nearest ? 9728 : 9729;
    }

    public void deinit() {
        this.texture.glDeleteShader();
    }

    public void bind() {
        this.texture.glBindTexture2D();
    }

    public void attachToFramebufferColor(int attachment) {
        GL30.glFramebufferTexture2D((int)36160, (int)attachment, (int)3553, (int)this.texture.glName, (int)0);
    }

    public void attachToFramebufferDepth() {
        GL30.glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)this.texture.glName, (int)0);
    }

    public String toString() {
        if (IS_DEBUGGER_PRESENT) {
            this.img = ImageUtils.downloadGLTextureAsBGRA(this.texture.glName).asBufImg(true, true);
        }
        return super.toString();
    }

    private static boolean isDebuggerPresent() {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        List<String> args = runtime.getInputArguments();
        boolean jdwpPresent = args.toString().contains("jdwp");
        return jdwpPresent;
    }

    @Generated
    public String name() {
        return this.name;
    }

    @Generated
    public int internalFormat() {
        return this.internalFormat;
    }

    @Generated
    public int width() {
        return this.width;
    }

    @Generated
    public int height() {
        return this.height;
    }
}

