/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MicroCache<Key, Value> {
    public static final int CACHE_HIT_NULL_KEY = -2;
    private static final int INITIAL_CAPACITY = 8192;
    private Object2IntMap<Key> cacheIdx = new Object2IntOpenHashMap(8192, 0.2f);
    private ObjectList<@NotNull Value> cache = new ObjectArrayList(8192);

    public MicroCache() {
        this.cacheIdx.defaultReturnValue(-1);
    }

    public void purge() {
        if (this.cache.size() > 8192) {
            this.cacheIdx = new Object2IntOpenHashMap(8192, 0.2f);
            this.cache = new ObjectArrayList(8192);
        } else {
            this.cacheIdx.clear();
            this.cache.clear();
        }
    }

    public int getIndex(@NotNull Key key) {
        return this.cacheIdx.getInt(key);
    }

    @NotNull
    public Value getByIndex(int key) {
        return (Value)this.cache.get(key);
    }

    public void store(@NotNull Key key, @Nullable Value value) {
        if (value == null) {
            this.cacheIdx.put(key, -2);
            return;
        }
        this.cacheIdx.put(key, this.cache.size());
        this.cache.add(value);
    }

    @Nullable
    public Value getCached(@NotNull Key key, @NotNull @NotNull Function<@NotNull Key, @Nullable Value> getter) {
        int idx = this.getIndex(key);
        if (idx == -2) {
            return null;
        }
        if (idx >= 0) {
            return this.getByIndex(idx);
        }
        Value v = getter.apply(key);
        this.store(key, v);
        return v;
    }
}

