/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.debug;

import com.ventooth.swansong.image.TexDumper;
import com.ventooth.swansong.shader.ShaderEngine;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;

public final class DebugCommandClient
extends CommandBase {
    private final String name;
    private final List<String> aliases;
    private final String usage;
    private final int permission;
    private final Map<String, Runnable> optionMap;
    private final List<String> optionList;

    public DebugCommandClient() {
        this.name = "swan";
        this.aliases = Collections.singletonList(this.name);
        this.usage = MessageFormat.format("/{0} <option>", this.name);
        this.permission = 0;
        this.optionMap = new LinkedHashMap<String, Runnable>();
        this.optionMap.put("tex", TexDumper::dumpAllMc);
        this.optionMap.put("fb_reset", () -> {
            if (ShaderEngine.isInitialized()) {
                ShaderEngine.scheduleFramebufferResize();
            }
        });
        this.optionMap.put("sh_reset", ShaderEngine::scheduleShaderPackReload);
        this.optionList = new ArrayList<String>(this.optionMap.keySet());
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args == null || args.length != 1) {
            return;
        }
        String arg = args[0];
        for (Map.Entry<String, Runnable> option : this.optionMap.entrySet()) {
            if (!arg.equals(option.getKey())) continue;
            option.getValue().run();
            return;
        }
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args == null || args.length != 1) {
            return null;
        }
        String arg = args[0];
        ArrayList<String> completionOptions = new ArrayList<String>();
        this.optionList.stream().filter(opt -> opt.startsWith(arg)).forEach(completionOptions::add);
        return completionOptions.isEmpty() ? null : completionOptions;
    }

    public String func_71517_b() {
        return this.name;
    }

    public String func_71518_a(ICommandSender sender) {
        return this.usage;
    }

    public int func_82362_a() {
        return this.permission;
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public boolean func_71519_b(ICommandSender sender) {
        return true;
    }
}

