/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.debug;

import com.ventooth.swansong.config.DebugConfig;
import java.text.MessageFormat;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.KHRDebug;

public enum DebugMarker {
    GENERIC(100),
    FRAMEBUFFER_BLIT(200),
    FRAMEBUFFER_BIND(210),
    FRAMEBUFFER_BIND_DRAW(211),
    FRAMEBUFFER_BIND_READ(212),
    TEXTURE_COLOR_BLIT(500),
    TEXTURE_DEPTH_BLIT(510),
    TEXTURE_MIP_GEN(520),
    SCREENSHOT_TAKEN(530);

    private static final Logger log;
    private static boolean withTraceLog;
    private final int id;

    public static boolean isEnabled() {
        return DebugConfig.GLDebugMarkers;
    }

    public void insert() {
        if (!DebugMarker.isEnabled()) {
            return;
        }
        this.doInsertMessage(this.name());
    }

    public void insert(String message) {
        if (!DebugMarker.isEnabled()) {
            return;
        }
        this.doInsertMessage(this.name() + ": " + message);
    }

    public void insertFormat(String format, Object ... args) {
        if (!DebugMarker.isEnabled()) {
            return;
        }
        this.doInsertMessage(this.name() + ": " + MessageFormat.format(format, args));
    }

    private void doInsertMessage(String message) {
        if (withTraceLog) {
            log.trace(message);
        }
        KHRDebug.glDebugMessageInsert((int)33354, (int)33384, (int)this.id, (int)33387, (CharSequence)message);
    }

    @Generated
    private DebugMarker(int id) {
        this.id = id;
    }

    static {
        log = LogManager.getLogger((String)"GLDebug|Marker");
        withTraceLog = false;
    }
}

