/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.gui;

import com.ventooth.swansong.Share;
import com.ventooth.swansong.gui.Colors;
import com.ventooth.swansong.gui.GuiConfirmEscape;
import com.ventooth.swansong.gui.GuiConfirmReinit;
import com.ventooth.swansong.gui.TooltipRenderer;
import com.ventooth.swansong.resources.ShaderPackManager;
import com.ventooth.swansong.shader.config.ConfigEntry;
import cpw.mods.fml.client.config.GuiButtonExt;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;

public final class GuiShaderOptions
extends GuiScreen {
    private static final int RESET_BUTTON = 1000;
    private static final int FULL_RESET_BUTTON = 1001;
    private static final int DONE_BUTTON = 1002;
    private static final int APPLY_BUTTON = 1003;
    private String title = "GuiShaderOptions";
    private final Supplier<? extends GuiScreen> parentGui;
    private final ConfigEntry.RootScreen rootScreen;
    private final ConfigEntry.Screen configScreen;
    private GuiButton applyButton;
    private final TooltipRenderer tr = new TooltipRenderer();

    public GuiShaderOptions(GuiScreen parentGui, ConfigEntry.RootScreen configScreen) {
        this(() -> parentGui, configScreen, configScreen);
    }

    private GuiShaderOptions(Supplier<? extends GuiScreen> parentGui, ConfigEntry.RootScreen root, ConfigEntry.Screen configScreen) {
        this.parentGui = parentGui;
        this.rootScreen = root;
        this.configScreen = configScreen;
    }

    public void func_73866_w_() {
        int colsMin;
        this.title = this.configScreen.screenTitle();
        int baseId = 100;
        int baseX = 0;
        int baseY = 30;
        int stepY = 20;
        int btnWidth = 160;
        int btnHeight = 20;
        ObjectList<ConfigEntry> configs = this.configScreen.entries();
        int configsLength = configs.size();
        int columns = this.configScreen.columnsHint();
        if (columns < (colsMin = MathHelper.func_76143_f((double)((double)configsLength / 9.0)))) {
            columns = colsMin;
        }
        for (int i = 0; i < configsLength; ++i) {
            ConfigButton btn;
            ConfigEntry config = (ConfigEntry)configs.get(i);
            if (config == null) continue;
            int col = i % columns;
            int row = i / columns;
            int colWidth = Math.min(this.field_146294_l / columns, 200);
            baseX = (this.field_146294_l - colWidth * columns) / 2;
            int x = col * colWidth + 5 + baseX;
            int y = baseY + row * stepY;
            int w = colWidth - 10;
            if (config instanceof ConfigEntry.Screen) {
                ConfigEntry.Screen screen = (ConfigEntry.Screen)config;
                btn = new ScreenButton(baseId + i, x, y, w, btnHeight, screen);
            } else if (config instanceof ConfigEntry.Fixed) {
                ConfigEntry.Fixed fixed = (ConfigEntry.Fixed)config;
                btn = new CfgFixed(baseId + i, x, y, w, btnHeight, fixed);
            } else if (config instanceof ConfigEntry.Switchable) {
                ConfigEntry.Switchable switchable = (ConfigEntry.Switchable)config;
                btn = new CfgSwitchable(baseId + i, x, y, w, btnHeight, switchable);
            } else if (config instanceof ConfigEntry.Toggleable) {
                ConfigEntry.Toggleable toggleable = (ConfigEntry.Toggleable)config;
                btn = new CfgToggleable(baseId + i, x, y, w, btnHeight, toggleable);
            } else if (config instanceof ConfigEntry.Draggable) {
                ConfigEntry.Draggable draggable = (ConfigEntry.Draggable)config;
                btn = new CfgDraggable(baseId + i, x, y, w, btnHeight, draggable);
            } else {
                Share.log.error("Unknown config entry class: {}", new Object[]{config.getClass().getName()});
                continue;
            }
            ((GuiButton)btn).field_146124_l = true;
            this.field_146292_n.add(btn);
        }
        int subBtnWidth = btnWidth / 2 - 5;
        if (this.configScreen instanceof ConfigEntry.RootScreen) {
            int offset = this.field_146294_l / 2 - btnWidth - 10;
            this.field_146292_n.add(new GuiButtonExt(1000, offset, this.field_146295_m / 6 + 168 + 11, subBtnWidth, btnHeight, I18n.func_135052_a((String)"controls.reset", (Object[])new Object[0])));
            this.field_146292_n.add(new GuiButtonExt(1001, offset += subBtnWidth + 10, this.field_146295_m / 6 + 168 + 11, subBtnWidth, btnHeight, I18n.func_135052_a((String)"gui.swansong.shaders.resetAll", (Object[])new Object[0])));
        } else {
            this.field_146292_n.add(new GuiButtonExt(1000, this.field_146294_l / 2 - btnWidth - 10, this.field_146295_m / 6 + 168 + 11, btnWidth, btnHeight, I18n.func_135052_a((String)"controls.reset", (Object[])new Object[0])));
        }
        int offset = this.field_146294_l / 2 + 10;
        this.applyButton = new GuiButtonExt(1003, offset, this.field_146295_m / 6 + 168 + 11, subBtnWidth, btnHeight, I18n.func_135052_a((String)"gui.swansong.shaders.apply", (Object[])new Object[0]));
        this.applyButton.field_146124_l = this.rootScreen.isModified();
        this.field_146292_n.add(this.applyButton);
        this.field_146292_n.add(new GuiButtonExt(1002, offset += subBtnWidth + 10, this.field_146295_m / 6 + 168 + 11, subBtnWidth, btnHeight, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
    }

    private Supplier<GuiShaderOptions> refresh() {
        Supplier<? extends GuiScreen> parentGui = this.parentGui;
        ConfigEntry.RootScreen rootScreen = this.rootScreen;
        ConfigEntry.Screen configScreen = this.configScreen;
        return () -> new GuiShaderOptions(parentGui, rootScreen, configScreen);
    }

    private GuiShaderOptions doRefresh() {
        Supplier<? extends GuiScreen> parentGui = this.parentGui;
        ConfigEntry.RootScreen rootScreen = this.rootScreen;
        ConfigEntry.Screen configScreen = this.configScreen;
        return new GuiShaderOptions(parentGui, rootScreen, configScreen);
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (!guibutton.field_146124_l) {
            return;
        }
        this.applyButton.field_146124_l = this.rootScreen.isModified();
        if (guibutton instanceof ScreenButton) {
            ScreenButton screenBtn = (ScreenButton)guibutton;
            this.field_146297_k.func_147108_a((GuiScreen)new GuiShaderOptions(this.refresh(), this.rootScreen, screenBtn.screen));
            return;
        }
        if (guibutton.field_146127_k == 1001 && this.configScreen == this.rootScreen) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiConfirmReinit(this.refresh(), this.rootScreen));
            return;
        }
        if (guibutton.field_146127_k == 1000) {
            this.configScreen.reset();
            this.field_146297_k.func_147108_a((GuiScreen)this.doRefresh());
            return;
        }
        if (guibutton.field_146127_k == 1003) {
            if (this.rootScreen.isModified()) {
                this.rootScreen.save();
                ShaderPackManager.saveShaderSettings();
                this.field_146297_k.func_147108_a((GuiScreen)this.doRefresh());
            }
            return;
        }
        if (guibutton.field_146127_k == 1002) {
            if (this.rootScreen == this.configScreen && this.rootScreen.isModified()) {
                this.rootScreen.save();
                ShaderPackManager.saveShaderSettings();
            }
            this.field_146297_k.func_147108_a(this.parentGui.get());
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 1) {
            if (this.configScreen == this.rootScreen && this.rootScreen.isModified()) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiConfirmEscape(this.parentGui, this.rootScreen));
            } else {
                this.field_146297_k.func_147108_a(this.parentGui.get());
            }
        }
    }

    public void func_73863_a(int x, int y, float f) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, this.title, this.field_146294_l / 2, 15, 0xFFFFFF);
        super.func_73863_a(x, y, f);
        for (GuiButton button : this.field_146292_n) {
            if (!(button instanceof ConfigButton)) continue;
            ConfigButton cb = (ConfigButton)button;
            if (x < button.field_146128_h || y < button.field_146129_i || x >= button.field_146128_h + button.field_146120_f || y >= button.field_146129_i + button.field_146121_g) continue;
            this.tr.drawTooltip(this, x, y, cb.tooltip());
            return;
        }
        this.tr.drawTooltip(this, x, y, (ObjectList<String>)ObjectLists.emptyList());
    }

    private class ScreenButton
    extends ConfigButton {
        final ConfigEntry.Screen screen;

        ScreenButton(int id, int posX, int posY, int width, int height, ConfigEntry.Screen screen) {
            super(id, posX, posY, width, height, screen.optionName());
            this.screen = screen;
        }

        @Override
        ObjectList<String> tooltip() {
            return this.screen.description();
        }
    }

    private class CfgFixed
    extends ConfigButton {
        final ConfigEntry.Fixed fixed;

        CfgFixed(int id, int posX, int posY, int width, int height, ConfigEntry.Fixed fixed) {
            super(id, posX, posY, width, height, fixed.optionName() + ": " + fixed.valueName());
            this.fixed = fixed;
        }

        @Override
        ObjectList<String> tooltip() {
            return this.fixed.description();
        }
    }

    private class CfgSwitchable
    extends ConfigButton {
        final ConfigEntry.Switchable switchable;

        CfgSwitchable(int id, int posX, int posY, int width, int height, ConfigEntry.Switchable switchable) {
            super(id, posX, posY, width, height, "");
            this.switchable = switchable;
            this.field_146126_j = this.coloredStr();
        }

        private String coloredStr() {
            return this.switchable.optionName() + ": " + Colors.forConfig(this.switchable) + this.switchable.valueName();
        }

        public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
            if (super.func_146116_c(mc, mouseX, mouseY)) {
                this.switchable.nextValue();
                this.field_146126_j = this.coloredStr();
                return true;
            }
            return false;
        }

        @Override
        ObjectList<String> tooltip() {
            return this.switchable.description();
        }
    }

    private class CfgToggleable
    extends ConfigButton {
        final ConfigEntry.Toggleable toggleable;

        CfgToggleable(int id, int posX, int posY, int width, int height, ConfigEntry.Toggleable toggleable) {
            super(id, posX, posY, width, height, "");
            this.toggleable = toggleable;
            this.field_146126_j = this.coloredStr();
        }

        private String coloredStr() {
            return this.toggleable.optionName() + ": " + Colors.forConfig(this.toggleable) + CfgToggleable.toggleLang(this.toggleable.getValue());
        }

        public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
            if (super.func_146116_c(mc, mouseX, mouseY)) {
                this.toggleable.toggle();
                this.field_146126_j = this.coloredStr();
                return true;
            }
            return false;
        }

        static String toggleLang(boolean value) {
            return value ? "ON" : "OFF";
        }

        @Override
        ObjectList<String> tooltip() {
            return this.toggleable.description();
        }
    }

    private class CfgDraggable
    extends ConfigButton {
        final ConfigEntry.Draggable draggable;
        float sliderPos;
        boolean isDragging;

        CfgDraggable(int id, int posX, int posY, int width, int height, ConfigEntry.Draggable draggable) {
            super(id, posX, posY, width, height, "");
            this.draggable = draggable;
            this.sliderPos = this.draggable.getValue();
            this.isDragging = false;
            this.field_146126_j = this.coloredStr();
        }

        public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
            if (super.func_146116_c(mc, mouseX, mouseY)) {
                this.isDragging = true;
                this.updatePos(mouseX);
                return true;
            }
            return false;
        }

        public void func_146118_a(int mouseX, int mouseY) {
            this.isDragging = false;
        }

        public int func_146114_a(boolean mouseOver) {
            return 0;
        }

        protected void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
            if (this.field_146125_m) {
                if (this.isDragging) {
                    this.updatePos(mouseX);
                }
                this.drawSlider(mc);
            }
        }

        private String coloredStr() {
            return this.draggable.optionName() + ": " + Colors.forConfig(this.draggable) + this.draggable.valueName();
        }

        void updatePos(int mouseX) {
            this.sliderPos = this.draggable.setValue(((float)mouseX - ((float)this.field_146128_h + 4.0f)) / ((float)this.field_146120_f - 8.0f));
            this.field_146126_j = this.coloredStr();
        }

        void drawSlider(Minecraft mc) {
            mc.func_110434_K().func_110577_a(field_146122_a);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(this.field_146128_h + (int)(this.sliderPos * ((float)this.field_146120_f - 8.0f)), this.field_146129_i, 0, 66, 4, 20);
            this.func_73729_b(this.field_146128_h + (int)(this.sliderPos * ((float)this.field_146120_f - 8.0f)) + 4, this.field_146129_i, 196, 66, 4, 20);
        }

        @Override
        ObjectList<String> tooltip() {
            return this.draggable.description();
        }
    }

    private abstract class ConfigButton
    extends GuiButtonExt {
        public ConfigButton(int id, int xPos, int yPos, int width, int height, String displayString) {
            super(id, xPos, yPos, width, height, displayString);
        }

        abstract ObjectList<String> tooltip();
    }
}

