/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.mathparser;

import com.ventooth.swansong.mathparser.ParserException;
import com.ventooth.swansong.mathparser.Token;
import com.ventooth.swansong.mathparser.TokenType;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class Lexer {
    private final char[] characters;
    private int offset = 0;
    private Token buffer;

    public Lexer(String str) {
        this.characters = str.toCharArray();
    }

    private void expect(char c) throws UnexpectedCharException {
        if (!this.hasNextChar()) {
            throw new UnexpectedCharException(this.offset, c, "End of file");
        }
        char c2 = this.nextChar();
        if (c2 != c) {
            throw new UnexpectedCharException(this.offset - 1, c, c2);
        }
    }

    public boolean hasNext() throws UnexpectedCharException {
        Token token;
        int pc;
        char c;
        if (this.buffer != null) {
            return true;
        }
        do {
            if (!this.hasNextChar()) {
                return false;
            }
            pc = this.offset--;
        } while (Character.isWhitespace(c = this.nextChar()));
        switch (c) {
            case '+': {
                token = new Token(pc, TokenType.Plus, "+");
                break;
            }
            case '-': {
                token = new Token(pc, TokenType.Minus, "-");
                break;
            }
            case '*': {
                token = new Token(pc, TokenType.Mul, "*");
                break;
            }
            case '/': {
                token = new Token(pc, TokenType.Div, "/");
                break;
            }
            case '%': {
                token = new Token(pc, TokenType.Mod, "%");
                break;
            }
            case '&': {
                if (!this.hasNextChar()) {
                    token = new Token(pc, TokenType.And, "&");
                    break;
                }
                char c2 = this.nextChar();
                if (c2 != '&') {
                    token = new Token(pc, TokenType.And, "&");
                    break;
                }
                token = new Token(pc, TokenType.And, "&&");
                break;
            }
            case '|': {
                if (!this.hasNextChar()) {
                    token = new Token(pc, TokenType.Or, "|");
                    break;
                }
                char c2 = this.nextChar();
                if (c2 != '|') {
                    --this.offset;
                    token = new Token(pc, TokenType.Or, "|");
                    break;
                }
                token = new Token(pc, TokenType.Or, "||");
                break;
            }
            case '>': {
                if (!this.hasNextChar()) {
                    token = new Token(pc, TokenType.Greater, ">");
                    break;
                }
                char c2 = this.nextChar();
                if (c2 != '=') {
                    --this.offset;
                    token = new Token(pc, TokenType.Greater, ">");
                    break;
                }
                token = new Token(pc, TokenType.GreaterEqual, ">=");
                break;
            }
            case '<': {
                if (!this.hasNextChar()) {
                    token = new Token(pc, TokenType.Less, "<");
                    break;
                }
                char c2 = this.nextChar();
                if (c2 != '=') {
                    --this.offset;
                    token = new Token(pc, TokenType.Less, "<");
                    break;
                }
                token = new Token(pc, TokenType.LessEqual, "<=");
                break;
            }
            case '!': {
                if (!this.hasNextChar()) {
                    token = new Token(pc, TokenType.Not, "!");
                    break;
                }
                char c2 = this.nextChar();
                if (c2 != '=') {
                    --this.offset;
                    token = new Token(pc, TokenType.Not, "!");
                    break;
                }
                token = new Token(pc, TokenType.NotEqual, "!=");
                break;
            }
            case '=': {
                this.expect('=');
                token = new Token(pc, TokenType.Equal, "==");
                break;
            }
            case ',': {
                token = new Token(pc, TokenType.Comma, ",");
                break;
            }
            case '(': {
                token = new Token(pc, TokenType.LeftParen, "(");
                break;
            }
            case ')': {
                token = new Token(pc, TokenType.RightParen, ")");
                break;
            }
            case '.': {
                token = new Token(pc, TokenType.Dot, ".");
                break;
            }
            default: {
                if (c >= '0' && c <= '9') {
                    token = this.tokenizeNumber(pc, c);
                    break;
                }
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                    token = this.tokenizeIdentifier(pc, c);
                    break;
                }
                throw new UnexpectedCharException(this.offset - 1, "whitespace  +-*/%&|><!=,().  a-z  A-Z  0-9", c);
            }
        }
        this.buffer = token;
        return true;
    }

    @NotNull
    public Token peek() {
        Token res = this.buffer;
        if (res == null) {
            throw new AssertionError();
        }
        return res;
    }

    @NotNull
    public Token next() {
        Token res = this.buffer;
        if (res == null) {
            throw new AssertionError();
        }
        this.buffer = null;
        return res;
    }

    private Token tokenizeNumber(int pc, char c) {
        StringBuilder num = new StringBuilder(32);
        num.append(c);
        boolean hasDot = false;
        while (true) {
            if (!this.hasNextChar()) {
                return new Token(pc, hasDot ? TokenType.Float : TokenType.Integer, num.toString());
            }
            char c2 = this.nextChar();
            if (c2 >= '0' && c2 <= '9') {
                num.append(c2);
                continue;
            }
            if (c2 != '.') break;
            if (hasDot) {
                --this.offset;
                return new Token(pc, TokenType.Float, num.toString());
            }
            hasDot = true;
            num.append(c2);
        }
        --this.offset;
        return new Token(pc, hasDot ? TokenType.Float : TokenType.Integer, num.toString());
    }

    private Token tokenizeIdentifier(int pc, char c) {
        StringBuilder ident = new StringBuilder(32);
        ident.append(c);
        while (true) {
            if (!this.hasNextChar()) {
                return this.tokenFromIdentifierText(pc, ident);
            }
            char c2 = this.nextChar();
            if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9') && c2 != '_') break;
            ident.append(c2);
        }
        --this.offset;
        return this.tokenFromIdentifierText(pc, ident);
    }

    private Token tokenFromIdentifierText(int pc, StringBuilder b) {
        if ("true".contentEquals(b)) {
            return new Token(pc, TokenType.True, "true");
        }
        if ("false".contentEquals(b)) {
            return new Token(pc, TokenType.False, "false");
        }
        return new Token(pc, TokenType.Identifier, b.toString());
    }

    private boolean hasNextChar() {
        return this.offset < this.characters.length;
    }

    private char nextChar() {
        return this.characters[this.offset++];
    }

    public static class UnexpectedCharException
    extends ParserException {
        public final int at;
        public final String expected;
        public final String got;

        public UnexpectedCharException(int at, String expected, char got) {
            this(at, expected, Character.toString(got));
        }

        public UnexpectedCharException(int at, char expected, char got) {
            this(at, Character.toString(expected), Character.toString(got));
        }

        public UnexpectedCharException(int at, char expected, String got) {
            this(at, Character.toString(expected), got);
        }

        @Generated
        public UnexpectedCharException(int at, String expected, String got) {
            this.at = at;
            this.expected = expected;
            this.got = got;
        }
    }
}

