/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.pbr;

import com.ventooth.swansong.Share;
import com.ventooth.swansong.config.ShadersConfig;
import com.ventooth.swansong.mixin.interfaces.PBRTextureHolder;
import com.ventooth.swansong.mixin.interfaces.ShadersTextureAtlasSprite;
import com.ventooth.swansong.shader.ShaderEngine;
import com.ventooth.swansong.shader.ShaderSamplers;
import com.ventooth.swansong.shader.ShaderState;
import com.ventooth.swansong.sufrace.PBRTexture2D;
import com.ventooth.swansong.sufrace.Texture2D;
import com.ventooth.swansong.sufrace.TextureMeta;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.IntBuffer;
import java.util.Arrays;
import javax.imageio.ImageIO;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;

public final class PBRTextureEngine {
    private static final Logger log = Share.getLogger();
    private static final int BASE_ATLAS_DEFAULT_COL = 0;
    private static final int BASE_DEFAULT_COL = -1;
    private static final int NORM_DEFAULT_COL = -8421377;
    private static final int SPEC_DEFAULT_COL = 0;
    private static boolean isInitialized = false;
    private static boolean isDefaultTexUnit = false;
    private static Texture2D fallbackBaseTex;
    private static Texture2D fallbackNormTex;
    private static Texture2D fallbackSpecTex;
    private static int @Nullable [] intArray;
    @Nullable
    private static IntBuffer intBuffer;

    public static void init() {
        if (isInitialized) {
            log.warn("Already initialized?");
            return;
        }
        try {
            isDefaultTexUnit = false;
            assert (fallbackBaseTex == null);
            assert (fallbackNormTex == null);
            assert (fallbackSpecTex == null);
            GL13.glActiveTexture((int)PBRTextureEngine.baseTexUnit());
            fallbackBaseTex = Texture2D.ofColoredPixel("pbr_fallback_base", -1);
            fallbackNormTex = Texture2D.ofColoredPixel("pbr_fallback_norm", -8421377);
            fallbackSpecTex = Texture2D.ofColoredPixel("pbr_fallback_spec", 0);
            intArray = null;
            intBuffer = null;
        }
        catch (Error | RuntimeException e) {
            log.fatal("Failed to initialize", e);
            throw e;
        }
        finally {
            GL13.glActiveTexture((int)PBRTextureEngine.baseTexUnit());
            GL11.glBindTexture((int)3553, (int)0);
        }
        isInitialized = true;
        log.debug("Initialized");
    }

    public static void deinit() {
        if (!isInitialized) {
            log.warn("Already deinitialized?");
            return;
        }
        try {
            isDefaultTexUnit = false;
            assert (fallbackBaseTex != null);
            assert (fallbackNormTex != null);
            assert (fallbackSpecTex != null);
            GL13.glActiveTexture((int)PBRTextureEngine.baseTexUnit());
            fallbackBaseTex.deinit();
            fallbackBaseTex = null;
            fallbackNormTex.deinit();
            fallbackNormTex = null;
            fallbackSpecTex.deinit();
            fallbackSpecTex = null;
            intArray = null;
            intBuffer = null;
        }
        catch (Error | RuntimeException e) {
            log.fatal("Failed to deinitialized", e);
            throw e;
        }
        finally {
            GL13.glActiveTexture((int)PBRTextureEngine.baseTexUnit());
            GL11.glBindTexture((int)3553, (int)0);
        }
        isInitialized = false;
        log.debug("Deinitialized");
    }

    public static void isDefaultTexUnit(boolean toggle) {
        isDefaultTexUnit = toggle;
    }

    public static void bindPbrTex(@Nullable PBRTextureHolder pbrHolder) {
        PBRTexture2D spec;
        PBRTexture2D norm;
        assert (isInitialized) : "Not Initialized";
        assert (ShaderEngine.graph.isManaged()) : "Not in managed mode";
        if (!isDefaultTexUnit) {
            return;
        }
        if (pbrHolder == null || !pbrHolder.swan$isValid()) {
            norm = null;
            spec = null;
        } else {
            PBRTexture2D.Bundle pbrTex = PBRTextureEngine.getPbrTexOrInit(pbrHolder);
            norm = pbrTex.norm();
            spec = pbrTex.spec();
            if (pbrHolder.swan$isAtlas()) {
                ShaderState.updateAtlasSize(pbrHolder.swan$width(), pbrHolder.swan$height());
            } else {
                ShaderState.updateAtlasSize(0, 0);
            }
        }
        GL13.glActiveTexture((int)PBRTextureEngine.normTexUnit());
        if (norm != null) {
            norm.bind();
        } else {
            fallbackNormTex.bind();
        }
        GL13.glActiveTexture((int)PBRTextureEngine.specTexUnit());
        if (spec != null) {
            spec.bind();
        } else {
            fallbackSpecTex.bind();
        }
        GL13.glActiveTexture((int)PBRTextureEngine.baseTexUnit());
    }

    public static void logInitialLoad(PBRTextureHolder pbrHolder) {
        log.debug("Initial load: {}", new Object[]{pbrHolder.swan$baseToString()});
    }

    public static void initAtlas(PBRTextureHolder pbrHolder, int mipLevels, float anisotropy) {
        PBRTexture2D norm = ShadersConfig.NormalMapping.value ? PBRTextureEngine.createAtlasTex(pbrHolder, mipLevels, anisotropy, 'n') : null;
        PBRTexture2D spec = ShadersConfig.SpecularMapping.value ? PBRTextureEngine.createAtlasTex(pbrHolder, mipLevels, anisotropy, 's') : null;
        GL11.glBindTexture((int)3553, (int)0);
        ResourceLocation baseLoc = pbrHolder.swan$base();
        PBRTexture2D.Bundle pbrTex = new PBRTexture2D.Bundle(baseLoc, norm, spec);
        pbrHolder.swan$pbrTex(pbrTex);
        log.debug("Initialized PBR for atlas: {}", new Object[]{baseLoc});
    }

    @Nullable
    private static PBRTexture2D createAtlasTex(PBRTextureHolder pbrHolder, int mipLevels, float anisotropy, char postfix) {
        ResourceLocation pbrLoc;
        ResourceLocation baseLoc = pbrHolder.swan$base();
        try {
            pbrLoc = PBRTextureEngine.getPbrLoc(baseLoc, postfix);
        }
        catch (Exception e) {
            log.warn("Failed to decode atlas loc??: ", (Throwable)e);
            return null;
        }
        int width = pbrHolder.swan$width();
        int height = pbrHolder.swan$height();
        int glName = GL11.glGenTextures();
        TextureUtil.func_147946_a((int)glName, (int)mipLevels, (int)width, (int)height, (float)anisotropy);
        return PBRTexture2D.ofWrapped(pbrLoc, width, height, glName);
    }

    public static void uploadAtlasSpritesAll(PBRTextureHolder pbrHolder, int baseGlName, ObjectList<TextureAtlasSprite> baseSprites, int mipmapLevels) {
        PBRTexture2D.Bundle pbrTex = pbrHolder.swan$pbrTex();
        PBRTexture2D norm = pbrTex.norm();
        PBRTexture2D spec = pbrTex.spec();
        int normGlName = ShadersConfig.NormalMapping.value ? (norm != null ? norm.glName() : 0) : 0;
        int specGlName = ShadersConfig.SpecularMapping.value ? (spec != null ? spec.glName() : 0) : 0;
        ObjectArrayList normSprites = new ObjectArrayList();
        ObjectArrayList specSprites = new ObjectArrayList();
        for (TextureAtlasSprite sprite : baseSprites) {
            TextureAtlasSprite specSprite;
            ShadersTextureAtlasSprite shaderSprite = (ShadersTextureAtlasSprite)sprite;
            TextureAtlasSprite normSprite = shaderSprite.swan$spriteNorm();
            if (normSprite != null) {
                normSprites.add((Object)normSprite);
            }
            if ((specSprite = shaderSprite.swan$spriteSpec()) == null) continue;
            specSprites.add((Object)specSprite);
        }
        int width = pbrHolder.swan$width();
        int height = pbrHolder.swan$height();
        if (normGlName != 0) {
            log.debug("Uploading: {} sprites to: {}", new Object[]{normSprites.size(), norm.loc()});
            PBRTextureEngine.uploadAtlasSpriteLayer(normGlName, (ObjectList<TextureAtlasSprite>)normSprites, width, height, mipmapLevels, -8421377);
        }
        if (specGlName != 0) {
            log.debug("Uploading: {} sprites to: {}", new Object[]{specSprites.size(), spec.loc()});
            PBRTextureEngine.uploadAtlasSpriteLayer(specGlName, (ObjectList<TextureAtlasSprite>)specSprites, width, height, mipmapLevels, 0);
        }
        log.debug("Uploading: {} sprites to: {}", new Object[]{baseSprites.size(), pbrHolder.swan$base()});
        PBRTextureEngine.uploadAtlasSpriteLayer(baseGlName, baseSprites, width, height, mipmapLevels, 0);
    }

    private static void uploadAtlasSpriteLayer(int glName, ObjectList<TextureAtlasSprite> sprites, int width, int height, int mipLevels, int defaultCol) {
        GL11.glBindTexture((int)3553, (int)glName);
        int[][] buf = new int[++mipLevels][];
        for (int mip = 0; mip < mipLevels; ++mip) {
            int w = width >> mip;
            int h = height >> mip;
            int[] currentMip = new int[w * h];
            buf[mip] = currentMip;
            Arrays.fill(currentMip, defaultCol);
        }
        for (TextureAtlasSprite sprite : sprites) {
            int originX = sprite.func_130010_a();
            int originY = sprite.func_110967_i();
            int iconWidth = sprite.func_94211_a();
            int iconHeight = sprite.func_94216_b();
            int[][] frame = sprite.func_147965_a(0);
            int levels = Math.min(frame.length, mipLevels);
            for (int mip = 0; mip < levels; ++mip) {
                int[] mipFrame = frame[mip];
                int x = originX >> mip;
                int y = originY >> mip;
                int w = iconWidth >> mip;
                int h = iconHeight >> mip;
                int imgW = width >> mip;
                int[] mipTex = buf[mip];
                for (int y1 = 0; y1 < h; ++y1) {
                    int source = y1 * w;
                    int dest = (y + y1) * imgW + x;
                    System.arraycopy(mipFrame, source, mipTex, dest, w);
                }
            }
        }
        TextureUtil.func_147955_a((int[][])buf, (int)width, (int)height, (int)0, (int)0, (boolean)false, (boolean)false);
    }

    public static void deinitPbrTex(PBRTexture2D.Bundle pbrTex, String reason) {
        ResourceLocation specLoc;
        ResourceLocation normLoc;
        PBRTexture2D norm = pbrTex.norm();
        if (norm == null) {
            normLoc = null;
        } else {
            norm.deinit();
            normLoc = norm.loc();
        }
        PBRTexture2D spec = pbrTex.spec();
        if (spec == null) {
            specLoc = null;
        } else {
            spec.deinit();
            specLoc = spec.loc();
        }
        log.debug("Deinit PBR {}: {}, (norm={}, spec={})", new Object[]{reason, pbrTex.base(), normLoc, specLoc});
    }

    private static PBRTexture2D.Bundle getPbrTexOrInit(PBRTextureHolder pbrHolder) {
        PBRTexture2D.Bundle pbrTex = pbrHolder.swan$pbrTex();
        if (pbrTex != null) {
            return pbrTex;
        }
        PBRTexture2D norm = ShadersConfig.NormalMapping.value ? PBRTextureEngine.loadPbrTex(pbrHolder, 'n') : null;
        PBRTexture2D spec = ShadersConfig.SpecularMapping.value ? PBRTextureEngine.loadPbrTex(pbrHolder, 's') : null;
        GL11.glBindTexture((int)3553, (int)0);
        pbrTex = new PBRTexture2D.Bundle(pbrHolder.swan$base(), norm, spec);
        pbrHolder.swan$pbrTex(pbrTex);
        log.debug("Initialized PBR Tex for: ({})->[norm={},spec={}]", new Object[]{pbrTex.base(), norm != null, spec != null});
        return pbrTex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static PBRTexture2D loadPbrTex(PBRTextureHolder pbrHolder, char postfix) {
        BufferedImage img;
        InputStream is;
        ResourceLocation pbrLoc;
        ResourceLocation baseLoc = pbrHolder.swan$base();
        try {
            pbrLoc = PBRTextureEngine.getPbrLoc(baseLoc, postfix);
        }
        catch (Exception e) {
            log.warn("Failed to load PBR texture: ", (Throwable)e);
            return null;
        }
        try {
            is = Minecraft.func_71410_x().func_110442_L().func_110536_a(pbrLoc).func_110527_b();
        }
        catch (Exception e) {
            log.debug("PBR Texture not found: {}", new Object[]{pbrLoc});
            return null;
        }
        try {
            img = ImageIO.read(is);
        }
        catch (Exception e) {
            log.warn("Failed to decode image: " + pbrLoc, (Throwable)e);
            PBRTexture2D pBRTexture2D = null;
            return pBRTexture2D;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        int width = pbrHolder.swan$width();
        int height = pbrHolder.swan$height();
        int pbrWidth = img.getWidth();
        int pbrHeight = img.getHeight();
        if (width != pbrWidth || height != pbrHeight) {
            log.warn("Size mismatch between ({})->[{}x{}] and ({})->[{}x{}]", new Object[]{baseLoc, width, height, pbrLoc, pbrWidth, pbrHeight});
            return null;
        }
        try {
            int size = width * height;
            int[] pixels = PBRTextureEngine.getIntArray(size);
            img.getRGB(0, 0, width, height, pixels, 0, width);
            IntBuffer buf = PBRTextureEngine.getIntBuffer(size);
            buf.put(pixels, 0, size);
            buf.flip();
            TextureMeta meta = pbrHolder.swan$meta();
            boolean clamp = meta.clamp();
            boolean blur = meta.blur();
            PBRTexture2D tex = PBRTexture2D.ofIntBuffer(pbrLoc, width, height, clamp, blur, buf);
            log.debug("Loaded PBR Texture: {}", new Object[]{pbrLoc});
            return tex;
        }
        catch (Exception e) {
            intArray = null;
            intBuffer = null;
            log.error("Unexpected error trying to load: " + pbrLoc, (Throwable)e);
            return null;
        }
    }

    private static ResourceLocation getPbrLoc(ResourceLocation baseLoc, char postfix) throws IllegalArgumentException {
        String path = baseLoc.func_110623_a();
        if (!path.endsWith(".png")) {
            throw new IllegalArgumentException("Texture location does not end with '.png': " + baseLoc);
        }
        String pbrPath = path.substring(0, path.length() - ".png".length()) + "_" + postfix + ".png";
        return new ResourceLocation(baseLoc.func_110624_b(), pbrPath);
    }

    private static int baseTexUnit() {
        return 33984 + ShaderSamplers.GBuffer.texture();
    }

    private static int normTexUnit() {
        return 33984 + ShaderSamplers.GBuffer.normals();
    }

    private static int specTexUnit() {
        return 33984 + ShaderSamplers.GBuffer.specular();
    }

    private static int[] getIntArray(int size) {
        if (intArray == null || intArray.length < size) {
            intArray = new int[size];
            log.debug("Expanded int array to: {}", new Object[]{size});
        }
        return intArray;
    }

    private static IntBuffer getIntBuffer(int size) {
        if (intBuffer == null || intBuffer.capacity() < size) {
            intBuffer = BufferUtils.createIntBuffer((int)size);
            log.debug("Expanded int buffer to: {}", new Object[]{size});
        }
        intBuffer.clear();
        return intBuffer;
    }

    public static IResource getResource(ResourceLocation loc) throws IOException {
        return Minecraft.func_71410_x().func_110442_L().func_110536_a(loc);
    }

    @Generated
    private PBRTextureEngine() {
    }

    static {
        intArray = null;
        intBuffer = null;
    }
}

