/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.resources;

import com.ventooth.swansong.Share;
import com.ventooth.swansong.config.Configs;
import com.ventooth.swansong.config.ShadersConfig;
import com.ventooth.swansong.resources.pack.DefaultShaderPack;
import com.ventooth.swansong.resources.pack.ResolvedShaderPack;
import com.ventooth.swansong.resources.pack.ShaderPack;
import com.ventooth.swansong.shader.ShaderEngine;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public final class ShaderPackManager {
    private static final Logger log = Share.getLogger();
    public static final String DISABLED_SHADER_PACK_NAME = "(disabled)";
    public static String currentShaderPackName = "(disabled)";
    private static Path shaderpacksDir;
    private static Path shaderpacksDebugDir;
    private static List<String> detectedShaderpacks;

    public static void init() {
        Path minecraftDir = Minecraft.func_71410_x().field_71412_D.toPath();
        shaderpacksDir = minecraftDir.resolve("shaderpacks");
        shaderpacksDebugDir = shaderpacksDir.resolve("debug");
        ShaderPackManager.ensureDirExists("Shader Pack", shaderpacksDir);
        ShaderPackManager.refreshShaderPackNames();
        ShaderPackManager.setShaderPackByName(ShadersConfig.CurrentShaderPack);
    }

    public static File resolveFile(String name) {
        return ShaderPackManager.resolvePath(name).toFile();
    }

    public static Path resolvePath(String name) {
        return shaderpacksDir.resolve(name);
    }

    public static void cleanDebugDir() throws IOException {
        ShaderPackManager.ensureDirExists("Shader Pack Debug output", shaderpacksDebugDir);
        FileUtils.cleanDirectory((File)shaderpacksDebugDir.toFile());
    }

    public static void dumpShader(String name, String src) throws IOException {
        ShaderPackManager.ensureDirExists("Shader Pack Debug output", shaderpacksDebugDir);
        FileUtils.write((File)shaderpacksDebugDir.resolve(name).toFile(), (CharSequence)src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpShader(String name, ByteBuffer src) {
        try {
            File file = shaderpacksDebugDir.resolve(name).toFile();
            ShaderPackManager.ensureDirExists("Shader Pack Debug output", file.toPath().getParent());
            FileOutputStream fileOut = new FileOutputStream(shaderpacksDebugDir.resolve(name).toFile());
            try {
                ByteBuffer theSlice = src.slice();
                theSlice.limit(theSlice.limit() - 1);
                FileChannel fc = fileOut.getChannel();
                while (theSlice.remaining() > 0) {
                    fc.write(theSlice);
                }
                fc.close();
            }
            finally {
                if (Collections.singletonList(fileOut).get(0) != null) {
                    fileOut.close();
                }
            }
        }
        catch (IOException e) {
            Share.log.error("Failed to dump shader: ", (Throwable)e);
        }
    }

    private static void ensureDirExists(String name, Path dir) {
        if (Files.isDirectory(dir, new LinkOption[0])) {
            return;
        }
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            Share.log.debug("Created dir ({}): {}", new Object[]{name, dir});
        }
        catch (IOException e) {
            Share.log.fatal("Failed to create dir ({}): {}", new Object[]{name, dir});
            throw new UncheckedIOException(e);
        }
    }

    public static void saveShaderSettings() {
        ShaderEngine.scheduleShaderPackReload();
        Configs.syncConfigFile();
    }

    public static void openShaderPacksDir() {
        try {
            Desktop.getDesktop().open(shaderpacksDir.toFile());
        }
        catch (IOException e) {
            Share.log.error("Failed to open shaderpacks directory", (Throwable)e);
        }
    }

    public static String getCurrentShaderPackName() {
        return currentShaderPackName;
    }

    public static void setShaderPackByName(String shaderPackName) {
        currentShaderPackName = detectedShaderpacks.contains(shaderPackName) ? shaderPackName : DISABLED_SHADER_PACK_NAME;
        ShadersConfig.CurrentShaderPack = currentShaderPackName;
        ShaderPackManager.saveShaderSettings();
    }

    public static void refreshShaderPackNames() {
        ArrayList<String> newShaders = new ArrayList<String>();
        try {
            Stream<Path> shadersDir = Files.list(shaderpacksDir);
            try {
                shadersDir.forEach(subPath -> {
                    block13: {
                        if (Objects.equals(subPath, shaderpacksDebugDir)) {
                            return;
                        }
                        try {
                            Path nestDir;
                            Path realPath = subPath.toRealPath(new LinkOption[0]);
                            if (Files.isRegularFile(realPath, new LinkOption[0])) {
                                try (ZipFile zip2 = new ZipFile(realPath.toFile());){
                                    Enumeration<? extends ZipEntry> entries = zip2.entries();
                                    while (entries.hasMoreElements()) {
                                        ZipEntry entry = entries.nextElement();
                                        String name = entry.getName();
                                        if (!"shaders".equals(name) && !name.startsWith("shaders/")) continue;
                                        newShaders.add(subPath.getFileName().toString());
                                        break block13;
                                    }
                                    break block13;
                                }
                                catch (IOException zip2) {}
                                break block13;
                            }
                            if (Files.isDirectory(realPath, new LinkOption[0]) && Files.isDirectory(nestDir = realPath.resolve("shaders").toRealPath(new LinkOption[0]), new LinkOption[0])) {
                                newShaders.add(subPath.getFileName().toString());
                            }
                        }
                        catch (IOException e) {
                            Share.log.error("Error while processing shaderpack {}", new Object[]{subPath.getFileName().toString()});
                            Share.log.error("Stacktrace:", (Throwable)e);
                        }
                    }
                });
                newShaders.sort(Comparator.naturalOrder());
                if (ShadersConfig.enableReferenceShaderPack) {
                    newShaders.add(0, "(default)");
                }
                newShaders.add(0, DISABLED_SHADER_PACK_NAME);
                detectedShaderpacks = newShaders;
            }
            finally {
                if (Collections.singletonList(shadersDir).get(0) != null) {
                    shadersDir.close();
                }
            }
        }
        catch (IOException e) {
            Share.log.error("Error while detecting shaderpacks. Using fallback.", (Throwable)e);
            detectedShaderpacks = Arrays.asList(DISABLED_SHADER_PACK_NAME, "(default)");
        }
    }

    public static @UnmodifiableView List<String> getShaderPackNames() {
        return Collections.unmodifiableList(detectedShaderpacks);
    }

    @Nullable
    public static ShaderPack createShaderPack() {
        if (DISABLED_SHADER_PACK_NAME.equals(currentShaderPackName)) {
            return null;
        }
        if ("(default)".equals(currentShaderPackName)) {
            if (ShadersConfig.enableReferenceShaderPack) {
                return DefaultShaderPack.INSTANCE;
            }
            return null;
        }
        ResolvedShaderPack.Builder builder = new ResolvedShaderPack.Builder(currentShaderPackName);
        boolean successful = false;
        try {
            Path theFile = shaderpacksDir.resolve(currentShaderPackName).toRealPath(new LinkOption[0]);
            if (Files.isDirectory(theFile, new LinkOption[0])) {
                successful = ShaderPackManager.createDirShaderPack(theFile, builder);
            } else if (Files.isRegularFile(theFile, new LinkOption[0])) {
                successful = ShaderPackManager.createFileShaderPack(theFile, builder);
            }
        }
        catch (IOException e) {
            log.error("Exception in loading shader pack:", (Throwable)e);
        }
        if (successful) {
            return builder.build();
        }
        log.error("Failed to load shader pack named \"" + currentShaderPackName + "\"");
        ShaderPackManager.setShaderPackByName(DISABLED_SHADER_PACK_NAME);
        return null;
    }

    public static void saveShaderPackConfig(List<String> dataz) {
        try {
            Files.write(shaderpacksDir.resolve(currentShaderPackName + ".txt"), dataz, new OpenOption[0]);
        }
        catch (IOException e) {
            log.error("Failed to save shader pack config:", (Throwable)e);
        }
    }

    public static byte @Nullable [] readShaderPackConfig() {
        Path configPath = shaderpacksDir.resolve(currentShaderPackName + ".txt");
        if (!Files.isRegularFile(configPath, new LinkOption[0])) {
            return null;
        }
        try {
            return Files.readAllBytes(configPath);
        }
        catch (IOException e) {
            log.error("Failed to load shader pack config:", (Throwable)e);
            return null;
        }
    }

    private static boolean createDirShaderPack(final Path theFile, final ResolvedShaderPack.Builder builder) throws IOException {
        Files.walkFileTree(theFile, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public FileVisitResult visitFile(@NotNull Path file, BasicFileAttributes attrs) throws IOException {
                if (!Files.isRegularFile(file, new LinkOption[0])) {
                    return super.visitFile(file, attrs);
                }
                InputStream input = Files.newInputStream(file, new OpenOption[0]);
                try {
                    String rPath = theFile.relativize(file).toString();
                    if (File.separatorChar != '/') {
                        rPath = rPath.replace(File.separatorChar, '/');
                    }
                    builder.add(rPath, input);
                    FileVisitResult fileVisitResult = super.visitFile(file, attrs);
                    return fileVisitResult;
                }
                finally {
                    if (Collections.singletonList(input).get(0) != null) {
                        input.close();
                    }
                }
            }

            @Override
            public FileVisitResult preVisitDirectory(@NotNull Path dir, BasicFileAttributes attrs) throws IOException {
                Path rPath = theFile.relativize(dir);
                if (rPath.getNameCount() == 2 && rPath.getName(0).toString().equals("shaders") && rPath.getName(1).toString().startsWith("world")) {
                    String worldSuffix = rPath.getName(1).toString().substring("world".length());
                    try {
                        int worldIndex = Integer.parseInt(worldSuffix);
                        if (worldIndex == 0) {
                            builder.hasWorld0();
                        }
                        builder.addSpecialization(new ResolvedShaderPack.WorldSpecializationPredicate.ByID(worldIndex, "world" + worldSuffix));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return super.preVisitDirectory(dir, attrs);
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean createFileShaderPack(Path theFile, ResolvedShaderPack.Builder builder) throws IOException {
        String fileName = theFile.getFileName().toString();
        if (!fileName.endsWith(".zip")) {
            return false;
        }
        ZipFile zipFile = new ZipFile(theFile.toFile());
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (entry.isDirectory()) {
                    String[] parts = name.split("/");
                    if (parts.length != 2 || !parts[0].equals("shaders") || !parts[1].startsWith("world")) continue;
                    String worldSuffix = parts[1].substring("world".length());
                    try {
                        int worldIndex = Integer.parseInt(worldSuffix);
                        if (worldIndex == 0) {
                            builder.hasWorld0();
                        }
                        builder.addSpecialization(new ResolvedShaderPack.WorldSpecializationPredicate.ByID(worldIndex, "world" + worldSuffix));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                builder.add(name, zipFile.getInputStream(entry));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (Collections.singletonList(zipFile).get(0) != null) {
                zipFile.close();
            }
        }
    }

    @Generated
    private ShaderPackManager() {
    }

    static {
        detectedShaderpacks = ShadersConfig.enableReferenceShaderPack ? Arrays.asList(DISABLED_SHADER_PACK_NAME, "(default)") : Collections.singletonList(DISABLED_SHADER_PACK_NAME);
    }
}

