/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.resources.pack;

import com.ventooth.swansong.Share;
import com.ventooth.swansong.resources.pack.InternalShaderPack;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class ModJarContainer {
    public static final Logger log = Share.getLogger();
    private static JarFile jar;

    public static InputStream getInputStream(@NonNull ZipEntry entry) throws IOException {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        return ModJarContainer.get().getInputStream(entry);
    }

    @Nullable
    public static ZipEntry getEntry(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return ModJarContainer.get().getEntry(name);
    }

    public static JarFile get() {
        if (jar == null) {
            throw new IllegalStateException("Not Initialized!");
        }
        return jar;
    }

    public static void init() {
        String jarPath;
        if (jar != null) {
            log.debug("Mod jar already loaded?? Yeah, it's here: {}", new Object[]{jar.getName()});
            return;
        }
        log.debug("Looking for the uh, mod jar?");
        try {
            URL jarUrl = InternalShaderPack.class.getProtectionDomain().getCodeSource().getLocation();
            jarPath = URLDecoder.decode(jarUrl.getPath(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"Unreachable");
        }
        log.debug("Base path: {}", new Object[]{jarPath});
        int exclIndex = jarPath.indexOf(33);
        if (exclIndex >= 0) {
            jarPath = jarPath.substring(0, exclIndex);
        }
        if (jarPath.startsWith("file:")) {
            jarPath = jarPath.substring("file:".length());
        }
        log.debug("Trimmed path: {}", new Object[]{jarPath});
        try {
            jar = new JarFile(jarPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        log.info("Found own mod jar: {}", new Object[]{jarPath});
    }

    @Generated
    private ModJarContainer() {
    }
}

