/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader;

import com.ventooth.swansong.shader.CompositeTextureData;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public final class BufferNameUtil {
    private BufferNameUtil() {
    }

    @Nullable
    public static CompositeTextureData gbufferIndexFromName(String name) {
        for (CompositeTextureData data : CompositeTextureData.values()) {
            if (!ArrayUtils.contains((Object[])data.names(), (Object)name)) continue;
            return data;
        }
        return null;
    }

    public static int gbufferFormatFromName(String name) {
        int n;
        switch (name) {
            case "R8": {
                n = 33321;
                break;
            }
            case "RG8": {
                n = 33323;
                break;
            }
            case "RGB8": {
                n = 32849;
                break;
            }
            case "RGBA8": {
                n = 32856;
                break;
            }
            case "R8_SNORM": {
                n = 36756;
                break;
            }
            case "RG8_SNORM": {
                n = 36757;
                break;
            }
            case "RGB8_SNORM": {
                n = 36758;
                break;
            }
            case "RGBA8_SNORM": {
                n = 36759;
                break;
            }
            case "R16": {
                n = 33322;
                break;
            }
            case "RG16": {
                n = 33324;
                break;
            }
            case "RGB16": {
                n = 32852;
                break;
            }
            case "RGBA16": {
                n = 32859;
                break;
            }
            case "R16_SNORM": {
                n = 36760;
                break;
            }
            case "RG16_SNORM": {
                n = 36761;
                break;
            }
            case "RGB16_SNORM": {
                n = 36762;
                break;
            }
            case "RGBA16_SNORM": {
                n = 36763;
                break;
            }
            case "R16F": {
                n = 33325;
                break;
            }
            case "RG16F": {
                n = 33327;
                break;
            }
            case "RGB16F": {
                n = 34843;
                break;
            }
            case "RGBA16F": {
                n = 34842;
                break;
            }
            case "R32F": {
                n = 33326;
                break;
            }
            case "RG32F": {
                n = 33328;
                break;
            }
            case "RGB32F": {
                n = 34837;
                break;
            }
            case "RGBA32F": {
                n = 34836;
                break;
            }
            case "R32I": {
                n = 33333;
                break;
            }
            case "RG32I": {
                n = 33339;
                break;
            }
            case "RGB32I": {
                n = 36227;
                break;
            }
            case "RGBA32I": {
                n = 36226;
                break;
            }
            case "R32UI": {
                n = 33334;
                break;
            }
            case "RG32UI": {
                n = 33340;
                break;
            }
            case "RGB32UI": {
                n = 36209;
                break;
            }
            case "RGBA32UI": {
                n = 36208;
                break;
            }
            case "R3_G3_B2": {
                n = 10768;
                break;
            }
            case "RGB5_A1": {
                n = 32855;
                break;
            }
            case "RGB10_A2": {
                n = 32857;
                break;
            }
            case "R11F_G11F_B10F": {
                n = 35898;
                break;
            }
            case "RGB9_E5": {
                n = 35901;
                break;
            }
            default: {
                n = -1;
            }
        }
        return n;
    }

    public static String gbufferFormatNameFromEnum(int glEnum) {
        String string;
        switch (glEnum) {
            case 33321: {
                string = "R8";
                break;
            }
            case 33323: {
                string = "RG8";
                break;
            }
            case 32849: {
                string = "RGB8";
                break;
            }
            case 32856: {
                string = "RGBA8";
                break;
            }
            case 36756: {
                string = "R8_SNORM";
                break;
            }
            case 36757: {
                string = "RG8_SNORM";
                break;
            }
            case 36758: {
                string = "RGB8_SNORM";
                break;
            }
            case 36759: {
                string = "RGBA8_SNORM";
                break;
            }
            case 33322: {
                string = "R16";
                break;
            }
            case 33324: {
                string = "RG16";
                break;
            }
            case 32852: {
                string = "RGB16";
                break;
            }
            case 32859: {
                string = "RGBA16";
                break;
            }
            case 36760: {
                string = "R16_SNORM";
                break;
            }
            case 36761: {
                string = "RG16_SNORM";
                break;
            }
            case 36762: {
                string = "RGB16_SNORM";
                break;
            }
            case 36763: {
                string = "RGBA16_SNORM";
                break;
            }
            case 33325: {
                string = "R16F";
                break;
            }
            case 33327: {
                string = "RG16F";
                break;
            }
            case 34843: {
                string = "RGB16F";
                break;
            }
            case 34842: {
                string = "RGBA16F";
                break;
            }
            case 33326: {
                string = "R32F";
                break;
            }
            case 33328: {
                string = "RG32F";
                break;
            }
            case 34837: {
                string = "RGB32F";
                break;
            }
            case 34836: {
                string = "RGBA32F";
                break;
            }
            case 33333: {
                string = "R32I";
                break;
            }
            case 33339: {
                string = "RG32I";
                break;
            }
            case 36227: {
                string = "RGB32I";
                break;
            }
            case 36226: {
                string = "RGBA32I";
                break;
            }
            case 33334: {
                string = "R32UI";
                break;
            }
            case 33340: {
                string = "RG32UI";
                break;
            }
            case 36209: {
                string = "RGB32UI";
                break;
            }
            case 36208: {
                string = "RGBA32UI";
                break;
            }
            case 10768: {
                string = "R3_G3_B2";
                break;
            }
            case 32855: {
                string = "RGB5_A1";
                break;
            }
            case 32857: {
                string = "RGB10_A2";
                break;
            }
            case 35898: {
                string = "R11F_G11F_B10F";
                break;
            }
            case 35901: {
                string = "RGB9_E5";
                break;
            }
            case 6407: {
                string = "RGB";
                break;
            }
            case 6408: {
                string = "RGBA";
                break;
            }
            case 6402: {
                string = "DEPTH_COMPONENT";
                break;
            }
            default: {
                string = "UNKNOWN";
            }
        }
        return string;
    }
}

