/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader;

import com.ventooth.swansong.EnvInfo;
import com.ventooth.swansong.Share;
import com.ventooth.swansong.config.ShadersConfig;
import com.ventooth.swansong.pbr.PBRTextureEngine;
import com.ventooth.swansong.resources.ShaderPackManager;
import com.ventooth.swansong.resources.pack.DefaultShaderPack;
import com.ventooth.swansong.resources.pack.InternalShaderPack;
import com.ventooth.swansong.resources.pack.ShaderPack;
import com.ventooth.swansong.shader.BufferNameUtil;
import com.ventooth.swansong.shader.CompositeTextureData;
import com.ventooth.swansong.shader.DepthSampler;
import com.ventooth.swansong.shader.DrawBuffers;
import com.ventooth.swansong.shader.Report;
import com.ventooth.swansong.shader.ShaderBinding;
import com.ventooth.swansong.shader.ShaderException;
import com.ventooth.swansong.shader.ShaderState;
import com.ventooth.swansong.shader.ShaderTypes;
import com.ventooth.swansong.shader.ShadowProperties;
import com.ventooth.swansong.shader.config.ConfigEntry;
import com.ventooth.swansong.shader.loader.MultiShaderPool;
import com.ventooth.swansong.shader.loader.ShaderLoader;
import com.ventooth.swansong.shader.loader.ShaderLoaderInParams;
import com.ventooth.swansong.shader.loader.ShaderLoaderOutParams;
import com.ventooth.swansong.shader.mappings.BlockIDRemapper;
import com.ventooth.swansong.shader.shaderobjects.ManagedShader;
import com.ventooth.swansong.shader.texbuf.BufferConfig;
import com.ventooth.swansong.shader.uniform.CompiledUniforms;
import com.ventooth.swansong.shader.uniform.GeneralUniforms;
import com.ventooth.swansong.shader.uniform.UniformGetterDanglingWires;
import com.ventooth.swansong.todo.tess.DanglingWiresTess;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import lombok.Generated;
import net.minecraft.client.resources.Locale;
import net.minecraft.world.WorldProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

class FixedEngineState {
    @Nullable
    public final WorldProvider dimension;
    @NotNull
    public final ShaderPack pack;
    @NotNull
    public final ShaderBinding manager;
    @NotNull
    public final Map<CompositeTextureData, BufferConfig> colorDrawBufferConfigs;
    @Nullable
    public final BlockIDRemapper remapper;
    @Nullable
    public final DepthSampler depthSampler;
    @Nullable
    public final ShadowProperties shadow;
    @Nullable
    public final CompiledUniforms compiledUniforms;
    @NotNull
    public final @Unmodifiable ObjectList<ShaderLoaderOutParams.StagedTexture> textures;
    @Nullable
    public final String noiseTexPath;
    @Nullable
    public final Integer noiseTexSize;
    public final ConfigEntry.RootScreen configScreen;
    public final Locale locale;

    private static ShaderLoader createLoader(ShaderPack pack, @Nullable WorldProvider dimension) {
        ShaderLoader loader = new ShaderLoader(pack, dimension);
        loader.inExpectedShaders = ShaderTypes.general;
        loader.inAttribs = DanglingWiresTess.attribs;
        loader.inParams = ShaderLoaderInParams.builder().handDepth(ShadersConfig.HandDepth.get()).renderQuality(ShadersConfig.RenderQuality.get()).shadowQuality(ShadersConfig.ShadowQuality.get()).build();
        loader.inShaderConfig = ShaderPackManager.readShaderPackConfig();
        loader.inEnvInfo = EnvInfo.get();
        loader.inMcUniforms = GeneralUniforms.getFuncRegistry();
        return loader;
    }

    @Nullable
    public static FixedEngineState init(@Nullable WorldProvider dimension, @Nullable Report report) {
        FixedEngineStateBuilder b = FixedEngineState.builder();
        b.dimension = dimension;
        try {
            ShaderPackManager.cleanDebugDir();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ShaderPack pack = ShaderPackManager.createShaderPack();
        if (pack == null) {
            return null;
        }
        b.pack = pack;
        b.remapper = BlockIDRemapper.createRemapper(pack);
        if (report != null) {
            report.name = pack.name();
        }
        ShaderLoader mainLoader = FixedEngineState.createLoader(pack, dimension);
        ArrayList<ShaderLoader> loaders = new ArrayList<ShaderLoader>();
        if (pack != DefaultShaderPack.INSTANCE) {
            loaders.add(FixedEngineState.createLoader(DefaultShaderPack.INSTANCE, dimension));
        }
        loaders.add(FixedEngineState.createLoader(InternalShaderPack.INSTANCE, dimension));
        mainLoader.load(report);
        b.configScreen = mainLoader.outConfigScreen;
        b.locale = mainLoader.outLocale;
        b.compiledUniforms = mainLoader.outCompiledUniforms;
        UniformGetterDanglingWires.customUniforms = b.compiledUniforms != null ? b.compiledUniforms.wrapUniforms() : null;
        ShaderLoaderOutParams outParams = mainLoader.outParams;
        if (report != null) {
            report.rpleCompatible = outParams.rpleCompatible;
        }
        b.textures = outParams.textures;
        b.noiseTexPath = outParams.noiseTexture;
        b.noiseTexSize = outParams.noiseTextureResolution;
        PBRTextureEngine.init();
        if (ShadersConfig.LetMeUseDepthOfFieldPlease) {
            b.depthSampler = new DepthSampler();
            b.depthSampler.init();
        }
        try (MultiShaderPool shaderPool = new MultiShaderPool(mainLoader.borrowOutShaderPool(), loaders, report);){
            b.manager = ShaderBinding.init(shaderPool, dimension);
            if (((FixedEngineStateBuilder)b).manager.shadow != null) {
                b.shadow = ShadowProperties.from(outParams, ShadersConfig.ShadowQuality.get());
            }
            ShaderState.applyParams(outParams);
        }
        catch (ShaderException e) {
            throw new AssertionError((Object)e);
        }
        EnumMap<CompositeTextureData, BufferConfig.Builder> configBuilders = new EnumMap<CompositeTextureData, BufferConfig.Builder>(CompositeTextureData.class);
        for (ManagedShader shader : ((FixedEngineStateBuilder)b).manager.loadedShaders) {
            IntList renderTargets = shader.renderTargets();
            int size = renderTargets.size();
            Report.ShaderInfo info = report == null ? null : report.foundShaders.computeIfAbsent(shader.srcPath(), path -> new Report.ShaderInfo());
            for (int i = 0; i < size; ++i) {
                int renderTargetIndex = renderTargets.getInt(i);
                CompositeTextureData renderTarget = DrawBuffers.textureFromColorTexIndex(renderTargetIndex);
                if (renderTarget == null) {
                    Share.log.warn("Invalid render target index: {}", new Object[]{renderTargetIndex});
                    continue;
                }
                BufferConfig.Builder configBuilder = configBuilders.computeIfAbsent(renderTarget, index -> BufferConfig.builder().name(index.name()));
                if (info == null) continue;
                info.renderTargets.add(configBuilder.name);
            }
        }
        for (String disabled : outParams.bufferClearDisabled) {
            CompositeTextureData index2 = BufferNameUtil.gbufferIndexFromName(disabled);
            if (index2 == null) {
                Share.log.info("INVALID color gbuffer name: {} tried to set disabled clear", new Object[]{disabled});
                continue;
            }
            BufferConfig.Builder builder2 = (BufferConfig.Builder)configBuilders.get((Object)index2);
            if (builder2 == null) {
                Share.log.info("Ignored gbuffer color thing: {}  clear (not used?)", new Object[]{disabled});
                continue;
            }
            builder2.clear(false);
        }
        for (Object2ObjectMap.Entry entry : Object2ObjectMaps.fastIterable(outParams.bufferFormat)) {
            String nameStr = (String)entry.getKey();
            String formatStr = (String)entry.getValue();
            CompositeTextureData index3 = BufferNameUtil.gbufferIndexFromName(nameStr);
            if (index3 == null) {
                Share.log.warn("INVALID color gbuffer name: {} tried to set format={}", new Object[]{nameStr, formatStr});
                continue;
            }
            BufferConfig.Builder builder3 = (BufferConfig.Builder)configBuilders.get((Object)index3);
            if (builder3 == null) {
                if (report == null) continue;
                report.drawBuffers.put(index3.name(), new Report.DrawBufferInfo(true, formatStr));
                continue;
            }
            int format = BufferNameUtil.gbufferFormatFromName(formatStr);
            if (format == -1) {
                Share.log.warn("Color gbuffer: {} tried to set INVALID format={}", new Object[]{formatStr, nameStr});
                continue;
            }
            if (report != null) {
                report.drawBuffers.put(index3.name(), new Report.DrawBufferInfo(false, formatStr));
            }
            builder3.format(format);
        }
        EnumMap bufferConfigs = new EnumMap(CompositeTextureData.class);
        configBuilders.forEach((tex, builder) -> bufferConfigs.put((CompositeTextureData)((Object)tex), builder.build()));
        b.colorDrawBufferConfigs = Collections.unmodifiableMap(bufferConfigs);
        loaders.forEach(ShaderLoader::reset);
        return b.build();
    }

    public void deinit() {
        if (this.depthSampler != null) {
            this.depthSampler.deinit();
        }
        PBRTextureEngine.deinit();
        this.manager.deinit();
    }

    @Generated
    FixedEngineState(@Nullable WorldProvider dimension, @NotNull ShaderPack pack, @NotNull ShaderBinding manager, @NotNull Map<CompositeTextureData, BufferConfig> colorDrawBufferConfigs, @Nullable BlockIDRemapper remapper, @Nullable DepthSampler depthSampler, @Nullable ShadowProperties shadow, @Nullable CompiledUniforms compiledUniforms, @NotNull ObjectList<ShaderLoaderOutParams.StagedTexture> textures, @Nullable String noiseTexPath, @Nullable Integer noiseTexSize, ConfigEntry.RootScreen configScreen, Locale locale) {
        if (pack == null) {
            throw new NullPointerException("pack is marked non-null but is null");
        }
        if (manager == null) {
            throw new NullPointerException("manager is marked non-null but is null");
        }
        if (colorDrawBufferConfigs == null) {
            throw new NullPointerException("colorDrawBufferConfigs is marked non-null but is null");
        }
        if (textures == null) {
            throw new NullPointerException("textures is marked non-null but is null");
        }
        this.dimension = dimension;
        this.pack = pack;
        this.manager = manager;
        this.colorDrawBufferConfigs = colorDrawBufferConfigs;
        this.remapper = remapper;
        this.depthSampler = depthSampler;
        this.shadow = shadow;
        this.compiledUniforms = compiledUniforms;
        this.textures = textures;
        this.noiseTexPath = noiseTexPath;
        this.noiseTexSize = noiseTexSize;
        this.configScreen = configScreen;
        this.locale = locale;
    }

    @Generated
    private static FixedEngineStateBuilder builder() {
        return new FixedEngineStateBuilder();
    }

    @Generated
    private static class FixedEngineStateBuilder {
        @Generated
        private WorldProvider dimension;
        @Generated
        private ShaderPack pack;
        @Generated
        private ShaderBinding manager;
        @Generated
        private Map<CompositeTextureData, BufferConfig> colorDrawBufferConfigs;
        @Generated
        private BlockIDRemapper remapper;
        @Generated
        private DepthSampler depthSampler;
        @Generated
        private ShadowProperties shadow;
        @Generated
        private CompiledUniforms compiledUniforms;
        @Generated
        private ObjectList<ShaderLoaderOutParams.StagedTexture> textures;
        @Generated
        private String noiseTexPath;
        @Generated
        private Integer noiseTexSize;
        @Generated
        private ConfigEntry.RootScreen configScreen;
        @Generated
        private Locale locale;

        @Generated
        FixedEngineStateBuilder() {
        }

        @Generated
        private FixedEngineStateBuilder dimension(@Nullable WorldProvider dimension) {
            this.dimension = dimension;
            return this;
        }

        @Generated
        private FixedEngineStateBuilder pack(@NotNull ShaderPack pack) {
            if (pack == null) {
                throw new NullPointerException("pack is marked non-null but is null");
            }
            this.pack = pack;
            return this;
        }

        @Generated
        private FixedEngineStateBuilder manager(@NotNull ShaderBinding manager) {
            if (manager == null) {
                throw new NullPointerException("manager is marked non-null but is null");
            }
            this.manager = manager;
            return this;
        }

        @Generated
        private FixedEngineStateBuilder colorDrawBufferConfigs(@NotNull Map<CompositeTextureData, BufferConfig> colorDrawBufferConfigs) {
            if (colorDrawBufferConfigs == null) {
                throw new NullPointerException("colorDrawBufferConfigs is marked non-null but is null");
            }
            this.colorDrawBufferConfigs = colorDrawBufferConfigs;
            return this;
        }

        @Generated
        private FixedEngineStateBuilder remapper(@Nullable BlockIDRemapper remapper) {
            this.remapper = remapper;
            return this;
        }

        @Generated
        private FixedEngineStateBuilder depthSampler(@Nullable DepthSampler depthSampler) {
            this.depthSampler = depthSampler;
            return this;
        }

        @Generated
        private FixedEngineStateBuilder shadow(@Nullable ShadowProperties shadow) {
            this.shadow = shadow;
            return this;
        }

        @Generated
        private FixedEngineStateBuilder compiledUniforms(@Nullable CompiledUniforms compiledUniforms) {
            this.compiledUniforms = compiledUniforms;
            return this;
        }

        @Generated
        private FixedEngineStateBuilder textures(@NotNull ObjectList<ShaderLoaderOutParams.StagedTexture> textures) {
            if (textures == null) {
                throw new NullPointerException("textures is marked non-null but is null");
            }
            this.textures = textures;
            return this;
        }

        @Generated
        private FixedEngineStateBuilder noiseTexPath(@Nullable String noiseTexPath) {
            this.noiseTexPath = noiseTexPath;
            return this;
        }

        @Generated
        private FixedEngineStateBuilder noiseTexSize(@Nullable Integer noiseTexSize) {
            this.noiseTexSize = noiseTexSize;
            return this;
        }

        @Generated
        private FixedEngineStateBuilder configScreen(ConfigEntry.RootScreen configScreen) {
            this.configScreen = configScreen;
            return this;
        }

        @Generated
        private FixedEngineStateBuilder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        @Generated
        private FixedEngineState build() {
            return new FixedEngineState(this.dimension, this.pack, this.manager, this.colorDrawBufferConfigs, this.remapper, this.depthSampler, this.shadow, this.compiledUniforms, this.textures, this.noiseTexPath, this.noiseTexSize, this.configScreen, this.locale);
        }

        @Generated
        public String toString() {
            return "FixedEngineState.FixedEngineStateBuilder(dimension=" + this.dimension + ", pack=" + this.pack + ", manager=" + this.manager + ", colorDrawBufferConfigs=" + this.colorDrawBufferConfigs + ", remapper=" + this.remapper + ", depthSampler=" + this.depthSampler + ", shadow=" + this.shadow + ", compiledUniforms=" + this.compiledUniforms + ", textures=" + this.textures + ", noiseTexPath=" + this.noiseTexPath + ", noiseTexSize=" + this.noiseTexSize + ", configScreen=" + this.configScreen + ", locale=" + this.locale + ")";
        }
    }
}

