/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader;

import com.ventooth.swansong.shader.ShaderEngine;
import lombok.Generated;
import net.minecraft.block.Block;

public final class ShaderEntityData {
    public static final int SKY = -2;
    public static final int CLOUDS = -3;
    private static final ThreadLocal<ShaderEntityData> instances = ThreadLocal.withInitial(ShaderEntityData::new);
    private int[] entityData = new int[32];
    private int entityDataIndex = 0;

    public static ShaderEntityData get() {
        return instances.get();
    }

    public void reset() {
        this.entityData = new int[32];
        this.entityDataIndex = 0;
    }

    public void pushEntity(int data0) {
        this.pushEntity(data0, 0);
    }

    public void pushEntity(int data0, int data1) {
        ++this.entityDataIndex;
        this.entityData[this.entityDataIndex * 2] = data0 & 0xFFFF | data1 << 16;
        this.entityData[this.entityDataIndex * 2 + 1] = 0;
    }

    public void pushEntity(Block block) {
        this.pushEntity(block, 0);
    }

    public void pushEntity(Block block, int meta) {
        ++this.entityDataIndex;
        this.entityData[this.entityDataIndex * 2] = ShaderEngine.getBlockID(block, meta) & 0xFFFF | block.func_149645_b() << 16;
        this.entityData[this.entityDataIndex * 2 + 1] = meta;
    }

    public int getEntityData() {
        return this.entityData[this.entityDataIndex * 2];
    }

    public int getEntityData2() {
        return this.entityData[this.entityDataIndex * 2 + 1];
    }

    public void popEntity() {
        this.entityData[this.entityDataIndex * 2] = 0;
        this.entityData[this.entityDataIndex * 2 + 1] = 0;
        --this.entityDataIndex;
    }

    @Generated
    private ShaderEntityData() {
    }
}

