/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader;

import com.ventooth.swansong.shader.loader.ShaderLoaderOutParams;
import java.util.Arrays;
import lombok.Generated;

public class ShadowProperties {
    private static final int NUM_SHADOW_PASSES = 2;
    public final int resolution;
    public final Double fov;
    public final double distance;
    public final double intervalSize;
    private final Pass[] passes;

    public boolean depthHWFilterEnabled(int pass) {
        ShadowProperties.assertPassValid(pass);
        return this.passes[pass].depthHWFilterEnabled;
    }

    public boolean depthFilterNearest(int pass) {
        ShadowProperties.assertPassValid(pass);
        return this.passes[pass].depthFilterNearest;
    }

    public boolean depthMipmapEnabled(int pass) {
        ShadowProperties.assertPassValid(pass);
        return this.passes[pass].depthMipmapEnabled;
    }

    public boolean colorFilterNearest(int pass) {
        ShadowProperties.assertPassValid(pass);
        return this.passes[pass].colorFilterNearest;
    }

    public boolean colorMipmapEnabled(int pass) {
        ShadowProperties.assertPassValid(pass);
        return this.passes[pass].colorMipmapEnabled;
    }

    private static void assertPassValid(int pass) {
        if (pass < 0 || pass >= 2) {
            throw new IllegalArgumentException("Invalid shadow pass " + pass);
        }
    }

    public static ShadowProperties from(ShaderLoaderOutParams outParams, float quality) {
        ShadowPropertiesBuilder builder = ShadowProperties.builder();
        builder.resolution((int)((float)outParams.shadowMapResolution * quality));
        builder.fov(outParams.shadowMapFov);
        builder.distance(outParams.shadowDistance);
        builder.intervalSize(outParams.shadowIntervalSize);
        Pass.PassBuilder pass0 = Pass.builder();
        Pass.PassBuilder pass1 = Pass.builder();
        pass0.depthHWFilterEnabled(outParams.shadowHardwareFiltering0);
        pass1.depthHWFilterEnabled(outParams.shadowHardwareFiltering1);
        pass0.depthFilterNearest(outParams.shadowDepth0Nearest);
        pass1.depthFilterNearest(outParams.shadowDepth1Nearest);
        pass0.depthMipmapEnabled(outParams.shadowDepth0Mipmap);
        pass1.depthMipmapEnabled(outParams.shadowDepth1Mipmap);
        pass0.colorFilterNearest(outParams.shadowColor0Nearest);
        pass1.colorFilterNearest(outParams.shadowColor1Nearest);
        pass0.colorMipmapEnabled(outParams.shadowColor0Mipmap);
        pass1.colorMipmapEnabled(outParams.shadowColor1Mipmap);
        builder.passes(new Pass[]{pass0.build(), pass1.build()});
        return builder.build();
    }

    @Generated
    ShadowProperties(int resolution, Double fov, double distance, double intervalSize, Pass[] passes) {
        this.resolution = resolution;
        this.fov = fov;
        this.distance = distance;
        this.intervalSize = intervalSize;
        this.passes = passes;
    }

    @Generated
    private static ShadowPropertiesBuilder builder() {
        return new ShadowPropertiesBuilder();
    }

    public static class Pass {
        public final boolean depthHWFilterEnabled;
        public final boolean depthFilterNearest;
        public final boolean depthMipmapEnabled;
        public final boolean colorFilterNearest;
        public final boolean colorMipmapEnabled;

        @Generated
        Pass(boolean depthHWFilterEnabled, boolean depthFilterNearest, boolean depthMipmapEnabled, boolean colorFilterNearest, boolean colorMipmapEnabled) {
            this.depthHWFilterEnabled = depthHWFilterEnabled;
            this.depthFilterNearest = depthFilterNearest;
            this.depthMipmapEnabled = depthMipmapEnabled;
            this.colorFilterNearest = colorFilterNearest;
            this.colorMipmapEnabled = colorMipmapEnabled;
        }

        @Generated
        public static PassBuilder builder() {
            return new PassBuilder();
        }

        @Generated
        public static class PassBuilder {
            @Generated
            private boolean depthHWFilterEnabled;
            @Generated
            private boolean depthFilterNearest;
            @Generated
            private boolean depthMipmapEnabled;
            @Generated
            private boolean colorFilterNearest;
            @Generated
            private boolean colorMipmapEnabled;

            @Generated
            PassBuilder() {
            }

            @Generated
            public PassBuilder depthHWFilterEnabled(boolean depthHWFilterEnabled) {
                this.depthHWFilterEnabled = depthHWFilterEnabled;
                return this;
            }

            @Generated
            public PassBuilder depthFilterNearest(boolean depthFilterNearest) {
                this.depthFilterNearest = depthFilterNearest;
                return this;
            }

            @Generated
            public PassBuilder depthMipmapEnabled(boolean depthMipmapEnabled) {
                this.depthMipmapEnabled = depthMipmapEnabled;
                return this;
            }

            @Generated
            public PassBuilder colorFilterNearest(boolean colorFilterNearest) {
                this.colorFilterNearest = colorFilterNearest;
                return this;
            }

            @Generated
            public PassBuilder colorMipmapEnabled(boolean colorMipmapEnabled) {
                this.colorMipmapEnabled = colorMipmapEnabled;
                return this;
            }

            @Generated
            public Pass build() {
                return new Pass(this.depthHWFilterEnabled, this.depthFilterNearest, this.depthMipmapEnabled, this.colorFilterNearest, this.colorMipmapEnabled);
            }

            @Generated
            public String toString() {
                return "ShadowProperties.Pass.PassBuilder(depthHWFilterEnabled=" + this.depthHWFilterEnabled + ", depthFilterNearest=" + this.depthFilterNearest + ", depthMipmapEnabled=" + this.depthMipmapEnabled + ", colorFilterNearest=" + this.colorFilterNearest + ", colorMipmapEnabled=" + this.colorMipmapEnabled + ")";
            }
        }
    }

    @Generated
    private static class ShadowPropertiesBuilder {
        @Generated
        private int resolution;
        @Generated
        private Double fov;
        @Generated
        private double distance;
        @Generated
        private double intervalSize;
        @Generated
        private Pass[] passes;

        @Generated
        ShadowPropertiesBuilder() {
        }

        @Generated
        private ShadowPropertiesBuilder resolution(int resolution) {
            this.resolution = resolution;
            return this;
        }

        @Generated
        private ShadowPropertiesBuilder fov(Double fov) {
            this.fov = fov;
            return this;
        }

        @Generated
        private ShadowPropertiesBuilder distance(double distance) {
            this.distance = distance;
            return this;
        }

        @Generated
        private ShadowPropertiesBuilder intervalSize(double intervalSize) {
            this.intervalSize = intervalSize;
            return this;
        }

        @Generated
        private ShadowPropertiesBuilder passes(Pass[] passes) {
            this.passes = passes;
            return this;
        }

        @Generated
        private ShadowProperties build() {
            return new ShadowProperties(this.resolution, this.fov, this.distance, this.intervalSize, this.passes);
        }

        @Generated
        public String toString() {
            return "ShadowProperties.ShadowPropertiesBuilder(resolution=" + this.resolution + ", fov=" + this.fov + ", distance=" + this.distance + ", intervalSize=" + this.intervalSize + ", passes=" + Arrays.deepToString(this.passes) + ")";
        }
    }
}

