/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader;

import com.ventooth.swansong.Share;
import com.ventooth.swansong.StackStateTracker;
import com.ventooth.swansong.shader.MCRenderStage;
import com.ventooth.swansong.shader.ShaderEngine;
import com.ventooth.swansong.shader.ShaderState;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StateGraph {
    private static final EnumMap<Node, EnumMap<Node, Runnable>> graph = new EnumMap(Node.class);
    public List<Node> graphLog = new ArrayList<Node>();
    private Node current = Node.Unmanaged;
    private final StackStateTracker<Void> stack = new StackStateTracker(false);
    private static final EnumSet<Node> ALL_ALLOWED;

    private static void edge(Node from, Node to, @NotNull Runnable logic) {
        EnumMap map = graph.computeIfAbsent(from, _from -> new EnumMap(Node.class));
        if (map.containsKey((Object)to)) {
            throw new AssertionError((Object)("Duplicate graph edge: " + from.name() + " -> " + to.name()));
        }
        map.put(to, logic);
    }

    private static void edge(Node from, Node[] to, @NotNull Runnable logic) {
        for (Node b : to) {
            StateGraph.edge(from, b, logic);
        }
    }

    private static void edge(Node[] from, Node to, @NotNull Runnable logic) {
        for (Node a : from) {
            StateGraph.edge(a, to, logic);
        }
    }

    private static void edge(Node[] from, Node[] to, @NotNull Runnable logic) {
        for (Node a : from) {
            for (Node b : to) {
                StateGraph.edge(a, b, logic);
            }
        }
    }

    private static void edge(Node from, Node to) {
        StateGraph.edge(from, to, () -> {});
    }

    public void moveTo(Node to) {
        EnumMap<Node, Runnable> targets = graph.get((Object)this.current);
        assert (targets != null) : "No graph edge source for " + this.current.name();
        Runnable code = targets.get((Object)to);
        if (code == null) {
            IllegalStateException err = new IllegalStateException("Nonexistent graph edge: " + this.current.name() + " -> " + to.name());
            Share.log.fatal("StateGraph: ", (Throwable)err);
            throw err;
        }
        this.execMove(to, code);
    }

    public void moveToEither(Node ... nodes) {
        assert (nodes.length >= 1);
        EnumMap<Node, Runnable> targets = graph.get((Object)this.current);
        assert (targets != null) : "No graph edge source for " + this.current.name();
        Node to = null;
        Runnable code = null;
        Node[] nodeArray = nodes;
        int n = nodeArray.length;
        for (int i = 0; i < n; ++i) {
            Node node;
            to = node = nodeArray[i];
            code = targets.get((Object)node);
            if (code != null) break;
        }
        if (code == null) {
            StringBuilder sb = new StringBuilder("Nonexistent graph edges:\n");
            for (Node node : nodes) {
                sb.append(this.current.name()).append(" -> ").append(node.name()).append('\n');
            }
            IllegalStateException err = new IllegalStateException(sb.toString());
            Share.log.fatal("StateGraph: ", (Throwable)err);
            throw err;
        }
        this.execMove(to, code);
    }

    private void execMove(Node to, Runnable code) {
        if (!this.stack.isEmpty()) {
            StringBuilder b = new StringBuilder("Tried to move graph when stack was not empty!\nEdge: ").append(this.current.name()).append(" -> ").append(to.name()).append('\n');
            this.stack.addStackState(b);
            IllegalStateException err = new IllegalStateException(b.toString());
            Share.log.fatal("StateGraph: ", (Throwable)err);
            throw err;
        }
        code.run();
        this.current = to;
    }

    public boolean isManaged() {
        return this.current != Node.Unmanaged;
    }

    public boolean isShadowPass() {
        return this.current.isShadow;
    }

    public boolean isRender() {
        return this.current.isRender;
    }

    public boolean isSky() {
        return this.current.isSky;
    }

    public void push(Stack node) {
        if (this.current == Node.Unmanaged) {
            IllegalStateException err = new IllegalStateException("Tried to push stack \"" + node.name() + "\" while in unmanaged mode!");
            Share.log.fatal("StateGraph: ", (Throwable)err);
            throw err;
        }
        if (!node.allowedNodes.contains((Object)this.current)) {
            StringBuilder b = new StringBuilder("Tried to push stack \"").append(node.name()).append("\" in disallowed graph state \"").append(this.current.name()).append("\".\n");
            b.append("Allowed states:\n");
            for (Node allowed : node.allowedNodes) {
                b.append(allowed.name()).append('\n');
            }
            IllegalStateException err = new IllegalStateException(b.toString());
            Share.log.fatal("StateGraph: ", (Throwable)err);
            throw err;
        }
        this.stack.push(node.key, null);
        node.push(this.current);
    }

    public void pop(Stack node) {
        if (this.current == Node.Unmanaged) {
            IllegalStateException err = new IllegalStateException("Tried to pop stack while in unmanaged mode!");
            Share.log.fatal("StateGraph: ", (Throwable)err);
            throw err;
        }
        this.stack.pop(node.key);
        node.pop(this.current);
    }

    static {
        StateGraph.edge(Node.Unmanaged, Node.BeginFrame);
        StateGraph.edge(Node.BeginFrame, Node.ShadowBegin, () -> {
            ShaderEngine.use(ShaderEngine.state.manager.shadow);
            ShaderEngine.lockShader();
        });
        StateGraph.edge(Node.BeginFrame, Node.RenderBegin);
        StateGraph.edge(Node.RenderLast, Node.Unmanaged);
        StateGraph.edge(Node.ShadowLast, Node.RenderBegin, () -> ShaderEngine.unlockShader());
        StateGraph.edge(Node.ShadowBegin, Node.ShadowChunk0, () -> ShaderState.updateRenderStage(MCRenderStage.TERRAIN_SOLID));
        StateGraph.edge(Node.ShadowChunk0, Node.ShadowEntities0, () -> ShaderState.updateRenderStage(MCRenderStage.ENTITIES));
        StateGraph.edge(Node.ShadowChunk0, Node.ShadowChunk1, () -> ShaderState.updateRenderStage(MCRenderStage.TERRAIN_TRANSLUCENT));
        StateGraph.edge(Node.ShadowEntities0, Node.ShadowBlockEntities0, () -> ShaderState.updateRenderStage(MCRenderStage.BLOCK_ENTITIES));
        StateGraph.edge(Node.ShadowBlockEntities0, Node.ShadowEntities0, () -> ShaderState.updateRenderStage(MCRenderStage.ENTITIES));
        StateGraph.edge(Node.ShadowBlockEntities0, Node.ShadowChunk1, () -> ShaderState.updateRenderStage(MCRenderStage.TERRAIN_TRANSLUCENT));
        StateGraph.edge(Node.ShadowChunk1, Node.ShadowEntities1, () -> ShaderState.updateRenderStage(MCRenderStage.ENTITIES));
        StateGraph.edge(Node.ShadowChunk1, Node.ShadowLast);
        StateGraph.edge(Node.ShadowEntities1, Node.ShadowBlockEntities1, () -> ShaderState.updateRenderStage(MCRenderStage.BLOCK_ENTITIES));
        StateGraph.edge(Node.ShadowBlockEntities1, Node.ShadowEntities1, () -> ShaderState.updateRenderStage(MCRenderStage.ENTITIES));
        StateGraph.edge(Node.ShadowBlockEntities1, Node.ShadowLast);
        StateGraph.edge(Node.RenderBegin, Node.RenderSkyBasic, () -> {
            ShaderEngine.shaderData.pushEntity(-2);
            ShaderState.updateRenderStage(MCRenderStage.SKY);
            ShaderEngine.use(ShaderEngine.state.manager.skybasic);
        });
        StateGraph.edge(Node.RenderBegin, Node.RenderClouds, () -> {
            ShaderEngine.shaderData.pushEntity(-3);
            ShaderState.updateRenderStage(MCRenderStage.CLOUDS);
            ShaderEngine.use(ShaderEngine.state.manager.clouds);
        });
        StateGraph.edge(Node.RenderBegin, Node.RenderChunk0, () -> {
            ShaderState.updateRenderStage(MCRenderStage.TERRAIN_SOLID);
            ShaderEngine.use(ShaderEngine.state.manager.terrain);
        });
        StateGraph.edge(new Node[]{Node.RenderSkyBasic, Node.RenderSkyTextured}, Node.RenderClouds, () -> {
            ShaderEngine.shaderData.popEntity();
            ShaderEngine.shaderData.pushEntity(-3);
            ShaderState.updateRenderStage(MCRenderStage.CLOUDS);
            ShaderEngine.use(ShaderEngine.state.manager.clouds);
        });
        StateGraph.edge(new Node[]{Node.RenderSkyBasic, Node.RenderSkyTextured}, Node.RenderChunk0, () -> {
            ShaderEngine.shaderData.popEntity();
            ShaderState.updateRenderStage(MCRenderStage.TERRAIN_SOLID);
            ShaderEngine.use(ShaderEngine.state.manager.terrain);
        });
        StateGraph.edge(Node.RenderSkyBasic, Node.RenderSkyBasic);
        StateGraph.edge(Node.RenderSkyBasic, Node.RenderSkyTextured, () -> ShaderEngine.use(ShaderEngine.state.manager.skytextured));
        StateGraph.edge(Node.RenderSkyTextured, Node.RenderSkyBasic, () -> ShaderEngine.use(ShaderEngine.state.manager.skybasic));
        StateGraph.edge(Node.RenderSkyTextured, Node.RenderSkyTextured);
        StateGraph.edge(Node.RenderClouds, Node.RenderChunk0, () -> {
            ShaderEngine.shaderData.popEntity();
            ShaderState.updateRenderStage(MCRenderStage.TERRAIN_SOLID);
            ShaderEngine.use(ShaderEngine.state.manager.terrain);
        });
        StateGraph.edge(Node.RenderChunk0, Node.RenderWeatherEntities0, () -> {
            ShaderState.updateRenderStage(MCRenderStage.ENTITIES);
            ShaderEngine.use(ShaderEngine.state.manager.entities);
        });
        StateGraph.edge(Node.RenderChunk0, Node.RenderSelectionBox, () -> {
            ShaderState.updateRenderStage(MCRenderStage.NONE);
            ShaderEngine.use(ShaderEngine.state.manager.basic);
        });
        StateGraph.edge(Node.RenderWeatherEntities0, Node.RenderEntities0);
        StateGraph.edge(Node.RenderEntities0, Node.RenderBlockEntities0, () -> {
            ShaderState.updateRenderStage(MCRenderStage.BLOCK_ENTITIES);
            ShaderEngine.use(ShaderEngine.state.manager.block);
        });
        StateGraph.edge(Node.RenderBlockEntities0, Node.RenderWeatherEntities0, () -> {
            ShaderState.updateRenderStage(MCRenderStage.ENTITIES);
            ShaderEngine.use(ShaderEngine.state.manager.entities);
        });
        StateGraph.edge(Node.RenderBlockEntities0, Node.RenderSelectionBox, () -> {
            ShaderState.updateRenderStage(MCRenderStage.NONE);
            ShaderEngine.use(ShaderEngine.state.manager.basic);
        });
        StateGraph.edge(Node.RenderSelectionBox, Node.RenderBlockDamage, () -> {
            ShaderState.updateRenderStage(MCRenderStage.TERRAIN_SOLID);
            ShaderEngine.use(ShaderEngine.state.manager.terrain);
        });
        StateGraph.edge(Node.RenderBlockDamage, Node.RenderParticlesLit, () -> {
            ShaderState.updateRenderStage(MCRenderStage.PARTICLES);
            ShaderEngine.use(ShaderEngine.state.manager.textured_lit);
        });
        StateGraph.edge(Node.RenderParticlesLit, Node.RenderParticles, () -> ShaderEngine.use(ShaderEngine.state.manager.textured));
        StateGraph.edge(Node.RenderParticles, Node.RenderWeather, () -> {
            ShaderState.updateRenderStage(MCRenderStage.RAIN_SNOW);
            ShaderEngine.use(ShaderEngine.state.manager.weather);
        });
        StateGraph.edge(Node.RenderWeather, Node.RenderHand0, () -> ShaderEngine.renderHand());
        StateGraph.edge(Node.RenderHand0, Node.RenderChunk1, () -> {
            ShaderState.updateRenderStage(MCRenderStage.TERRAIN_TRANSLUCENT);
            ShaderEngine.use(ShaderEngine.state.manager.water);
        });
        StateGraph.edge(Node.RenderChunk1, Node.RenderWeatherEntities1, () -> {
            ShaderState.updateRenderStage(MCRenderStage.ENTITIES);
            ShaderEngine.use(ShaderEngine.state.manager.entities);
        });
        StateGraph.edge(Node.RenderChunk1, Node.RenderClouds, () -> {
            ShaderEngine.shaderData.pushEntity(-3);
            ShaderState.updateRenderStage(MCRenderStage.CLOUDS);
            ShaderEngine.use(ShaderEngine.state.manager.clouds);
        });
        StateGraph.edge(Node.RenderChunk1, Node.RenderLast, () -> {
            ShaderState.updateRenderStage(MCRenderStage.NONE);
            ShaderEngine.use(ShaderEngine.state.manager.textured_lit);
        });
        StateGraph.edge(Node.RenderWeatherEntities1, Node.RenderEntities1);
        StateGraph.edge(Node.RenderEntities1, Node.RenderBlockEntities1, () -> {
            ShaderState.updateRenderStage(MCRenderStage.BLOCK_ENTITIES);
            ShaderEngine.use(ShaderEngine.state.manager.block);
        });
        StateGraph.edge(Node.RenderBlockEntities1, Node.RenderWeatherEntities1, () -> {
            ShaderState.updateRenderStage(MCRenderStage.ENTITIES);
            ShaderEngine.use(ShaderEngine.state.manager.entities);
        });
        StateGraph.edge(Node.RenderBlockEntities1, Node.RenderClouds, () -> {
            ShaderEngine.shaderData.pushEntity(-3);
            ShaderState.updateRenderStage(MCRenderStage.CLOUDS);
            ShaderEngine.use(ShaderEngine.state.manager.clouds);
        });
        StateGraph.edge(Node.RenderBlockEntities1, Node.RenderLast, () -> {
            ShaderState.updateRenderStage(MCRenderStage.NONE);
            ShaderEngine.use(ShaderEngine.state.manager.textured_lit);
        });
        StateGraph.edge(Node.RenderClouds, Node.RenderLast, () -> {
            ShaderEngine.shaderData.popEntity();
            ShaderState.updateRenderStage(MCRenderStage.NONE);
            ShaderEngine.use(ShaderEngine.state.manager.textured_lit);
        });
        StateGraph.edge(Node.RenderLast, Node.RenderBegin, () -> {
            ShaderEngine.use(null);
            ShaderEngine.clearColorBufs();
        });
        ALL_ALLOWED = EnumSet.allOf(Node.class);
    }

    public static enum Node {
        Unmanaged,
        BeginFrame,
        ShadowBegin,
        ShadowChunk0,
        ShadowEntities0,
        ShadowBlockEntities0,
        ShadowChunk1,
        ShadowEntities1,
        ShadowBlockEntities1,
        ShadowLast,
        RenderBegin,
        RenderSkyBasic,
        RenderSkyTextured,
        RenderClouds,
        RenderChunk0,
        RenderWeatherEntities0,
        RenderEntities0,
        RenderBlockEntities0,
        RenderSelectionBox,
        RenderBlockDamage,
        RenderParticlesLit,
        RenderParticles,
        RenderWeather,
        RenderHand0,
        RenderChunk1,
        RenderWeatherEntities1,
        RenderEntities1,
        RenderBlockEntities1,
        RenderLast;

        public final boolean isShadow = this.name().startsWith("Shadow");
        public final boolean isRender = this.name().startsWith("Render");
        public final boolean isSky = this.name().startsWith("RenderSky");
    }

    public static enum Stack {
        AABBOutline{

            @Override
            protected void push(Node currentNode) {
                if (currentNode.isRender) {
                    ShaderEngine.use(ShaderEngine.state.manager.basic);
                    ShaderEngine.pushShader();
                }
            }

            @Override
            protected void pop(Node currentNode) {
                if (currentNode.isRender) {
                    ShaderEngine.popShader();
                }
            }
        }
        ,
        BlockDestroyProgress{

            @Override
            protected void push(Node currentNode) {
                if (currentNode.isRender) {
                    ShaderState.pushRenderStage();
                    ShaderEngine.pushShader();
                    ShaderState.updateRenderStage(MCRenderStage.TERRAIN_SOLID);
                    ShaderEngine.use(ShaderEngine.state.manager.terrain);
                }
            }

            @Override
            protected void pop(Node currentNode) {
                if (currentNode.isRender) {
                    ShaderState.popRenderStage();
                    ShaderEngine.popShader();
                }
            }
        }
        ,
        SpiderEyes{

            @Override
            protected void push(Node currentNode) {
                if (currentNode.isRender) {
                    ShaderState.pushRenderStage();
                    ShaderEngine.pushShader();
                    ShaderState.updateRenderStage(MCRenderStage.ENTITIES);
                    ShaderEngine.use(ShaderEngine.state.manager.spidereyes);
                }
            }

            @Override
            protected void pop(Node currentNode) {
                if (currentNode.isRender) {
                    ShaderState.popRenderStage();
                    ShaderEngine.popShader();
                }
            }
        }
        ,
        EntityParticle{

            @Override
            protected void push(Node currentNode) {
                if (currentNode.isRender) {
                    ShaderEngine.pushShader();
                    ShaderEngine.use(ShaderEngine.state.manager.textured_lit);
                }
            }

            @Override
            protected void pop(Node currentNode) {
                if (currentNode.isRender) {
                    ShaderEngine.popShader();
                }
            }
        }
        ,
        Text{

            @Override
            protected void push(Node currentNode) {
                if (currentNode.isRender) {
                    ShaderEngine.pushShader();
                    ShaderEngine.use(ShaderEngine.state.manager.textured_lit);
                }
            }

            @Override
            protected void pop(Node currentNode) {
                if (currentNode.isRender) {
                    ShaderEngine.popShader();
                }
            }
        }
        ,
        DragonAPI{

            @Override
            protected void push(Node currentNode) {
                if (currentNode.isRender) {
                    ShaderEngine.pushShader();
                    ShaderEngine.use(ShaderEngine.state.manager.textured_lit);
                }
            }

            @Override
            protected void pop(Node currentNode) {
                if (currentNode.isRender) {
                    ShaderEngine.popShader();
                }
            }
        }
        ,
        Portal{

            @Override
            protected void push(Node currentNode) {
                ShaderState.pushRenderStage();
                ShaderState.updateRenderStage(MCRenderStage.BLOCK_ENTITIES_PORTAL);
                if (currentNode.isRender) {
                    ShaderEngine.pushShader();
                    ShaderEngine.use(ShaderEngine.state.manager.portal);
                }
            }

            @Override
            protected void pop(Node currentNode) {
                ShaderState.popRenderStage();
                if (currentNode.isRender) {
                    ShaderEngine.popShader();
                }
            }
        }
        ,
        Leash{

            @Override
            protected void push(Node currentNode) {
                ShaderState.pushRenderStage();
                ShaderState.updateRenderStage(MCRenderStage.ENTITIES);
                if (currentNode.isRender) {
                    ShaderEngine.pushShader();
                    ShaderEngine.use(ShaderEngine.state.manager.basic);
                }
            }

            @Override
            protected void pop(Node currentNode) {
                ShaderState.popRenderStage();
                if (currentNode.isRender) {
                    ShaderEngine.popShader();
                }
            }
        }
        ,
        NEIOverlay{

            @Override
            protected void push(Node currentNode) {
                ShaderState.pushRenderStage();
                ShaderEngine.pushShader();
                ShaderState.updateRenderStage(MCRenderStage.NONE);
                ShaderEngine.use(ShaderEngine.state.manager.basic);
            }

            @Override
            protected void pop(Node currentNode) {
                ShaderState.popRenderStage();
                ShaderEngine.popShader();
            }
        }
        ,
        ExternalShader{

            @Override
            protected void push(Node currentNode) {
                ShaderEngine.pushShader();
                ShaderEngine.use(null);
            }

            @Override
            protected void pop(Node currentNode) {
                ShaderEngine.popShader();
            }
        }
        ,
        Beacon{

            @Override
            protected void push(Node currentNode) {
                ShaderState.pushRenderStage();
                ShaderState.updateRenderStage(MCRenderStage.BLOCK_ENTITIES);
                if (currentNode.isRender) {
                    ShaderEngine.pushShader();
                    ShaderEngine.use(ShaderEngine.state.manager.beaconbeam);
                }
            }

            @Override
            protected void pop(Node currentNode) {
                ShaderState.popRenderStage();
                if (currentNode.isRender) {
                    ShaderEngine.popShader();
                }
            }
        }
        ,
        BlockHighlightTextured{

            @Override
            protected void push(Node currentNode) {
                if (currentNode.isRender) {
                    ShaderEngine.pushShader();
                    ShaderEngine.use(ShaderEngine.state.manager.textured);
                }
            }

            @Override
            protected void pop(Node currentNode) {
                if (currentNode.isRender) {
                    ShaderEngine.popShader();
                }
            }
        };

        private final StackStateTracker.Key key = new StackStateTracker.Key(this.name());
        private final EnumSet<Node> allowedNodes;

        private Stack(Node first, Node ... rest) {
            this.allowedNodes = EnumSet.of(first, rest);
        }

        private Stack() {
            this.allowedNodes = ALL_ALLOWED;
        }

        protected void push(Node currentNode) {
        }

        protected void pop(Node currentNode) {
        }
    }
}

