/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader.loader;

import com.ventooth.swansong.gl.GLProgram;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Objects;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompiledProgram {
    @NotNull
    private final String path;
    @NotNull
    private final GLProgram program;
    @NotNull
    private final ObjectList<String> mipmapEnabled;
    @Nullable
    private final IntList renderTargets;
    @NotNull
    private final ResourceLocation actualShaderType;

    public CompiledProgram(@NotNull String path, @NotNull GLProgram program, @NotNull ObjectList<String> mipmapEnabled, @Nullable IntList renderTargets, @NotNull ResourceLocation actualShaderType) {
        this.path = path;
        this.program = program;
        this.mipmapEnabled = mipmapEnabled;
        this.renderTargets = renderTargets;
        this.actualShaderType = actualShaderType;
    }

    @NotNull
    public String path() {
        return this.path;
    }

    @NotNull
    public GLProgram program() {
        return this.program;
    }

    @NotNull
    public ObjectList<String> mipmapEnabled() {
        return this.mipmapEnabled;
    }

    @Nullable
    public IntList renderTargets() {
        return this.renderTargets;
    }

    @NotNull
    public ResourceLocation actualShaderType() {
        return this.actualShaderType;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CompiledProgram that = (CompiledProgram)obj;
        return Objects.equals(this.path, that.path) && Objects.equals(this.program, that.program) && Objects.equals(this.mipmapEnabled, that.mipmapEnabled) && Objects.equals(this.renderTargets, that.renderTargets) && Objects.equals(this.actualShaderType, that.actualShaderType);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.program, this.mipmapEnabled, this.renderTargets, this.actualShaderType);
    }

    public String toString() {
        return "CompiledProgram[path=" + this.path + ", program=" + this.program + ", mipmapEnabled=" + this.mipmapEnabled + ", renderTargets=" + this.renderTargets + ']';
    }
}

