/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader.loader.config;

import com.ventooth.swansong.shader.config.ConfigEntry;
import com.ventooth.swansong.shader.loader.config.ConfigEntryBase;
import com.ventooth.swansong.shader.loader.config.Localization;
import com.ventooth.swansong.shader.preprocessor.Option;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Objects;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.Locale;
import org.jetbrains.annotations.Unmodifiable;

public class ConfigProfile
extends ConfigEntryBase
implements ConfigEntry.Profile {
    private final ObjectList<Option> allOptions;
    private final ObjectList<Profile> profiles;
    private int currentProfile = -1;
    private int defaultProfile = -1;
    private int initialProfile = -1;
    private boolean detected = false;

    public ConfigProfile(Locale locale, ObjectList<Option> allOptions, Object2ObjectMap<String, String> profiles) {
        super(Localization.createProfile(locale, (ObjectList<String>)new ObjectArrayList((ObjectCollection)profiles.keySet())));
        ObjectArrayList profs = new ObjectArrayList();
        Object2ObjectMaps.fastForEach(profiles, entry -> {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            Profile profile = Profile.parse((ObjectList<Profile>)profs, this.locale, name, value);
            profs.add((Object)profile);
        });
        this.allOptions = allOptions;
        this.profiles = profs;
    }

    @Override
    public void nextValue() {
        int prof;
        this.ensureDetected();
        int prev = this.currentProfile;
        this.currentProfile = prof = (prev + 1) % this.profiles.size();
        ((Profile)this.profiles.get(prof)).apply(this.allOptions);
    }

    @Override
    public void prevValue() {
        int prof;
        this.ensureDetected();
        int s = this.profiles.size();
        int prev = this.currentProfile;
        this.currentProfile = prof = prev <= 0 ? s - 1 : prev - 1;
        ((Profile)this.profiles.get(prof)).apply(this.allOptions);
    }

    @Override
    public void resetToDefault() {
        this.detected = false;
    }

    @Override
    public boolean isDefault() {
        this.ensureDetected();
        return this.currentProfile == this.defaultProfile;
    }

    @Override
    public boolean isModified() {
        this.ensureDetected();
        return this.currentProfile != this.initialProfile;
    }

    @Override
    public String valueName() {
        this.ensureDetected();
        if (this.currentProfile == -1) {
            return I18n.func_135052_a((String)"gui.swansong.shaders.profile.custom", (Object[])new Object[0]);
        }
        return ((Profile)this.profiles.get(this.currentProfile)).localizedName();
    }

    private void ensureDetected() {
        if (this.detected) {
            return;
        }
        this.detected = true;
        this.defaultProfile = this.detectProfile(true);
        this.initialProfile = this.currentProfile = this.detectProfile(false);
    }

    private int detectProfile(boolean isDefault) {
        int highestDetected = -1;
        int profilesSize = this.profiles.size();
        for (int i = 0; i < profilesSize; ++i) {
            Profile profile = (Profile)this.profiles.get(i);
            if (!profile.matches(this.allOptions, isDefault)) continue;
            highestDetected = i;
        }
        return highestDetected;
    }

    public static final class Profile {
        private final String localizedName;
        private final String name;
        private final @Unmodifiable Object2ObjectMap<String, Option.Value> optionSettings;

        public Profile(String localizedName, String name, @Unmodifiable Object2ObjectMap<String, Option.Value> optionSettings) {
            this.localizedName = localizedName;
            this.name = name;
            this.optionSettings = optionSettings;
        }

        public static Profile parse(ObjectList<Profile> knownProfiles, Localization locale, String unlocalizedName, String unparsedValue) {
            String localizedName = (String)locale.options().getOrDefault((Object)unlocalizedName, (Object)unlocalizedName);
            Object2ObjectMap<String, Option.Value> settings = Profile.parseConfigValues(knownProfiles, unparsedValue);
            return new Profile(localizedName, unlocalizedName, settings);
        }

        private static @Unmodifiable Object2ObjectMap<String, Option.Value> parseConfigValues(ObjectList<Profile> knownProfiles, String values) {
            String[] parts = values.trim().split("\\s+");
            Object2ObjectOpenHashMap result = new Object2ObjectOpenHashMap();
            block0: for (String part : parts) {
                String[] halves = part.split("=", 2);
                if (halves.length == 1) {
                    if (part.startsWith("profile.")) {
                        String profName = part.substring("profile.".length());
                        for (Profile prof : knownProfiles) {
                            if (!prof.name().equals(profName)) continue;
                            result.putAll(prof.optionSettings());
                            continue block0;
                        }
                        continue;
                    }
                    if (part.startsWith("!")) {
                        result.put((Object)part.substring(1), (Object)Option.Value.Bool.False);
                        continue;
                    }
                    result.put((Object)part, (Object)Option.Value.Bool.True);
                    continue;
                }
                String name = halves[0];
                Option.Value value = Option.Value.detect(halves[1]);
                result.put((Object)name, (Object)value);
            }
            return Object2ObjectMaps.unmodifiable((Object2ObjectMap)result);
        }

        public boolean matches(ObjectList<Option> allOptions, boolean isDefault) {
            for (Option option : allOptions) {
                Option.Value optVal;
                Option.Value expectedValue = (Option.Value)this.optionSettings.get((Object)option.name);
                if (expectedValue == null || Option.valueMatches(optVal = isDefault ? option.getDefaultValue() : option.getCurrentValue(), expectedValue)) continue;
                return false;
            }
            return true;
        }

        public void apply(ObjectList<Option> allOptions) {
            for (Option option : allOptions) {
                Option.Value expectedValue = (Option.Value)this.optionSettings.get((Object)option.name);
                if (expectedValue == null) continue;
                option.setCurrentValue(expectedValue);
            }
        }

        public String localizedName() {
            return this.localizedName;
        }

        public String name() {
            return this.name;
        }

        public @Unmodifiable Object2ObjectMap<String, Option.Value> optionSettings() {
            return this.optionSettings;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Profile that = (Profile)obj;
            return Objects.equals(this.localizedName, that.localizedName) && Objects.equals(this.name, that.name) && Objects.equals(this.optionSettings, that.optionSettings);
        }

        public int hashCode() {
            return Objects.hash(this.localizedName, this.name, this.optionSettings);
        }

        public String toString() {
            return "Profile[localizedName=" + this.localizedName + ", name=" + this.name + ", optionSettings=" + this.optionSettings + ']';
        }
    }
}

