/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader.preprocessor;

import com.ventooth.swansong.Share;
import com.ventooth.swansong.shader.preprocessor.FSProvider;
import com.ventooth.swansong.shader.preprocessor.Option;
import com.ventooth.swansong.shader.preprocessor.ShaderStage1Meta;
import com.ventooth.swansong.shader.preprocessor.ShaderStage2Meta;
import com.ventooth.swansong.shader.preprocessor.TaggedLine;
import com.ventooth.swansong.shader.preprocessor.macro.MacroInterpreter;
import com.ventooth.swansong.shader.preprocessor.util.CodePrinter;
import com.ventooth.swansong.shader.preprocessor.util.RecursiveIncluder;
import com.ventooth.swansong.shader.preprocessor.util.StringUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class ShaderPreprocessor {
    private final FSProvider fs;
    private RecyclableOutputContext context;

    @Nullable
    public String getString(String path, boolean glsl, Consumer<ShaderStage1Meta> stage1Configurer, Consumer<ShaderStage2Meta> stage2Configurer) {
        PreprocessorStage2Suspend stage2 = this.runStage2(path, glsl, stage1Configurer, stage2Configurer);
        if (stage2 == null) {
            return null;
        }
        return stage2.getString();
    }

    public byte @Nullable [] getBytes(String path, boolean glsl, Consumer<ShaderStage1Meta> stage1Configurer, Consumer<ShaderStage2Meta> stage2Configurer) {
        PreprocessorStage2Suspend stage2 = this.runStage2(path, glsl, stage1Configurer, stage2Configurer);
        if (stage2 == null) {
            return null;
        }
        return stage2.getBytes();
    }

    @Nullable
    public ByteBuffer getNativeBuffer(String path, boolean glsl, Consumer<ShaderStage1Meta> stage1Configurer, Consumer<ShaderStage2Meta> stage2Configurer, boolean nullTerminator) {
        PreprocessorStage2Suspend stage2 = this.runStage2(path, glsl, stage1Configurer, stage2Configurer);
        if (stage2 == null) {
            return null;
        }
        return stage2.getNativeBuffer(nullTerminator);
    }

    public PreprocessorStage1Suspend runStage1(String path, boolean glsl, Consumer<ShaderStage1Meta> stage1Configurer) {
        RecursiveIncluder includer = new RecursiveIncluder(this.fs);
        if (!includer.read(path)) {
            return null;
        }
        List<TaggedLine> rawCode = ShaderPreprocessor.markMultilineComments(includer.lines());
        List<String> sourceIndices = includer.sourceIndices();
        Int2ObjectMap<Option> stage1DefOptions = Option.Define.find(rawCode, false);
        HashMap<String, Option> stage1DefOptionsNamed = new HashMap<String, Option>();
        List<Option> stage1DefOptionsList = ShaderPreprocessor.deduplicateOptions(stage1DefOptions, stage1DefOptionsNamed);
        Int2ObjectMap<Option> stage1ConstOptions = glsl ? Option.Const.find(rawCode, true) : null;
        HashMap<String, Option> stage1ConstOptionsNamed = glsl ? new HashMap<String, Option>() : null;
        List<Option> stage1ConstOptionsList = glsl ? ShaderPreprocessor.deduplicateOptions(stage1ConstOptions, stage1ConstOptionsNamed) : null;
        ShaderStage1Meta stage1 = new ShaderStage1Meta(stage1DefOptionsList, Collections.unmodifiableMap(stage1DefOptionsNamed), glsl ? stage1ConstOptionsList : null, glsl ? Collections.unmodifiableMap(stage1ConstOptionsNamed) : null, sourceIndices);
        stage1Configurer.accept(stage1);
        return new PreprocessorStage1Suspend(stage1, stage1DefOptions, rawCode, glsl);
    }

    private static byte @NotNull [] sourceToByteArray(PreprocessedCode sources) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8), false);){
            CodePrinter.printCode(sources.prelude(), sources.code(), sources.opts(), pw);
        }
        return out.toByteArray();
    }

    @NotNull
    private static String sourceToString(PreprocessedCode sources) {
        StringWriter sprint = new StringWriter();
        try (PrintWriter pw = new PrintWriter((Writer)sprint, false);){
            CodePrinter.printCode(sources.prelude(), sources.code(), sources.opts(), pw);
        }
        return sprint.toString();
    }

    @NotNull
    private ByteBuffer sourceToNativeBuffer(PreprocessedCode sources, boolean nullTerminator) {
        RecyclableOutputContext context = this.context;
        if (context == null) {
            context = this.context = new RecyclableOutputContext();
        }
        context.reset();
        ExposedByteArrayOutputStream out = context.outputStream;
        try (PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8), false);){
            CodePrinter.printCode(sources.prelude(), sources.code(), sources.opts(), pw);
        }
        if (nullTerminator) {
            out.write(0);
        }
        return context.toNativeBuffer();
    }

    @Nullable
    private PreprocessorStage2Suspend runStage2(String path, boolean glsl, Consumer<ShaderStage1Meta> stage1Configurer, Consumer<ShaderStage2Meta> stage2Configurer) {
        PreprocessorStage1Suspend stage1 = this.runStage1(path, glsl, stage1Configurer);
        if (stage1 == null) {
            return null;
        }
        return stage1.runStage2(stage2Configurer);
    }

    private static @Unmodifiable List<Option> deduplicateOptions(Int2ObjectMap<Option> opts, Map<String, Option> named) {
        ArrayList<Option> optList = new ArrayList<Option>();
        for (Int2ObjectMap.Entry entry : opts.int2ObjectEntrySet()) {
            Option opt = (Option)entry.getValue();
            String n = opt.uniqueName();
            if (named.containsKey(n)) {
                Option opt2 = named.get(n);
                if (opt.legalValues.equals(opt2.legalValues) && !Option.valueMatches(opt.getCurrentValue(), opt2.getCurrentValue())) {
                    Share.log.warn("Mismatched option values: {}", new Object[]{opt.name});
                }
                if (opt.isConfigurable() && opt2.isConfigurable()) {
                    entry.setValue((Object)opt2);
                    continue;
                }
                if (opt.isConfigurable() || opt2.isConfigurable()) continue;
                optList.add(opt);
                named.put(n, opt);
                continue;
            }
            named.put(n, opt);
            optList.add(opt);
        }
        return Collections.unmodifiableList(optList);
    }

    private static @Unmodifiable List<TaggedLine> markMultilineComments(List<TaggedLine> lines) {
        boolean isInComment = false;
        boolean newComment = false;
        lines = new ArrayList<TaggedLine>(lines);
        for (int i = 0; i < lines.size(); ++i) {
            TaggedLine line = lines.get(i);
            String txt = line.text();
            if (isInComment) {
                int commentEnd = txt.indexOf("*/");
                if (commentEnd < 0) {
                    lines.set(i, line.withTag(TaggedLine.Tag.MultilineComment));
                    newComment = false;
                    continue;
                }
                if (newComment) {
                    newComment = false;
                    if (commentEnd == 1 && txt.charAt(0) == '/' && (commentEnd = txt.indexOf("*/", commentEnd + 2)) < 0) {
                        lines.set(i, line.withTag(TaggedLine.Tag.MultilineComment));
                        continue;
                    }
                }
                int len = txt.length();
                isInComment = false;
                if (commentEnd == len - 2 || StringUtils.firstNonWhitespace(txt, commentEnd + 2, len) == -1) {
                    lines.set(i, line.withTextAndTag(txt.substring(0, commentEnd + 2), TaggedLine.Tag.MultilineComment));
                    continue;
                }
                lines.set(i, line.withTextAndTag(txt.substring(0, commentEnd + 2), false, TaggedLine.Tag.MultilineComment));
                lines.add(i + 1, line.withText(txt.substring(commentEnd + 2)));
                continue;
            }
            int commentStart = txt.indexOf("/*");
            if (commentStart < 0) continue;
            if (commentStart == 0) {
                isInComment = true;
                newComment = true;
                --i;
                continue;
            }
            if (txt.charAt(commentStart - 1) == '/') continue;
            isInComment = true;
            newComment = true;
            lines.set(i, line.withText(txt.substring(0, commentStart), false));
            lines.add(i + 1, line.withText(txt.substring(commentStart)));
        }
        return Collections.unmodifiableList(lines);
    }

    @Generated
    public ShaderPreprocessor(FSProvider fs) {
        this.fs = fs;
    }

    private static final class PreprocessedCode {
        private final List<String> prelude;
        private final List<TaggedLine> code;
        private final Int2ObjectMap<Option> opts;

        private PreprocessedCode(List<String> prelude, List<TaggedLine> code, Int2ObjectMap<Option> opts) {
            this.prelude = prelude;
            this.code = code;
            this.opts = opts;
        }

        public List<String> prelude() {
            return this.prelude;
        }

        public List<TaggedLine> code() {
            return this.code;
        }

        public Int2ObjectMap<Option> opts() {
            return this.opts;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            PreprocessedCode that = (PreprocessedCode)obj;
            return Objects.equals(this.prelude, that.prelude) && Objects.equals(this.code, that.code) && Objects.equals(this.opts, that.opts);
        }

        public int hashCode() {
            return Objects.hash(this.prelude, this.code, this.opts);
        }

        public String toString() {
            return "PreprocessedCode[prelude=" + this.prelude + ", code=" + this.code + ", opts=" + this.opts + ']';
        }
    }

    public final class PreprocessorStage2Suspend {
        private final Int2ObjectMap<Option> defOptions;
        private final Int2ObjectMap<Option> constOptions;
        private final List<String> prelude;
        private final List<TaggedLine> preprocessedCode;

        @NotNull
        public String getString() {
            return ShaderPreprocessor.sourceToString(this.getSources());
        }

        public byte @NotNull [] getBytes() {
            return ShaderPreprocessor.sourceToByteArray(this.getSources());
        }

        @NotNull
        public ByteBuffer getNativeBuffer(boolean nullTerminator) {
            return ShaderPreprocessor.this.sourceToNativeBuffer(this.getSources(), nullTerminator);
        }

        private PreprocessedCode getSources() {
            Int2ObjectOpenHashMap mergedOpts = new Int2ObjectOpenHashMap();
            mergedOpts.putAll(this.defOptions);
            if (this.constOptions != null) {
                mergedOpts.putAll(this.constOptions);
            }
            return new PreprocessedCode(this.prelude, this.preprocessedCode, (Int2ObjectMap)mergedOpts);
        }

        @Generated
        public PreprocessorStage2Suspend(Int2ObjectMap<Option> defOptions, Int2ObjectMap<Option> constOptions, List<String> prelude, List<TaggedLine> preprocessedCode) {
            this.defOptions = defOptions;
            this.constOptions = constOptions;
            this.prelude = prelude;
            this.preprocessedCode = preprocessedCode;
        }
    }

    public final class PreprocessorStage1Suspend {
        private final ShaderStage1Meta meta;
        private final Int2ObjectMap<Option> defOptions;
        private final List<TaggedLine> rawCode;
        private final boolean glsl;

        public PreprocessorStage2Suspend runStage2(Consumer<ShaderStage2Meta> stage2Configurer) {
            Object2ObjectMap<String, Option.Value> stage1Macros = this.meta.extraMacros.get();
            MacroInterpreter.Result interpreterResult = MacroInterpreter.interpret(this.defOptions, this.rawCode, this.meta.fileNameIndices, stage1Macros, this.glsl);
            MacroInterpreter.Result.GLSL glslData = this.glsl ? Objects.requireNonNull(interpreterResult.glsl()) : null;
            List<TaggedLine> preprocessedCode = interpreterResult.code();
            Int2ObjectMap<Option> stage2DefOptions = interpreterResult.options();
            ArrayList<String> prelude = new ArrayList<String>(1 + (this.glsl ? glslData.extensions().size() : 0) + stage1Macros.size());
            if (this.glsl) {
                String ver = glslData.version();
                if (ver == null) {
                    Share.log.error("#version macro missing for GLSL!");
                } else {
                    prelude.add(ver);
                }
                prelude.addAll(glslData.extensions());
            }
            for (Map.Entry macro : stage1Macros.entrySet()) {
                Option.Value macroValue = (Option.Value)macro.getValue();
                if (macroValue.type() == Option.ValueType.Toggle) {
                    if (macroValue != Option.Value.Bool.True) continue;
                    prelude.add("#define " + (String)macro.getKey());
                    continue;
                }
                prelude.add("#define " + (String)macro.getKey() + " " + macro.getValue());
            }
            HashMap<String, Option> stage2DefOptionsNamed = new HashMap<String, Option>();
            List stage2DefOptionsList = ShaderPreprocessor.deduplicateOptions((Int2ObjectMap<Option>)this.defOptions, stage2DefOptionsNamed);
            Int2ObjectMap<Option> stage2ConstOptions = this.glsl ? Option.Const.find(preprocessedCode, false) : null;
            HashMap<String, Option> stage2ConstOptionsNamed = this.glsl ? new HashMap<String, Option>() : null;
            List stage2ConstOptionsList = this.glsl ? ShaderPreprocessor.deduplicateOptions((Int2ObjectMap<Option>)stage2ConstOptions, stage2ConstOptionsNamed) : null;
            ShaderStage2Meta stage2 = new ShaderStage2Meta(this.glsl ? glslData.renderTargets() : null, stage2DefOptionsList, stage2DefOptionsNamed, stage2ConstOptionsList, stage2ConstOptionsNamed);
            stage2Configurer.accept(stage2);
            return new PreprocessorStage2Suspend(stage2DefOptions, stage2ConstOptions, prelude, preprocessedCode);
        }

        @Generated
        public PreprocessorStage1Suspend(ShaderStage1Meta meta, Int2ObjectMap<Option> defOptions, List<TaggedLine> rawCode, boolean glsl) {
            this.meta = meta;
            this.defOptions = defOptions;
            this.rawCode = rawCode;
            this.glsl = glsl;
        }
    }

    private static class RecyclableOutputContext {
        private final ExposedByteArrayOutputStream outputStream = new ExposedByteArrayOutputStream();
        private ByteBuffer buf;

        private RecyclableOutputContext() {
        }

        private void reset() {
            this.outputStream.reset();
        }

        private ByteBuffer toNativeBuffer() {
            int size = this.outputStream.size();
            if (this.buf == null || size > this.buf.capacity()) {
                this.buf = ByteBuffer.allocateDirect(size);
            }
            this.buf.clear();
            this.buf.put(this.outputStream.buffer(), 0, size);
            this.buf.flip();
            return this.buf;
        }
    }

    private static class ExposedByteArrayOutputStream
    extends ByteArrayOutputStream {
        public ExposedByteArrayOutputStream() {
            super(4096);
        }

        private byte[] buffer() {
            return this.buf;
        }
    }
}

