/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader.preprocessor.macro;

import com.ventooth.swansong.mathparser.AbstractParser;
import com.ventooth.swansong.mathparser.Lexer;
import com.ventooth.swansong.mathparser.ParserException;
import com.ventooth.swansong.mathparser.Token;
import com.ventooth.swansong.mathparser.TokenType;
import com.ventooth.swansong.shader.preprocessor.Option;
import com.ventooth.swansong.shader.preprocessor.macro.InterpreterValue;
import java.util.List;
import java.util.Map;

public class MacroExpressionInterpreter
extends AbstractParser<InterpreterValue> {
    private final Map<String, Option.Value> defines;

    public static InterpreterValue interpret(String code, Map<String, Option.Value> defines) throws ParserException {
        int commentIndex = code.indexOf("//");
        if (commentIndex >= 0) {
            code = code.substring(0, commentIndex);
        }
        return (InterpreterValue)new MacroExpressionInterpreter(new Lexer(code), defines).parse();
    }

    private MacroExpressionInterpreter(Lexer lexer, Map<String, Option.Value> defines) {
        super(lexer);
        this.defines = defines;
    }

    @Override
    protected InterpreterValue createFunctionCall(String name, List<InterpreterValue> args) throws ParserException {
        throw new ParserException("Macro interpreter cannot process functional macros!");
    }

    @Override
    protected InterpreterValue createVariable(String name) throws ParserException {
        Token lookahead;
        if (this.lexer.hasNext() && name.equals("defined") && (lookahead = this.lexer.peek()).type() == TokenType.Identifier) {
            this.lexer.next();
            return new InterpreterValue.IntValue(this.defines.containsKey(lookahead.text()) ? 1 : 0);
        }
        Option.Value define = this.defines.get(name);
        if (define == null) {
            return new InterpreterValue.IntValue(0);
        }
        return MacroExpressionInterpreter.interpret(define.toString(), this.defines);
    }

    @Override
    protected InterpreterValue createBinaryOperation(InterpreterValue left, InterpreterValue right, AbstractParser.Operator operator) {
        InterpreterValue interpreterValue;
        switch (operator) {
            case And: {
                interpreterValue = new InterpreterValue.IntValue(left.asBool() && right.asBool() ? 1 : 0);
                break;
            }
            case Or: {
                interpreterValue = new InterpreterValue.IntValue(left.asBool() || right.asBool() ? 1 : 0);
                break;
            }
            default: {
                interpreterValue = this.operateUpcast(left, right, operator);
            }
        }
        return interpreterValue;
    }

    @Override
    protected InterpreterValue createIntegerConstant(int value) {
        return new InterpreterValue.IntValue(value);
    }

    @Override
    protected InterpreterValue createFloatConstant(double value) {
        return new InterpreterValue.DoubleValue(value);
    }

    @Override
    protected InterpreterValue createBoolConstant(boolean value) {
        return new InterpreterValue.IntValue(value ? 1 : 0);
    }

    @Override
    protected InterpreterValue createUnaryNot(InterpreterValue value) {
        return new InterpreterValue.IntValue(value.asBool() ? 0 : 1);
    }

    @Override
    protected InterpreterValue createUnaryMinus(InterpreterValue value) {
        if (value instanceof InterpreterValue.IntValue) {
            InterpreterValue.IntValue i = (InterpreterValue.IntValue)value;
            return new InterpreterValue.IntValue(-i.value());
        }
        if (value instanceof InterpreterValue.DoubleValue) {
            InterpreterValue.DoubleValue d = (InterpreterValue.DoubleValue)value;
            return new InterpreterValue.DoubleValue(-d.value());
        }
        throw new AssertionError();
    }

    @Override
    protected InterpreterValue createSwizzle(InterpreterValue value, int swizzleIndex) throws ParserException {
        throw new ParserException("Macro interpreter cannot process vector swizzles!");
    }

    private InterpreterValue operateUpcast(InterpreterValue left, InterpreterValue right, AbstractParser.Operator operator) {
        if (left instanceof InterpreterValue.DoubleValue) {
            InterpreterValue.DoubleValue dl = (InterpreterValue.DoubleValue)left;
            if (right instanceof InterpreterValue.DoubleValue) {
                InterpreterValue.DoubleValue dr = (InterpreterValue.DoubleValue)right;
                return new InterpreterValue.DoubleValue(this.operate(dl.value(), dr.value(), operator));
            }
            return new InterpreterValue.DoubleValue(this.operate(dl.value(), (double)((InterpreterValue.IntValue)right).value(), operator));
        }
        if (right instanceof InterpreterValue.DoubleValue) {
            InterpreterValue.DoubleValue dr = (InterpreterValue.DoubleValue)right;
            return new InterpreterValue.DoubleValue(this.operate((double)((InterpreterValue.IntValue)left).value(), dr.value(), operator));
        }
        return new InterpreterValue.IntValue(this.operate(((InterpreterValue.IntValue)left).value(), ((InterpreterValue.IntValue)right).value(), operator));
    }

    private int operate(int left, int right, AbstractParser.Operator operator) {
        int n;
        switch (operator) {
            case Add: {
                n = left + right;
                break;
            }
            case Sub: {
                n = left - right;
                break;
            }
            case Mul: {
                n = left * right;
                break;
            }
            case Div: {
                n = left / right;
                break;
            }
            case Rem: {
                n = left % right;
                break;
            }
            case Eq: {
                if (left == right) {
                    n = 1;
                    break;
                }
                n = 0;
                break;
            }
            case Ne: {
                if (left != right) {
                    n = 1;
                    break;
                }
                n = 0;
                break;
            }
            case Ge: {
                if (left >= right) {
                    n = 1;
                    break;
                }
                n = 0;
                break;
            }
            case Gt: {
                if (left > right) {
                    n = 1;
                    break;
                }
                n = 0;
                break;
            }
            case Le: {
                if (left <= right) {
                    n = 1;
                    break;
                }
                n = 0;
                break;
            }
            case Lt: {
                if (left < right) {
                    n = 1;
                    break;
                }
                n = 0;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return n;
    }

    private double operate(double left, double right, AbstractParser.Operator operator) {
        double d;
        switch (operator) {
            case Add: {
                d = left + right;
                break;
            }
            case Sub: {
                d = left - right;
                break;
            }
            case Mul: {
                d = left * right;
                break;
            }
            case Div: {
                d = left / right;
                break;
            }
            case Rem: {
                d = left % right;
                break;
            }
            case Eq: {
                if (left == right) {
                    d = 1.0;
                    break;
                }
                d = 0.0;
                break;
            }
            case Ne: {
                if (left != right) {
                    d = 1.0;
                    break;
                }
                d = 0.0;
                break;
            }
            case Ge: {
                if (left >= right) {
                    d = 1.0;
                    break;
                }
                d = 0.0;
                break;
            }
            case Gt: {
                if (left > right) {
                    d = 1.0;
                    break;
                }
                d = 0.0;
                break;
            }
            case Le: {
                if (left <= right) {
                    d = 1.0;
                    break;
                }
                d = 0.0;
                break;
            }
            case Lt: {
                if (left < right) {
                    d = 1.0;
                    break;
                }
                d = 0.0;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return d;
    }
}

