/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader.preprocessor.util;

import com.ventooth.swansong.shader.preprocessor.Option;
import com.ventooth.swansong.shader.preprocessor.TaggedLine;
import com.ventooth.swansong.shader.preprocessor.util.StringUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class CodePrinter {
    private final List<String> prelude;
    private final List<TaggedLine> code;
    private final Int2ObjectMap<Option> opts;
    private final PrintWriter f;
    private int file = -1;
    private int line = -1;
    private int lastContent = -1;
    private final List<String> fragments = new ArrayList<String>(16);
    private static final boolean compact = true;

    public static void printCode(List<String> prelude, List<TaggedLine> code, Int2ObjectMap<Option> opts, PrintWriter writer) {
        new CodePrinter(prelude, code, opts, writer).sourceToOutputStream();
    }

    private void sourceToOutputStream() {
        for (String pStr : this.prelude) {
            this.f.println(pStr);
        }
        int size = this.code.size();
        for (int i = 0; i < size; ++i) {
            String txt;
            TaggedLine tagged = this.code.get(i);
            TaggedLine.Tag tag = tagged.tag();
            boolean lb = tagged.lineBreak();
            Option opt = (Option)this.opts.get(i);
            if (opt != null) {
                if (opt.isToggle() && !opt.isEnabled()) continue;
                txt = null;
            } else {
                txt = tagged.text();
                if (this.processWhitespace(lb, txt)) continue;
            }
            this.fixLineNumbers(tagged);
            if (tag != TaggedLine.Tag.MultilineComment) {
                this.lastContent = this.fragments.size();
            }
            if (opt != null) {
                this.fragments.add(opt.toCode());
            } else {
                this.fragments.add(txt);
            }
            if (!lb) continue;
            this.flushLine();
        }
    }

    private boolean processWhitespace(boolean lb, String txt) {
        int len = txt.length();
        int fnws = StringUtils.firstNonWhitespace(txt, 0, len);
        if (fnws == -1) {
            if (!lb) {
                this.fragments.add(txt);
            } else {
                this.flushLine();
            }
            return true;
        }
        return len - fnws >= 2 && txt.charAt(fnws) == '/' && txt.charAt(fnws + 1) == '/';
    }

    private void fixLineNumbers(TaggedLine tagged) {
        int tFile = tagged.file();
        int tLine = tagged.line();
        if (tFile != this.file) {
            this.flushLine();
            this.f.print("#line ");
            this.f.print(tLine);
            this.f.print(" ");
            this.f.println(tFile);
            this.line = tLine;
            this.file = tFile;
        } else if (tLine != this.line) {
            this.flushLine();
            int delta = tLine - this.line;
            if (delta < 7) {
                for (int j = 0; j < delta; ++j) {
                    this.f.print('\n');
                }
            } else {
                this.f.print("#line ");
                this.f.println(tLine);
            }
            this.line = tLine;
        }
    }

    private void flushLine() {
        if (this.lastContent < 0) {
            this.fragments.clear();
            return;
        }
        int max = Math.min(this.fragments.size() - 1, this.lastContent);
        this.lastContent = -1;
        ++this.line;
        for (int i = 0; i <= max; ++i) {
            String fragment = this.fragments.get(i);
            if (i == max) {
                int lnws = StringUtils.lastNonWhitespace(fragment);
                if (lnws == -1) continue;
                this.f.print(fragment.substring(0, lnws + 1));
                continue;
            }
            this.f.print(fragment);
        }
        this.fragments.clear();
        this.f.print('\n');
    }

    @Generated
    private CodePrinter(List<String> prelude, List<TaggedLine> code, Int2ObjectMap<Option> opts, PrintWriter f) {
        this.prelude = prelude;
        this.code = code;
        this.opts = opts;
        this.f = f;
    }
}

