/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader.preprocessor.util;

import com.ventooth.swansong.shader.preprocessor.util.StringUtils;
import it.unimi.dsi.fastutil.ints.IntList;

public class RenderTargetParser {
    private static final String PREFIX = "/*";
    private static final String DRAWBUFFERS_PREFIX = "DRAWBUFFERS:";
    private static final int DRAWBUFFERS_PREFIX_LEN = "DRAWBUFFERS:".length();
    private static final String RENDERTARGETS_PREFIX = "RENDERTARGETS:";
    private static final int RENDERTARGETS_PREFIX_LEN = "RENDERTARGETS:".length();
    private static final String SUFFIX = "*/";

    public static IntList parseRenderTargetList(String line) {
        int prefixIndex = line.indexOf(PREFIX);
        int suffixIndex = line.indexOf(SUFFIX);
        if (prefixIndex < 0 || suffixIndex < prefixIndex + 2) {
            return null;
        }
        int pos = StringUtils.firstNonWhitespace(line, prefixIndex + 2, line.length());
        int[] indices = line.startsWith(DRAWBUFFERS_PREFIX, pos) ? RenderTargetParser.parseDrawBuffers(line.substring(pos + DRAWBUFFERS_PREFIX_LEN, suffixIndex).trim()) : (line.startsWith(RENDERTARGETS_PREFIX, pos) ? RenderTargetParser.parseRenderTargets(line.substring(pos + RENDERTARGETS_PREFIX_LEN, suffixIndex).trim()) : null);
        if (indices == null) {
            return null;
        }
        return IntList.of((int[])indices);
    }

    private static int[] parseRenderTargets(String data) {
        String[] numbers = data.split(",");
        if (numbers.length == 0) {
            return null;
        }
        int[] indices = new int[numbers.length];
        for (String c : numbers) {
            try {
                indices[i] = Integer.parseInt(c);
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }
        return indices;
    }

    private static int[] parseDrawBuffers(String data) {
        char[] chars = data.toCharArray();
        if (chars.length == 0) {
            return null;
        }
        int[] indices = new int[chars.length];
        for (char c : chars) {
            if (c < '0' || c > '9') {
                return null;
            }
            indices[i] = c - 48;
        }
        return indices;
    }
}

